/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.ezid;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.ezid.EZIDResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZIDRequest {
    private static final Logger log = LoggerFactory.getLogger(EZIDRequest.class);
    private static final String ID_PATH = "/ezid/id/doi:";
    private static final String SHOULDER_PATH = "/ezid/shoulder/doi:";
    private static final String UTF_8 = "UTF-8";
    private static final String MD_KEY_STATUS = "_status";
    private final AbstractHttpClient client;
    private final String scheme;
    private final String host;
    private final String authority;

    EZIDRequest(String scheme, String host, String authority, String username, String password) throws URISyntaxException {
        this.scheme = scheme;
        this.host = host;
        this.authority = authority.charAt(authority.length() - 1) == '/' ? authority.substring(0, authority.length() - 1) : authority;
        this.client = new DefaultHttpClient();
        if (null != username) {
            URI uri = new URI(scheme, host, null, null);
            this.client.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public EZIDResponse lookup(String name) throws IdentifierException, IOException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, ID_PATH + this.authority + name, null);
        log.debug("EZID lookup {}", (Object)uri.toASCIIString());
        HttpGet request = new HttpGet(uri);
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return new EZIDResponse(response);
    }

    public EZIDResponse create(String name, Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, ID_PATH + this.authority + '/' + name, null);
        log.debug("EZID create {}", (Object)uri.toASCIIString());
        HttpPut request = new HttpPut(uri);
        if (null != metadata) {
            try {
                request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return new EZIDResponse(response);
    }

    public EZIDResponse mint(Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, SHOULDER_PATH + this.authority, null);
        log.debug("EZID mint {}", (Object)uri.toASCIIString());
        HttpPost request = new HttpPost(uri);
        if (null != metadata) {
            request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
        }
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        EZIDResponse myResponse = new EZIDResponse(response);
        return myResponse;
    }

    public EZIDResponse modify(String name, Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        if (null == metadata) {
            throw new IllegalArgumentException("metadata must not be null");
        }
        URI uri = new URI(this.scheme, this.host, ID_PATH + this.authority + name, null);
        log.debug("EZID modify {}", (Object)uri.toASCIIString());
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return new EZIDResponse(response);
    }

    public EZIDResponse delete(String name) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, ID_PATH + this.authority + name, null);
        log.debug("EZID delete {}", (Object)uri.toASCIIString());
        HttpDelete request = new HttpDelete(uri);
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return new EZIDResponse(response);
    }

    public EZIDResponse withdraw(String name) throws IOException, IdentifierException, URISyntaxException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(MD_KEY_STATUS, "unavailable");
        return this.modify(name, metadata);
    }

    public EZIDResponse withdraw(String name, String reason) throws IOException, IdentifierException, URISyntaxException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(MD_KEY_STATUS, "unavailable | " + EZIDRequest.escape(reason));
        return this.modify(name, metadata);
    }

    private static String formatMetadata(Map<String, String> raw) {
        StringBuilder formatted = new StringBuilder();
        for (Map.Entry<String, String> entry : raw.entrySet()) {
            formatted.append(EZIDRequest.escape(entry.getKey())).append(": ").append(EZIDRequest.escape(entry.getValue())).append('\n');
        }
        return formatted.toString();
    }

    private static String escape(String s) {
        if (null == s) {
            return s;
        }
        return s.replace("%", "%25").replace("\n", "%0A").replace("\r", "%0D").replace(":", "%3A");
    }
}

