/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.usage;

import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.LogManager;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;

public class LoggerUsageEventListener
extends AbstractUsageEventListener {
    private static Logger log = Logger.getLogger(LoggerUsageEventListener.class);

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent && !(event instanceof UsageSearchEvent)) {
            UsageEvent ue = (UsageEvent)event;
            log.info((Object)LogManager.getHeader(ue.getContext(), LoggerUsageEventListener.formatAction(ue.getAction(), ue.getObject()), LoggerUsageEventListener.formatMessage(ue.getObject())));
        }
    }

    private static String formatAction(UsageEvent.Action action, DSpaceObject object) {
        try {
            String objText = Constants.typeText[object.getType()].toLowerCase();
            return action.text() + "_" + objText;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String formatMessage(DSpaceObject object) {
        try {
            String objText = Constants.typeText[object.getType()].toLowerCase();
            String handle = object.getHandle();
            if (handle != null && object instanceof Item) {
                return "handle=" + object.getHandle();
            }
            return objText + "_id=" + object.getID();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

