/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dspace.app.mediafilter.Brand;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.dspace.core.ConfigurationManager;

public class BrandedPreviewJPEGFilter
extends MediaFilter {
    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".preview.jpg";
    }

    @Override
    public String getBundleName() {
        return "BRANDED_PREVIEW";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Branded Preview";
    }

    @Override
    public InputStream getDestinationStream(InputStream source) throws Exception {
        float scaleFactor;
        BufferedImage buf = ImageIO.read(source);
        float xmax = ConfigurationManager.getIntProperty("webui.preview.maxwidth");
        float ymax = ConfigurationManager.getIntProperty("webui.preview.maxheight");
        boolean blurring = ConfigurationManager.getBooleanProperty("webui.preview.blurring");
        boolean hqscaling = ConfigurationManager.getBooleanProperty("webui.preview.hqscaling");
        int brandHeight = ConfigurationManager.getIntProperty("webui.preview.brand.height");
        String brandFont = ConfigurationManager.getProperty("webui.preview.brand.font");
        int brandFontPoint = ConfigurationManager.getIntProperty("webui.preview.brand.fontpoint");
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (MediaFilterManager.isVerbose) {
            System.out.println("original size: " + xsize + "," + ysize);
        }
        if (xsize > xmax) {
            scaleFactor = xmax / xsize;
            if (MediaFilterManager.isVerbose) {
                System.out.println("x scale factor: " + scaleFactor);
            }
            xsize *= scaleFactor;
            ysize *= scaleFactor;
            if (MediaFilterManager.isVerbose) {
                System.out.println("new size: " + xsize + "," + ysize);
            }
        }
        if (ysize > ymax) {
            scaleFactor = ymax / ysize;
            xsize *= scaleFactor;
            ysize *= scaleFactor;
        }
        if (MediaFilterManager.isVerbose) {
            System.out.println("created thumbnail size: " + xsize + ", " + ysize);
        }
        BufferedImage branded = new BufferedImage((int)xsize, (int)ysize + brandHeight, 1);
        if (blurring) {
            buf = this.getBlurredInstance(buf);
        }
        if (hqscaling) {
            buf = this.getScaledInstance(buf, (int)xsize, (int)ysize, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        }
        Graphics2D g2d = branded.createGraphics();
        g2d.drawImage(buf, 0, 0, (int)xsize, (int)ysize, null);
        Brand brand = new Brand((int)xsize, brandHeight, new Font(brandFont, 0, brandFontPoint), 5);
        BufferedImage brandImage = brand.create(ConfigurationManager.getProperty("webui.preview.brand"), ConfigurationManager.getProperty("webui.preview.brand.abbrev"), MediaFilterManager.getCurrentItem() == null ? "" : "hdl:" + MediaFilterManager.getCurrentItem().getHandle());
        g2d.drawImage(brandImage, 0, (int)ysize, (int)xsize, 20, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)branded, "jpeg", baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    public BufferedImage getNormalizedInstance(BufferedImage buf) {
        int type = buf.getTransparency() == 1 ? 1 : 3;
        int w = buf.getWidth();
        int h = buf.getHeight();
        BufferedImage normal = new BufferedImage(w, h, type);
        Graphics2D g2d = normal.createGraphics();
        g2d.drawImage(buf, 0, 0, w, h, Color.WHITE, null);
        g2d.dispose();
        return normal;
    }

    public BufferedImage getBlurredInstance(BufferedImage buf) {
        buf = this.getNormalizedInstance(buf);
        float[] matrix = new float[]{0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f};
        ConvolveOp blur = new ConvolveOp(new Kernel(3, 3, matrix));
        BufferedImage blurbuf = blur.filter(buf, null);
        return blurbuf;
    }

    public BufferedImage getScaledInstance(BufferedImage buf, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = buf.getTransparency() == 1 ? 1 : 2;
        BufferedImage scalebuf = buf;
        if (higherQuality) {
            w = buf.getWidth();
            h = buf.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2d = tmp.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2d.drawImage(scalebuf, 0, 0, w, h, Color.WHITE, null);
            g2d.dispose();
            scalebuf = tmp;
        } while (w != targetWidth || h != targetHeight);
        return scalebuf;
    }
}

