/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.apache.log4j.Logger;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.core.ConfigurationManager;

public class InitializeBrowseDatabase {
    private static Logger log = Logger.getLogger(InitializeBrowseDatabase.class);

    public static void main(String[] argv) {
        if (argv.length != 1) {
            log.warn((Object)"Schema file not specified");
            System.exit(1);
        }
        ConfigurationManager.loadConfig(null);
        log.info((Object)"Initializing Browse Database");
        try {
            if ("clean-database.sql".equals(argv[0])) {
                try {
                    IndexBrowse browse = new IndexBrowse();
                    browse.setDelete(true);
                    browse.setExecute(true);
                    browse.clearDatabase();
                }
                catch (BrowseException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            try {
                IndexBrowse browse = new IndexBrowse();
                browse.setRebuild(true);
                browse.setExecute(true);
                browse.initBrowse();
            }
            catch (BrowseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage(), e);
            }
            System.exit(0);
        }
        catch (Exception e) {
            log.fatal((Object)"Caught exception:", (Throwable)e);
            System.exit(1);
        }
    }
}

