/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.AbstractPackagerWrappingCrosswalk;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.RoleDisseminator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class RoleCrosswalk
extends AbstractPackagerWrappingCrosswalk
implements IngestionCrosswalk,
DisseminationCrosswalk {
    private static final String ROLE_PACKAGER_PLUGIN = "DSPACE-ROLES";

    @Override
    public Namespace[] getNamespaces() {
        Namespace[] result = new Namespace[]{RoleDisseminator.DSROLES_NS};
        return result;
    }

    @Override
    public String getSchemaLocation() {
        return "";
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 5 || dso.getType() == 4 || dso.getType() == 3;
    }

    @Override
    public boolean preferList() {
        return false;
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element dim = this.disseminateElement(dso);
        return dim.getChildren();
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        try {
            PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, ROLE_PACKAGER_PLUGIN);
            if (dip == null) {
                throw new CrosswalkInternalException("Cannot find a PackageDisseminator plugin named DSPACE-ROLES");
            }
            String tempDirectory = ConfigurationManager.getProperty("upload.temp.dir") != null ? ConfigurationManager.getProperty("upload.temp.dir") : System.getProperty("java.io.tmpdir");
            File tempFile = File.createTempFile("RoleCrosswalkDisseminate" + dso.hashCode(), null, new File(tempDirectory));
            tempFile.deleteOnExit();
            PackageParameters pparams = this.getPackagingParameters() != null ? this.getPackagingParameters() : new PackageParameters();
            Context context = new Context();
            dip.disseminate(context, dso, pparams, tempFile);
            context.complete();
            if (tempFile.exists() && tempFile.length() == 0L) {
                return null;
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                Document xmlDocument = builder.build(tempFile);
                if (xmlDocument != null && xmlDocument.hasRootElement()) {
                    return xmlDocument.getRootElement();
                }
                return null;
            }
            catch (JDOMException je) {
                throw new MetadataValidationException("Error parsing Roles XML (see wrapped error message for more details) ", je);
            }
        }
        catch (PackageException pe) {
            throw new CrosswalkInternalException("Failed to export Roles via packager (see wrapped error message for more details) ", pe);
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (!metadata.isEmpty()) {
            this.ingest(context, dso, metadata.get(0).getParentElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3) {
            throw new CrosswalkObjectNotSupported("Role crosswalk only valid for Site, Community or Collection");
        }
        PackageIngester sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, ROLE_PACKAGER_PLUGIN);
        if (sip == null) {
            throw new CrosswalkInternalException("Cannot find a PackageIngester plugin named DSPACE-ROLES");
        }
        PackageParameters pparams = this.getPackagingParameters() != null ? this.getPackagingParameters() : new PackageParameters();
        String license = null;
        if (this.getIngestionLicense() != null) {
            license = this.getIngestionLicense();
        }
        String tempDirectory = ConfigurationManager.getProperty("upload.temp.dir") != null ? ConfigurationManager.getProperty("upload.temp.dir") : System.getProperty("java.io.tmpdir");
        File tempFile = File.createTempFile("RoleCrosswalkIngest" + dso.hashCode(), null, new File(tempDirectory));
        tempFile.deleteOnExit();
        FileOutputStream fileOutStream = null;
        try {
            fileOutStream = new FileOutputStream(tempFile);
            XMLOutputter writer = new XMLOutputter();
            writer.output(root, (OutputStream)fileOutStream);
        }
        finally {
            if (fileOutStream != null) {
                fileOutStream.close();
            }
        }
        try {
            sip.ingest(context, dso, tempFile, pparams, license);
        }
        catch (PackageException e) {
            throw new CrosswalkInternalException(e);
        }
    }
}

