/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.mail.MessagingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.search.Harvest;
import org.dspace.search.HarvestedItemInfo;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Subscribe {
    private static Logger log = Logger.getLogger(Subscribe.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void subscribe(Context context, EPerson eperson, Collection collection) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context) && (context.getCurrentUser() == null || context.getCurrentUser().getID() != eperson.getID())) throw new AuthorizeException("Only admin or e-person themselves can subscribe");
        TableRowIterator r = DatabaseManager.query(context, "SELECT * FROM subscription WHERE eperson_id= ?  AND collection_id= ? ", eperson.getID(), collection.getID());
        try {
            if (r.hasNext()) return;
            TableRow row = DatabaseManager.row("subscription");
            row.setColumn("eperson_id", eperson.getID());
            row.setColumn("collection_id", collection.getID());
            DatabaseManager.insert(context, row);
            log.info((Object)LogManager.getHeader(context, "subscribe", "eperson_id=" + eperson.getID() + ",collection_id=" + collection.getID()));
            return;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public static void unsubscribe(Context context, EPerson eperson, Collection collection) throws SQLException, AuthorizeException {
        if (AuthorizeManager.isAdmin(context) || context.getCurrentUser() != null && context.getCurrentUser().getID() == eperson.getID()) {
            if (collection == null) {
                DatabaseManager.updateQuery(context, "DELETE FROM subscription WHERE eperson_id= ? ", eperson.getID());
            } else {
                DatabaseManager.updateQuery(context, "DELETE FROM subscription WHERE eperson_id= ? AND collection_id= ? ", eperson.getID(), collection.getID());
                log.info((Object)LogManager.getHeader(context, "unsubscribe", "eperson_id=" + eperson.getID() + ",collection_id=" + collection.getID()));
            }
        } else {
            throw new AuthorizeException("Only admin or e-person themselves can unsubscribe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection[] getSubscriptions(Context context, EPerson eperson) throws SQLException {
        TableRowIterator tri = DatabaseManager.query(context, "SELECT collection_id FROM subscription WHERE eperson_id= ? ", eperson.getID());
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                collections.add(Collection.find(context, row.getIntColumn("collection_id")));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collArray = new Collection[collections.size()];
        return collections.toArray(collArray);
    }

    public static Collection[] getAvailableSubscriptions(Context context) throws SQLException {
        return Subscribe.getAvailableSubscriptions(context, null);
    }

    public static Collection[] getAvailableSubscriptions(Context context, EPerson eperson) throws SQLException {
        if (eperson != null) {
            context.setCurrentUser(eperson);
        }
        Site site = (Site)Site.find(context, 0);
        Collection[] collections = Collection.findAuthorized(context, null, 3);
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSubscribed(Context context, EPerson eperson, Collection collection) throws SQLException {
        TableRowIterator tri = DatabaseManager.query(context, "SELECT * FROM subscription WHERE eperson_id= ? AND collection_id= ? ", eperson.getID(), collection.getID());
        try {
            boolean bl = tri.hasNext();
            return bl;
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processDaily(Context context, boolean test) throws SQLException, IOException {
        TableRowIterator tri = DatabaseManager.query(context, "SELECT * FROM subscription ORDER BY eperson_id", new Object[0]);
        EPerson currentEPerson = null;
        ArrayList<Collection> collections = null;
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                if (currentEPerson == null || row.getIntColumn("eperson_id") != currentEPerson.getID()) {
                    if (currentEPerson != null) {
                        try {
                            Subscribe.sendEmail(context, currentEPerson, collections, test);
                        }
                        catch (MessagingException me) {
                            log.error((Object)("Failed to send subscription to eperson_id=" + currentEPerson.getID()));
                            log.error((Object)me);
                        }
                    }
                    currentEPerson = EPerson.find(context, row.getIntColumn("eperson_id"));
                    collections = new ArrayList<Collection>();
                }
                collections.add(Collection.find(context, row.getIntColumn("collection_id")));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        if (currentEPerson != null) {
            try {
                Subscribe.sendEmail(context, currentEPerson, collections, test);
            }
            catch (MessagingException me) {
                log.error((Object)("Failed to send subscription to eperson_id=" + currentEPerson.getID()));
                log.error((Object)me);
            }
        }
    }

    public static void sendEmail(Context context, EPerson eperson, List<Collection> collections, boolean test) throws IOException, MessagingException, SQLException {
        Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
        ResourceBundle labels = ResourceBundle.getBundle("Messages", supportedLocale);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(new Date());
        cal.add(10, -24);
        Date thisTimeYesterday = cal.getTime();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date midnightYesterday = cal.getTime();
        StringBuffer emailText = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < collections.size(); ++i) {
            Collection c = collections.get(i);
            try {
                boolean includeAll = ConfigurationManager.getBooleanProperty("harvest.includerestricted.subscription", true);
                List<HarvestedItemInfo> itemInfos = Harvest.harvest(context, c, new DCDate(midnightYesterday).toString(), null, 0, 0, true, false, false, includeAll);
                itemInfos = ConfigurationManager.getBooleanProperty("eperson.subscription.onlynew", false) ? Subscribe.filterOutModified(itemInfos) : Subscribe.filterOutToday(itemInfos);
                if (itemInfos.size() <= 0) continue;
                if (!isFirst) {
                    emailText.append("\n---------------------------------------\n");
                } else {
                    isFirst = false;
                }
                emailText.append(labels.getString("org.dspace.eperson.Subscribe.new-items")).append(" ").append(c.getMetadata("name")).append(": ").append(itemInfos.size()).append("\n\n");
                for (int j = 0; j < itemInfos.size(); ++j) {
                    HarvestedItemInfo hii = itemInfos.get(j);
                    DCValue[] titles = hii.item.getDC("title", null, "*");
                    emailText.append("      ").append(labels.getString("org.dspace.eperson.Subscribe.title")).append(" ");
                    if (titles.length > 0) {
                        emailText.append(titles[0].value);
                    } else {
                        emailText.append(labels.getString("org.dspace.eperson.Subscribe.untitled"));
                    }
                    DCValue[] authors = hii.item.getDC("contributor", "*", "*");
                    if (authors.length > 0) {
                        emailText.append("\n    ").append(labels.getString("org.dspace.eperson.Subscribe.authors")).append(" ").append(authors[0].value);
                        for (int k = 1; k < authors.length; ++k) {
                            emailText.append("\n             ").append(authors[k].value);
                        }
                    }
                    emailText.append("\n         ").append(labels.getString("org.dspace.eperson.Subscribe.id")).append(" ").append(HandleManager.getCanonicalForm(hii.handle)).append("\n\n");
                }
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (emailText.length() > 0) {
            if (test) {
                log.info((Object)LogManager.getHeader(context, "subscription:", "eperson=" + eperson.getEmail()));
                log.info((Object)LogManager.getHeader(context, "subscription:", "text=" + emailText.toString()));
            } else {
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "subscription"));
                email.addRecipient(eperson.getEmail());
                email.addArgument(emailText.toString());
                email.send();
                log.info((Object)LogManager.getHeader(context, "sent_subscription", "eperson_id=" + eperson.getID()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        boolean test;
        String usage = "org.dspace.eperson.Subscribe [-t] or nothing to send out subscriptions.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        Option opt = new Option("t", "test", false, "Run test session");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("h", "help", false, "Print this help message");
        opt.setRequired(false);
        options.addOption(opt);
        try {
            line = new PosixParser().parse(options, argv);
        }
        catch (Exception e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        if (line.hasOption("h")) {
            formatter.printHelp(usage, options);
            System.exit(1);
        }
        if (test = line.hasOption("t")) {
            log.setLevel(Level.DEBUG);
        }
        Context context = null;
        try {
            context = new Context();
            Subscribe.processDaily(context, test);
            context.complete();
        }
        catch (Exception e) {
            log.fatal((Object)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    private static List<HarvestedItemInfo> filterOutToday(List<HarvestedItemInfo> completeList) {
        log.debug((Object)("Filtering out all today item to leave new items list size=" + completeList.size()));
        ArrayList<HarvestedItemInfo> filteredList = new ArrayList<HarvestedItemInfo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String today = sdf.format(new Date());
        Date thisTimeYesterday = new Date(System.currentTimeMillis() - 86400000L);
        String yesterday = sdf.format(thisTimeYesterday);
        block0: for (HarvestedItemInfo infoObject : completeList) {
            Date lastUpdate = infoObject.item.getLastModified();
            String lastUpdateStr = sdf.format(lastUpdate);
            if (lastUpdateStr.equals(today)) {
                DCValue[] dateAccArr = infoObject.item.getMetadata("dc", "date", "accessioned", "*");
                if (dateAccArr != null && dateAccArr.length > 0) {
                    for (DCValue date : dateAccArr) {
                        if (date == null || date.value == null) continue;
                        if (date.value.startsWith(yesterday)) {
                            filteredList.add(infoObject);
                            log.debug((Object)("adding : " + dateAccArr[0].value + " : " + today + " : " + infoObject.handle));
                            continue block0;
                        }
                        log.debug((Object)("ignoring : " + dateAccArr[0].value + " : " + today + " : " + infoObject.handle));
                    }
                    continue;
                }
                log.debug((Object)("no date accessioned, adding  : " + infoObject.handle));
                filteredList.add(infoObject);
                continue;
            }
            filteredList.add(infoObject);
        }
        return filteredList;
    }

    private static List<HarvestedItemInfo> filterOutModified(List<HarvestedItemInfo> completeList) {
        log.debug((Object)("Filtering out all modified to leave new items list size=" + completeList.size()));
        ArrayList<HarvestedItemInfo> filteredList = new ArrayList<HarvestedItemInfo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date thisTimeYesterday = new Date(System.currentTimeMillis() - 86400000L);
        String yesterday = sdf.format(thisTimeYesterday);
        block0: for (HarvestedItemInfo infoObject : completeList) {
            DCValue[] dateAccArr = infoObject.item.getMetadata("dc", "date", "accessioned", "*");
            if (dateAccArr != null && dateAccArr.length > 0) {
                for (DCValue date : dateAccArr) {
                    if (date == null || date.value == null) continue;
                    if (date.value.startsWith(yesterday)) {
                        filteredList.add(infoObject);
                        log.debug((Object)("adding : " + dateAccArr[0].value + " : " + yesterday + " : " + infoObject.handle));
                        continue block0;
                    }
                    log.debug((Object)("ignoring : " + dateAccArr[0].value + " : " + yesterday + " : " + infoObject.handle));
                }
                continue;
            }
            log.debug((Object)("no date accessioned, adding  : " + infoObject.handle));
            filteredList.add(infoObject);
        }
        return filteredList;
    }
}

