/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import mockit.UsingMocksAndStubs;
import org.apache.log4j.Logger;
import org.dspace.administer.MetadataImporter;
import org.dspace.administer.RegistryImportException;
import org.dspace.administer.RegistryLoader;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.browse.MockBrowseCreateDAOOracle;
import org.dspace.content.MetadataField;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.MockIndexEventConsumer;
import org.dspace.eperson.EPerson;
import org.dspace.search.DSIndexer;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.storage.rdbms.MockDatabaseManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.xml.sax.SAXException;

@UsingMocksAndStubs(value={MockDatabaseManager.class, MockBrowseCreateDAOOracle.class, MockIndexEventConsumer.class})
public class AbstractUnitTest {
    private static Logger log = Logger.getLogger(AbstractUnitTest.class);
    protected static Properties testProps;
    protected Context context;
    protected static EPerson eperson;
    protected static DSpaceKernelImpl kernelImpl;

    @BeforeClass
    public static void initOnce() {
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("Europe/Dublin"));
            testProps = new Properties();
            URL properties = AbstractUnitTest.class.getClassLoader().getResource("test-config.properties");
            testProps.load(properties.openStream());
            ConfigurationManager.loadConfig(null);
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start(ConfigurationManager.getProperty((String)"dspace.dir"));
            }
            Context ctx = new Context();
            ctx.turnOffAuthorisationSystem();
            if (MetadataField.find((Context)ctx, (int)1) == null) {
                String base = ConfigurationManager.getProperty((String)"dspace.dir") + File.separator + "config" + File.separator + "registries" + File.separator;
                RegistryLoader.loadBitstreamFormats((Context)ctx, (String)(base + "bitstream-formats.xml"));
                MetadataImporter.loadRegistry((String)(base + "dublin-core-types.xml"), (boolean)true);
                MetadataImporter.loadRegistry((String)(base + "sword-metadata.xml"), (boolean)true);
                ctx.commit();
                eperson = EPerson.find((Context)ctx, (int)1);
                if (eperson == null) {
                    eperson = EPerson.create((Context)ctx);
                    eperson.setFirstName("first");
                    eperson.setLastName("last");
                    eperson.setEmail("test@email.com");
                    eperson.setCanLogIn(true);
                    eperson.setLanguage(I18nUtil.getDefaultLocale().getLanguage());
                }
                DSIndexer.cleanIndex((Context)ctx);
                DSIndexer.createIndex((Context)ctx);
                ctx.commit();
                IndexBrowse indexer = new IndexBrowse(ctx);
                indexer.setRebuild(true);
                indexer.setExecute(true);
                indexer.initBrowse();
            }
            ctx.restoreAuthSystemState();
            if (ctx.isValid()) {
                ctx.complete();
            }
            Object var1_10 = null;
        }
        catch (BrowseException ex) {
            log.error((Object)"Error creating the browse indexes", (Throwable)ex);
            Assert.fail((String)"Error creating the browse indexes");
        }
        catch (RegistryImportException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (NonUniqueMetadataException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (ParserConfigurationException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (SAXException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (TransformerException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Error loading default data", (Throwable)ex);
            Assert.fail((String)"Error loading default data");
        }
        catch (SQLException ex) {
            log.error((Object)"Error initializing the database", (Throwable)ex);
            Assert.fail((String)"Error initializing the database");
        }
        catch (IOException ex) {
            log.error((Object)"Error initializing tests", (Throwable)ex);
            Assert.fail((String)"Error initializing tests");
        }
    }

    @Before
    public void init() {
        try {
            this.context = new Context();
            this.context.setCurrentUser(eperson);
            this.context.commit();
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            Assert.fail((String)"SQL Error on AbstractUnitTest init()");
        }
    }

    @After
    public void destroy() {
        if (this.context != null && this.context.isValid()) {
            this.context.abort();
            this.context = null;
        }
    }

    @AfterClass
    public static void destroyOnce() {
        testProps.clear();
        testProps = null;
    }
}

