/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.util.ArrayList;
import org.dspace.AbstractUnitTest;
import org.dspace.authenticate.IPMatcher;
import org.dspace.authenticate.IPMatcherException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IPMatcherTest
extends AbstractUnitTest {
    private static final String IP6_FULL_ADDRESS1 = "2001:18e8:3:171:218:8bff:fe2a:56a4";
    private static final String IP6_FULL_ADDRESS2 = "2001:18e8:3:171:218:8bff:fe2a:56a3";
    private static final String IP6_MASKED_ADDRESS = "2001:18e8:3::/48";
    private static final int increment = 6;
    private static IPMatcher ip6FullMatcher;
    private static IPMatcher ip6MaskedMatcher;

    @BeforeClass
    public static void setUp() throws IPMatcherException {
        ip6FullMatcher = new IPMatcher(IP6_FULL_ADDRESS1);
        ip6MaskedMatcher = new IPMatcher(IP6_MASKED_ADDRESS);
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6Incomplete() throws IPMatcherException {
        new IPMatcher("1234:5");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6MaskOutOfRange() throws IPMatcherException {
        new IPMatcher("123::456/999");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6MaskNotNumeric() throws IPMatcherException {
        new IPMatcher("123::456/abc");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6TooManySlashes() throws IPMatcherException {
        new IPMatcher("123::456/12/12");
    }

    @Test
    public void testIp6FullMatch() throws IPMatcherException {
        Assert.assertTrue((String)"IPv6 full match fails", (boolean)ip6FullMatcher.match(IP6_FULL_ADDRESS1));
    }

    @Test
    public void testIp6MisMatch() throws IPMatcherException {
        Assert.assertFalse((String)"IPv6 full nonmatch succeeds", (boolean)ip6FullMatcher.match(IP6_FULL_ADDRESS2));
    }

    @Test
    public void testIp6MaskedMatch() throws IPMatcherException {
        Assert.assertTrue((String)"IPv6 masked match fails", (boolean)ip6MaskedMatcher.match(IP6_FULL_ADDRESS2));
    }

    @Test
    public void testIPv4MatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("1.1.1.1");
        Assert.assertTrue((boolean)ipMatcher.match("1.1.1.1"));
        ArrayList<String> exceptions = new ArrayList<String>();
        exceptions.add("1.1.1.1");
        this.verifyAllIp4Except(exceptions, false, ipMatcher);
    }

    @Test
    public void testIPv4MatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("1.1.1.1");
        Assert.assertFalse((boolean)ipMatcher.match("1.1.1.0"));
    }

    @Test
    public void testIPv6MatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("::2");
        Assert.assertTrue((boolean)ipMatcher.match("0:0:0:0:0:0:0:2"));
    }

    @Test
    public void testShortFormIPv6MatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("::2");
        Assert.assertTrue((boolean)ipMatcher.match("::2"));
    }

    @Test
    public void testIPv6MatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("::2");
        Assert.assertFalse((boolean)ipMatcher.match("0:0:0:0:0:0:0:1"));
    }

    @Test
    public void testAsteriskMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("172.16");
        Assert.assertTrue((boolean)ipMatcher.match("172.16.1.1"));
    }

    @Test
    public void testAsteriskMatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("172.16");
        Assert.assertFalse((boolean)ipMatcher.match("172.15.255.255"));
    }

    @Test
    public void testIPv4CIDRMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.1.2.3/8");
        Assert.assertTrue((boolean)ipMatcher.match("192.1.1.1"));
    }

    @Test
    public void testIPv4CIDRMatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.1.2.3/8");
        Assert.assertTrue((boolean)ipMatcher.match("192.2.0.0"));
    }

    @Test
    public void test2IPv4CIDRMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.86.100.72/29");
        Assert.assertTrue((boolean)ipMatcher.match("192.86.100.75"));
        Assert.assertFalse((boolean)ipMatcher.match("192.86.100.71"));
        Assert.assertFalse((boolean)ipMatcher.match("192.86.100.80"));
        ArrayList<String> exceptions = new ArrayList<String>();
        exceptions.add("192.86.100.72");
        exceptions.add("192.86.100.73");
        exceptions.add("192.86.100.74");
        exceptions.add("192.86.100.75");
        exceptions.add("192.86.100.76");
        exceptions.add("192.86.100.77");
        exceptions.add("192.86.100.78");
        exceptions.add("192.86.100.79");
        this.verifyAllIp4Except(exceptions, false, ipMatcher);
    }

    @Test
    public void test3IPv4CIDRMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.86.100.72/255.255.255.248");
        Assert.assertTrue((boolean)ipMatcher.match("192.86.100.75"));
        Assert.assertFalse((boolean)ipMatcher.match("192.86.100.71"));
        Assert.assertFalse((boolean)ipMatcher.match("192.86.100.80"));
        ArrayList<String> exceptions = new ArrayList<String>();
        exceptions.add("192.86.100.72");
        exceptions.add("192.86.100.73");
        exceptions.add("192.86.100.74");
        exceptions.add("192.86.100.75");
        exceptions.add("192.86.100.76");
        exceptions.add("192.86.100.77");
        exceptions.add("192.86.100.78");
        exceptions.add("192.86.100.79");
        this.verifyAllIp4Except(exceptions, false, ipMatcher);
    }

    @Test
    public void testIPv6CIDRMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("0:0:0:1::/64");
        Assert.assertTrue((boolean)ipMatcher.match("0:0:0:1:ffff:ffff:ffff:ffff"));
    }

    @Test
    public void testIPv6CIDRMatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("0:0:0:1::/64");
        Assert.assertFalse((boolean)ipMatcher.match("0:0:0:2::"));
    }

    @Test
    public void testIPv4IPv6Matching() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("0.0.0.1");
        Assert.assertTrue((boolean)ipMatcher.match("::1"));
    }

    @Test
    public void testSubnetZeroIPv6CIDRMatching() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("::1/0");
        Assert.assertTrue((boolean)ipMatcher.match("::2"));
    }

    @Test
    public void testAllOnesSubnetIPv4CIDRMatchingSuccess() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.1.2.3/32");
        Assert.assertTrue((boolean)ipMatcher.match("192.1.2.3"));
    }

    @Test
    public void testAllOnesSubnetIPv4CIDRMatchingFailure() throws Exception {
        IPMatcher ipMatcher = new IPMatcher("192.1.2.3/32");
        Assert.assertFalse((boolean)ipMatcher.match("192.1.2.2"));
    }

    private ArrayList<String> getAllIp4Except(ArrayList<String> exceptions) {
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        int d4 = 0;
        ArrayList<String> ips = new ArrayList<String>();
        for (d1 = 0; d1 <= 255; d1 += 6) {
            for (d2 = 0; d2 <= 255; d2 += 6) {
                for (d3 = 0; d3 <= 255; d3 += 6) {
                    for (d4 = 0; d4 <= 255; d4 += 6) {
                        String IP = d1 + "." + d2 + "." + d3 + "." + d4;
                        if (exceptions != null && exceptions.contains(IP)) continue;
                        ips.add(IP);
                    }
                }
            }
        }
        return ips;
    }

    private void verifyAllIp4Except(ArrayList<String> exceptions, boolean asserted, IPMatcher ipMatcher) throws IPMatcherException {
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        int d4 = 0;
        for (d1 = 0; d1 <= 255; d1 += 6) {
            for (d2 = 0; d2 <= 255; d2 += 6) {
                for (d3 = 0; d3 <= 255; d3 += 6) {
                    for (d4 = 0; d4 <= 255; d4 += 6) {
                        String IP = d1 + "." + d2 + "." + d3 + "." + d4;
                        if (exceptions != null && exceptions.contains(IP)) {
                            if (asserted) {
                                Assert.assertFalse((boolean)ipMatcher.match(IP));
                                continue;
                            }
                            Assert.assertTrue((boolean)ipMatcher.match(IP));
                            continue;
                        }
                        if (asserted) {
                            Assert.assertTrue((boolean)ipMatcher.match(IP));
                            continue;
                        }
                        Assert.assertFalse((boolean)ipMatcher.match(IP));
                    }
                }
            }
        }
    }

    @AfterClass
    public static void cleanup() {
        ip6FullMatcher = null;
        ip6MaskedMatcher = null;
    }
}

