/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mockit.Mock;
import mockit.MockClass;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseCreateDAOOracle;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseException;
import org.dspace.browse.MappingResults;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

@MockClass(realClass=BrowseCreateDAOOracle.class)
public class MockBrowseCreateDAOOracle {
    private static Logger log = Logger.getLogger(MockBrowseCreateDAOOracle.class);
    protected Context internalContext;
    protected BrowseDAOUtils utils;

    @Mock
    public void $init(Context ctx) {
    }

    protected void cleanContext() {
        try {
            if (this.internalContext != null && this.internalContext.isValid()) {
                this.internalContext.complete();
            }
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Exception cleaning Mock BrowseCreateDAOOracle", (Throwable)ex);
        }
    }

    private void checkContext() {
        try {
            if (this.internalContext == null || !this.internalContext.isValid()) {
                this.internalContext = new Context();
            }
            this.utils = BrowseDAOFactory.getUtils((Context)this.internalContext);
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Exception checkContext BrowseCreateDAOOracle", (Throwable)ex);
        }
        catch (BrowseException ex) {
            log.error((Object)"Browse Exception checkContext BrowseCreateDAOOracle", (Throwable)ex);
        }
    }

    @Mock
    public String createCollectionView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createColView = "CREATE VIEW " + view + " AS " + "SELECT Collection2Item.collection_id, " + table + ".* " + "FROM  " + table + ", Collection2Item " + "WHERE " + table + ".item_id = Collection2Item.item_id";
            if (execute) {
                DatabaseManager.updateQuery((Context)this.internalContext, (String)createColView, (Object[])new Object[0]);
            }
            return createColView + ";";
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
    }

    @Mock
    public String createCommunityView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createComView = "CREATE VIEW " + view + " AS " + "SELECT Communities2Item.community_id, " + table + ".* " + "FROM  " + table + ", Communities2Item " + "WHERE " + table + ".item_id = Communities2Item.item_id";
            if (execute) {
                DatabaseManager.updateQuery((Context)this.internalContext, (String)createComView, (Object[])new Object[0]);
            }
            return createComView + ";";
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
    }

    @Mock
    public String[] createDatabaseIndices(String table, List<Integer> sortCols, boolean value, boolean execute) throws BrowseException {
        try {
            this.checkContext();
            ArrayList<String> array = new ArrayList<String>();
            array.add("CREATE INDEX " + table + "_item_id_idx ON " + table + "(item_id)");
            if (value) {
                array.add("CREATE INDEX " + table + "_value_idx ON " + table + "(sort_value)");
            }
            for (Integer i : sortCols) {
                array.add("CREATE INDEX " + table + "_s" + i + "_idx ON " + table + "(sort_" + i + ")");
            }
            if (execute) {
                for (String query : array) {
                    DatabaseManager.updateQuery((Context)this.internalContext, (String)query, (Object[])new Object[0]);
                }
            }
            String[] arr = new String[array.size()];
            String[] stringArray = array.toArray(arr);
            return stringArray;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String[] createMapIndices(String disTable, String mapTable, boolean execute) throws BrowseException {
        try {
            this.checkContext();
            String[] arr = new String[]{"CREATE INDEX " + disTable + "_svalue_idx ON " + disTable + "(sort_value)", "CREATE INDEX " + disTable + "_value_idx ON " + disTable + "(value)", "CREATE INDEX " + disTable + "_uvalue_idx ON " + disTable + "(value)", "CREATE INDEX " + mapTable + "_item_id_idx ON " + mapTable + "(item_id)", "CREATE INDEX " + mapTable + "_dist_idx ON " + mapTable + "(distinct_id)"};
            if (execute) {
                for (String query : arr) {
                    DatabaseManager.updateQuery((Context)this.internalContext, (String)query, (Object[])new Object[0]);
                }
            }
            String[] stringArray = arr;
            return stringArray;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String createDistinctMap(String table, String map, boolean execute) throws BrowseException {
        try {
            this.checkContext();
            String create = "CREATE TABLE " + map + " (" + "map_id NUMBER PRIMARY KEY, " + "item_id NUMBER REFERENCES item(item_id), " + "distinct_id NUMBER REFERENCES " + table + "(id)" + ")";
            if (execute) {
                DatabaseManager.updateQuery((Context)this.internalContext, (String)create, (Object[])new Object[0]);
            }
            String string = create + ";";
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public MappingResults updateDistinctMappings(String table, int itemID, Set<Integer> distinctIDs) throws BrowseException {
        BrowseMappingResults results = new BrowseMappingResults();
        try {
            this.checkContext();
            Set addDistinctIDs = null;
            TableRowIterator tri = DatabaseManager.queryTable((Context)this.internalContext, (String)table, (String)("SELECT * FROM " + table + " WHERE item_id=?"), (Object[])new Object[]{itemID});
            if (tri != null) {
                addDistinctIDs = (Set)((HashSet)distinctIDs).clone();
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean itemIsMapped = false;
                        int trDistinctID = tr.getIntColumn("distinct_id");
                        if (distinctIDs.contains(trDistinctID)) {
                            results.addRetainedDistinctId(trDistinctID);
                            itemIsMapped = true;
                            addDistinctIDs.remove(trDistinctID);
                        }
                        if (itemIsMapped) continue;
                        results.addRemovedDistinctId(trDistinctID);
                        DatabaseManager.delete((Context)this.internalContext, (TableRow)tr);
                    }
                }
                finally {
                    tri.close();
                }
            } else {
                addDistinctIDs = distinctIDs;
            }
            for (int distinctID : addDistinctIDs) {
                if (distinctID <= -1) continue;
                TableRow row = DatabaseManager.row((String)table);
                row.setColumn("item_id", itemID);
                row.setColumn("distinct_id", distinctID);
                DatabaseManager.insert((Context)this.internalContext, (TableRow)row);
                results.addAddedDistinctId(distinctID);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            String msg = "problem updating distinct mappings: table=" + table + ",item-id=" + itemID;
            throw new BrowseException(msg, (Throwable)e);
        }
        finally {
            this.cleanContext();
        }
        return results;
    }

    @Mock
    public String createDistinctTable(String table, boolean execute) throws BrowseException {
        try {
            String create = "CREATE TABLE " + table + " (" + "id INTEGER PRIMARY KEY, " + "authority VARCHAR2(100), " + "value " + this.getValueColumnDefinition() + ", " + "sort_value " + this.getSortColumnDefinition() + ")";
            if (execute) {
                this.checkContext();
                DatabaseManager.updateQuery((Context)this.internalContext, (String)create, (Object[])new Object[0]);
            }
            String string = create + ";";
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String createPrimaryTable(String table, List<Integer> sortCols, boolean execute) throws BrowseException {
        try {
            StringBuilder sb = new StringBuilder();
            for (Integer no : sortCols) {
                sb.append(", sort_");
                sb.append(no.toString());
                sb.append(this.getSortColumnDefinition());
            }
            String createTable = "CREATE TABLE " + table + " (" + "id INTEGER PRIMARY KEY," + "item_id INTEGER REFERENCES item(item_id)" + sb.toString() + ")";
            if (execute) {
                this.checkContext();
                DatabaseManager.updateQuery((Context)this.internalContext, (String)createTable, (Object[])new Object[0]);
            }
            String string = createTable;
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String createSequence(String sequence, boolean execute) throws BrowseException {
        try {
            String create = "CREATE SEQUENCE " + sequence;
            if (execute) {
                this.checkContext();
                DatabaseManager.updateQuery((Context)this.internalContext, (String)create, (Object[])new Object[0]);
            }
            String string = create + ";";
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public void deleteByItemID(String table, int itemID) throws BrowseException {
        try {
            this.checkContext();
            Object[] params = new Object[]{new Integer(itemID)};
            String dquery = "DELETE FROM " + table + " WHERE item_id=?";
            DatabaseManager.updateQuery((Context)this.internalContext, (String)dquery, (Object[])params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public void deleteCommunityMappings(int itemID) throws BrowseException {
        try {
            this.checkContext();
            Object[] params = new Object[]{new Integer(itemID)};
            String dquery = "DELETE FROM Communities2Item WHERE item_id = ?";
            DatabaseManager.updateQuery((Context)this.internalContext, (String)dquery, (Object[])params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String dropIndexAndRelated(String table, boolean execute) throws BrowseException {
        try {
            this.checkContext();
            String dropper = "DROP TABLE " + table + " CASCADE CONSTRAINTS";
            if (execute) {
                DatabaseManager.updateQuery((Context)this.internalContext, (String)dropper, (Object[])new Object[0]);
            }
            String string = dropper + ";";
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public String dropSequence(String sequence, boolean execute) throws BrowseException {
        try {
            this.checkContext();
            String dropSeq = "DROP SEQUENCE " + sequence;
            if (execute) {
                DatabaseManager.updateQuery((Context)this.internalContext, (String)dropSeq, (Object[])new Object[0]);
            }
            String string = dropSeq + ";";
            return string;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public String dropView(String view, boolean execute) throws BrowseException {
        if (view != null && !"".equals(view)) {
            try {
                this.checkContext();
                String dropView = "DROP VIEW " + view + " CASCADE CONSTRAINTS";
                if (execute) {
                    DatabaseManager.updateQuery((Context)this.internalContext, (String)dropView, (Object[])new Object[0]);
                }
                String string = dropView + ";";
                return string;
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
            }
            finally {
                this.cleanContext();
            }
        }
        return "";
    }

    @Mock
    public int getDistinctID(String table, String value, String authority, String sortValue) throws BrowseException {
        TableRowIterator tri = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDistinctID: table=" + table + ",value=" + value + ",authority=" + authority + ",sortValue=" + sortValue));
        }
        try {
            Object[] params;
            this.checkContext();
            String select = "SELECT id FROM " + table;
            select = ConfigurationManager.getBooleanProperty((String)"webui.browse.metadata.case-insensitive", (boolean)false) ? (this.isValueColumnClob() ? select + " WHERE TO_CHAR(value)=?" : select + " WHERE value=?") : (this.isValueColumnClob() ? select + " WHERE TO_CHAR(value)=?" : select + " WHERE value=?");
            if (authority != null) {
                select = select + " AND authority = ?";
                params = new Object[]{value, authority};
            } else {
                select = select + " AND authority IS NULL";
                params = new Object[]{value};
            }
            tri = DatabaseManager.query((Context)this.internalContext, (String)select, (Object[])params);
            int distinctID = -1;
            distinctID = !tri.hasNext() ? this.insertDistinctRecord(table, value, authority, sortValue) : tri.next().getIntColumn("id");
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDistinctID: return=" + distinctID));
            }
            int n = distinctID;
            return n;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
            this.cleanContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public void updateCommunityMappings(int itemID) throws BrowseException {
        try {
            int[] commID = this.getAllCommunityIDs(itemID);
            for (int i = 0; i < commID.length; ++i) {
                if (this.isFirstOccurrence(commID, i)) continue;
                commID[i] = -1;
            }
            this.checkContext();
            TableRowIterator tri = DatabaseManager.queryTable((Context)this.internalContext, (String)"Communities2Item", (String)"SELECT * FROM Communities2Item WHERE item_id=?", (Object[])new Object[]{itemID});
            if (tri != null) {
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean itemIsMapped = false;
                        int trCommID = tr.getIntColumn("community_id");
                        for (int i = 0; i < commID.length; ++i) {
                            if (commID[i] != trCommID) continue;
                            itemIsMapped = true;
                            commID[i] = -1;
                        }
                        if (itemIsMapped) continue;
                        DatabaseManager.delete((Context)this.internalContext, (TableRow)tr);
                    }
                }
                finally {
                    tri.close();
                }
            }
            for (int i = 0; i < commID.length; ++i) {
                if (commID[i] <= -1) continue;
                TableRow row = DatabaseManager.row((String)"Communities2Item");
                row.setColumn("item_id", itemID);
                row.setColumn("community_id", commID[i]);
                DatabaseManager.insert((Context)this.internalContext, (TableRow)row);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public int insertDistinctRecord(String table, String value, String authority, String sortValue) throws BrowseException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("insertDistinctRecord: table=" + table + ",value=" + value + ",sortValue=" + sortValue));
        }
        try {
            this.checkContext();
            TableRow dr = DatabaseManager.row((String)table);
            dr.setColumn("value", this.utils.truncateValue(value));
            dr.setColumn("sort_value", this.utils.truncateSortValue(sortValue));
            if (authority != null) {
                dr.setColumn("authority", this.utils.truncateValue(authority, 100));
            }
            DatabaseManager.insert((Context)this.internalContext, (TableRow)dr);
            int distinctID = dr.getIntColumn("id");
            if (log.isDebugEnabled()) {
                log.debug((Object)("insertDistinctRecord: return=" + distinctID));
            }
            int n = distinctID;
            return n;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public void insertIndex(String table, int itemID, Map sortCols) throws BrowseException {
        try {
            this.checkContext();
            TableRow row = DatabaseManager.row((String)table);
            row.setColumn("item_id", itemID);
            for (Integer key : sortCols.keySet()) {
                String nValue = (String)sortCols.get(key);
                row.setColumn("sort_" + key.toString(), this.utils.truncateSortValue(nValue));
            }
            DatabaseManager.insert((Context)this.internalContext, (TableRow)row);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    @Mock
    public boolean updateIndex(String table, int itemID, Map sortCols) throws BrowseException {
        try {
            this.checkContext();
            boolean rowUpdated = false;
            TableRow row = DatabaseManager.findByUnique((Context)this.internalContext, (String)table, (String)"item_id", (Object)itemID);
            if (row == null) {
                boolean bl = false;
                return bl;
            }
            for (Integer key : sortCols.keySet()) {
                String column = "sort_" + key.toString();
                String newValue = this.utils.truncateSortValue((String)sortCols.get(key));
                if (!row.hasColumn(column)) {
                    throw new BrowseException("Column '" + column + "' does not exist in table " + table);
                }
                String oldValue = row.getStringColumn(column);
                if (oldValue != null && !oldValue.equals(newValue)) {
                    row.setColumn(column, newValue);
                    rowUpdated = true;
                    continue;
                }
                if (newValue == null || newValue.equals(oldValue)) continue;
                row.setColumn(column, newValue);
                rowUpdated = true;
            }
            if (rowUpdated) {
                DatabaseManager.update((Context)this.internalContext, (TableRow)row);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public List<Integer> deleteMappingsByItemID(String mapTable, int itemID) throws BrowseException {
        System.out.println("Map: " + mapTable + ", item: " + itemID);
        ArrayList<Integer> distinctIds = new ArrayList<Integer>();
        TableRowIterator tri = null;
        try {
            this.checkContext();
            try {
                tri = DatabaseManager.queryTable((Context)this.internalContext, (String)mapTable, (String)("SELECT * FROM " + mapTable + " WHERE item_id=?"), (Object[])new Object[]{itemID});
                if (tri != null) {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        distinctIds.add(tr.getIntColumn("distinct_id"));
                        DatabaseManager.delete((Context)this.internalContext, (TableRow)tr);
                    }
                }
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new BrowseException((Throwable)e);
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
        }
        finally {
            this.cleanContext();
        }
        return distinctIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public void pruneDistinct(String table, String map, List<Integer> distinctIds) throws BrowseException {
        block11: {
            try {
                this.checkContext();
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM ").append(table).append(" WHERE NOT EXISTS (SELECT 1 FROM ");
                query.append(map).append(" WHERE ").append(map).append(".distinct_id = ").append(table).append(".id)");
                if (distinctIds != null && distinctIds.size() > 0) {
                    query.append(" AND ").append(table).append(".id=?");
                    Statement stmt = null;
                    try {
                        stmt = this.internalContext.getDBConnection().prepareStatement(query.toString());
                        for (Integer distinctId : distinctIds) {
                            stmt.setInt(1, distinctId);
                            stmt.execute();
                            stmt.clearParameters();
                        }
                        break block11;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                DatabaseManager.updateQuery((Context)this.internalContext, (String)query.toString(), (Object[])new Object[0]);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new BrowseException((Throwable)e);
            }
            finally {
                this.cleanContext();
            }
        }
    }

    @Mock
    public void pruneExcess(String table, boolean withdrawn) throws BrowseException {
        try {
            this.checkContext();
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(table).append(" WHERE NOT EXISTS (SELECT 1 FROM item WHERE item.item_id=");
            query.append(table).append(".item_id AND ");
            if (withdrawn) {
                query.append("item.withdrawn = 1");
            } else {
                query.append("item.in_archive = 1 AND item.withdrawn = 0");
            }
            query.append(")");
            DatabaseManager.updateQuery((Context)this.internalContext, (String)query.toString(), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException((Throwable)e);
        }
        finally {
            this.cleanContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public void pruneMapExcess(String map, boolean withdrawn, List<Integer> distinctIds) throws BrowseException {
        block13: {
            try {
                this.checkContext();
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM ").append(map).append(" WHERE NOT EXISTS (SELECT 1 FROM item WHERE item.item_id=");
                query.append(map).append(".item_id AND ");
                if (withdrawn) {
                    query.append("item.withdrawn = 1");
                } else {
                    query.append("item.in_archive = 1 AND item.withdrawn = 0");
                }
                query.append(")");
                if (distinctIds != null && distinctIds.size() > 0) {
                    query.append(" AND ").append(map).append(".distinct_id=?");
                    Statement stmt = null;
                    try {
                        stmt = this.internalContext.getDBConnection().prepareStatement(query.toString());
                        for (Integer distinctId : distinctIds) {
                            stmt.setInt(1, distinctId);
                            stmt.execute();
                            stmt.clearParameters();
                        }
                        break block13;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                DatabaseManager.updateQuery((Context)this.internalContext, (String)query.toString(), (Object[])new Object[0]);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new BrowseException((Throwable)e);
            }
            finally {
                this.cleanContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public boolean testTableExistence(String table) throws BrowseException {
        Context c = null;
        try {
            c = new Context();
            String testQuery = "SELECT * FROM " + table + " WHERE ROWNUM=1";
            DatabaseManager.query((Context)c, (String)testQuery, (Object[])new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null && c.isValid()) {
                c.abort();
            }
        }
    }

    @Mock
    private String getValueColumnDefinition() {
        if (this.getValueColumnMaxBytes() < 1 || this.getValueColumnMaxBytes() > 4000) {
            return " CLOB ";
        }
        return " VARCHAR2(" + this.getValueColumnMaxBytes() + ") ";
    }

    @Mock
    private String getSortColumnDefinition() {
        return " VARCHAR2(" + this.getSortColumnMaxBytes() + ") ";
    }

    @Mock
    private int getValueColumnMaxBytes() {
        this.checkContext();
        int chars = this.utils.getValueColumnMaxChars();
        if (chars > 2000 || chars < 1) {
            return 4000;
        }
        this.cleanContext();
        return chars * 2;
    }

    @Mock
    private int getSortColumnMaxBytes() {
        this.checkContext();
        int chars = this.utils.getSortColumnMaxChars();
        if (chars > 2000 || chars < 1) {
            return 4000;
        }
        this.cleanContext();
        return chars * 2;
    }

    @Mock
    private boolean isValueColumnClob() {
        return this.getValueColumnMaxBytes() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    private int[] getAllCommunityIDs(int itemId) throws SQLException {
        ArrayList<Integer> commIdList = new ArrayList<Integer>();
        TableRowIterator tri = null;
        try {
            this.checkContext();
            tri = DatabaseManager.queryTable((Context)this.internalContext, (String)"Community2Item", (String)"SELECT * FROM Community2Item WHERE item_id=?", (Object[])new Object[]{itemId});
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int commId = row.getIntColumn("community_id");
                commIdList.add(commId);
                Integer parentId = this.getParentCommunityID(commId);
                while (parentId != null) {
                    commIdList.add(parentId);
                    parentId = this.getParentCommunityID(parentId);
                }
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
            this.cleanContext();
        }
        int[] cIds = new int[commIdList.size()];
        for (int i = 0; i < commIdList.size(); ++i) {
            cIds[i] = (Integer)commIdList.get(i);
        }
        return cIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    private Integer getParentCommunityID(int commId) throws SQLException {
        TableRowIterator tri = null;
        try {
            this.checkContext();
            tri = DatabaseManager.queryTable((Context)this.internalContext, (String)"Community2Community", (String)"SELECT * FROM Community2Community WHERE child_comm_id=?", (Object[])new Object[]{commId});
            if (tri.hasNext()) {
                Integer n = tri.next().getIntColumn("parent_comm_id");
                return n;
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return null;
    }

    @Mock
    private boolean isFirstOccurrence(int[] ids, int pos) {
        if (pos < 0 || pos >= ids.length) {
            return false;
        }
        int id = ids[pos];
        for (int i = 0; i < pos; ++i) {
            if (id != ids[i]) continue;
            return false;
        }
        return true;
    }

    private static class BrowseMappingResults
    implements MappingResults {
        private List<Integer> addedDistinctIds = new ArrayList<Integer>();
        private List<Integer> retainedDistinctIds = new ArrayList<Integer>();
        private List<Integer> removedDistinctIds = new ArrayList<Integer>();

        private BrowseMappingResults() {
        }

        private void addAddedDistinctId(int id) {
            this.addedDistinctIds.add(id);
        }

        private void addRetainedDistinctId(int id) {
            this.retainedDistinctIds.add(id);
        }

        private void addRemovedDistinctId(int id) {
            this.removedDistinctIds.add(id);
        }

        public List<Integer> getAddedDistinctIds() {
            return this.addedDistinctIds;
        }

        public List<Integer> getRetainedDistinctIds() {
            return this.retainedDistinctIds;
        }

        public List<Integer> getRemovedDistinctIds() {
            return Collections.unmodifiableList(this.removedDistinctIds);
        }
    }
}

