/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDSpaceObjectTest
extends AbstractUnitTest {
    protected DSpaceObject dspaceObject;

    @Override
    @After
    public void destroy() {
        this.dspaceObject = null;
        super.destroy();
    }

    @Test
    public void testClearDetails() {
        String[] testData;
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        String details = this.dspaceObject.getDetails();
        this.dspaceObject.clearDetails();
        Assert.assertThat((String)"testClearDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testClearDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)details)));
    }

    @Test
    public void testAddDetails() {
        String[] testData;
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        Assert.assertThat((String)"testAddDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"details 1, details 2, details 3")));
        Assert.assertThat((String)"testAddDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
    }

    @Test
    public void testGetDetails() {
        String[] testData;
        Assert.assertThat((String)"testGetDetails 0", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.nullValue());
        for (String s : testData = new String[]{"details 1", "details 2", "details 3"}) {
            this.dspaceObject.addDetails(s);
        }
        Assert.assertThat((String)"testGetDetails 1", (Object)this.dspaceObject.getDetails(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"details 1, details 2, details 3")));
    }

    @Test
    public void testFind() throws SQLException {
        if (this.dspaceObject instanceof Bitstream) {
            Assert.assertThat((String)"BITSTREAM type", (Object)DSpaceObject.find((Context)this.context, (int)0, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Bundle) {
            Assert.assertThat((String)"BUNDLE type", (Object)DSpaceObject.find((Context)this.context, (int)1, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Item) {
            Assert.assertThat((String)"ITEM type", (Object)DSpaceObject.find((Context)this.context, (int)2, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Collection) {
            Assert.assertThat((String)"COLLECTION type", (Object)DSpaceObject.find((Context)this.context, (int)3, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Community) {
            Assert.assertThat((String)"COMMUNITY type", (Object)DSpaceObject.find((Context)this.context, (int)4, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Group) {
            Assert.assertThat((String)"GROUP type", (Object)DSpaceObject.find((Context)this.context, (int)6, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof EPerson) {
            Assert.assertThat((String)"EPERSON type", (Object)DSpaceObject.find((Context)this.context, (int)7, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else if (this.dspaceObject instanceof Site) {
            Assert.assertThat((String)"SITE type", (Object)DSpaceObject.find((Context)this.context, (int)5, (int)this.dspaceObject.getID()), (Matcher)CoreMatchers.notNullValue());
        } else {
            Assert.assertThat((String)"Unknown type", (Object)DSpaceObject.find((Context)this.context, (int)-99, (int)1), (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"READ action", (Object)this.dspaceObject.getAdminObject(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"WRITE action", (Object)this.dspaceObject.getAdminObject(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"DELETE action", (Object)this.dspaceObject.getAdminObject(2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"ADD action", (Object)this.dspaceObject.getAdminObject(3), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"REMOVE action", (Object)this.dspaceObject.getAdminObject(4), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"WORKFLOW_STEP_1 action", (Object)this.dspaceObject.getAdminObject(5), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"WORKFLOW_STEP_2 action", (Object)this.dspaceObject.getAdminObject(6), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"WORKFLOW_STEP_3 action", (Object)this.dspaceObject.getAdminObject(7), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"WORKFLOW_ABORT action", (Object)this.dspaceObject.getAdminObject(8), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"DEFAULT_BITSTREAM_READ action", (Object)this.dspaceObject.getAdminObject(9), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
        Assert.assertThat((String)"DEFAULT_ITEM_READ action", (Object)this.dspaceObject.getAdminObject(10), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.dspaceObject)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetAdminObjectwithException() throws SQLException {
        if (this.dspaceObject instanceof Bundle || this.dspaceObject instanceof Community || this.dspaceObject instanceof Collection || this.dspaceObject instanceof Item) {
            throw new IllegalArgumentException();
        }
        this.dspaceObject.getAdminObject(11);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testGetParentObject() throws SQLException {
        Assert.assertThat((String)"testGetParentObject 0", (Object)this.dspaceObject.getParentObject(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public abstract void testGetType();

    @Test
    public abstract void testGetID();

    @Test
    public abstract void testGetHandle();

    @Test
    public abstract void testGetName();
}

