/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InstallItemTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(InstallItemTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testInstallItem_Context_InProgressSubmission() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        Item result = InstallItem.installItem((Context)this.context, (InProgressSubmission)is);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testInstallItem_Context_InProgressSubmission 0", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
    }

    @Test
    public void testInstallItem_validHandle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        Item result = InstallItem.installItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testInstallItem_validHandle", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
        Assert.assertThat((String)"testInstallItem_validHandle", (Object)result.getHandle(), (Matcher)CoreMatchers.equalTo((Object)handle));
    }

    @Test(expected=SQLException.class)
    public void testInstallItem_invalidHandle() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        WorkspaceItem is2 = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        Item result1 = InstallItem.installItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        Item result2 = InstallItem.installItem((Context)this.context, (InProgressSubmission)is2, (String)handle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRestoreItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        DCDate now = DCDate.getCurrent();
        String dayAndTime = now.toString();
        String date = dayAndTime.substring(0, dayAndTime.indexOf("T"));
        String provDescriptionBegins = "Made available in DSpace on " + date;
        Item result = InstallItem.restoreItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testRestoreItem 0", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
        DCValue[] provMsgValues = result.getMetadata("dc", "description", "provenance", "*");
        int i = 1;
        for (DCValue val : provMsgValues) {
            Assert.assertFalse((String)("testRestoreItem " + i), (boolean)val.value.startsWith(provDescriptionBegins));
            ++i;
        }
    }

    @Test
    public void testGetBitstreamProvenanceMessage() throws Exception {
        File f = new File(testProps.get("test.bitstream").toString());
        this.context.turnOffAuthorisationSystem();
        Item item = Item.create((Context)this.context);
        this.context.commit();
        Bitstream one = item.createSingleBitstream((InputStream)new FileInputStream(f));
        one.setName("one");
        this.context.commit();
        Bitstream two = item.createSingleBitstream((InputStream)new FileInputStream(f));
        two.setName("two");
        this.context.commit();
        this.context.restoreAuthSystemState();
        String testMessage = "No. of bitstreams: 2\n";
        testMessage = testMessage + "one: " + one.getSize() + " bytes, checksum: " + one.getChecksum() + " (" + one.getChecksumAlgorithm() + ")\n";
        testMessage = testMessage + "two: " + two.getSize() + " bytes, checksum: " + two.getChecksum() + " (" + two.getChecksumAlgorithm() + ")\n";
        Assert.assertThat((String)"testGetBitstreamProvenanceMessage 0", (Object)InstallItem.getBitstreamProvenanceMessage((Item)item), (Matcher)CoreMatchers.equalTo((Object)testMessage));
    }

    @Test
    public void testInstallItem_todayAsIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        is.getItem().addMetadata("dc", "date", "issued", "*", "today");
        is.getItem().addMetadata("dc", "date", "issued", "*", "2011-01-01");
        DCDate now = DCDate.getCurrent();
        String dayAndTime = now.toString();
        String date = dayAndTime.substring(0, dayAndTime.indexOf("T"));
        Item result = InstallItem.installItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        this.context.restoreAuthSystemState();
        DCValue[] issuedDates = result.getMetadata("dc", "date", "issued", "*");
        Assert.assertThat((String)"testInstallItem_todayAsIssuedDate 0", (Object)issuedDates[0].value, (Matcher)CoreMatchers.equalTo((Object)date));
        Assert.assertThat((String)"testInstallItem_todayAsIssuedDate 1", (Object)issuedDates[1].value, (Matcher)CoreMatchers.equalTo((Object)"2011-01-01"));
    }

    @Test
    public void testInstallItem_nullIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        Item result = InstallItem.installItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        this.context.restoreAuthSystemState();
        DCValue[] issuedDates = result.getMetadata("dc", "date", "issued", "*");
        Assert.assertThat((String)"testInstallItem_nullIssuedDate 0", (Object)issuedDates.length, (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testRestoreItem_todayAsIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "1345/567";
        Collection col = Collection.create((Context)this.context);
        WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
        is.getItem().addMetadata("dc", "date", "issued", "*", "today");
        is.getItem().addMetadata("dc", "date", "issued", "*", "2011-01-01");
        DCDate now = DCDate.getCurrent();
        String dayAndTime = now.toString();
        String date = dayAndTime.substring(0, dayAndTime.indexOf("T"));
        Item result = InstallItem.restoreItem((Context)this.context, (InProgressSubmission)is, (String)handle);
        this.context.restoreAuthSystemState();
        DCValue[] issuedDates = result.getMetadata("dc", "date", "issued", "*");
        Assert.assertThat((String)"testRestoreItem_todayAsIssuedDate 0", (Object)issuedDates[0].value, (Matcher)CoreMatchers.equalTo((Object)date));
        Assert.assertThat((String)"testRestoreItem_todayAsIssuedDate 1", (Object)issuedDates[1].value, (Matcher)CoreMatchers.equalTo((Object)"2011-01-01"));
    }
}

