/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mockit.NonStrictExpectations;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(ItemTest.class);
    private Item it;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.it = Item.create((Context)this.context);
            this.it.setArchived(true);
            this.it.setSubmitter(this.context.getCurrentUser());
            this.it.update();
            this.dspaceObject = this.it;
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        this.it = null;
        super.destroy();
    }

    @Test
    public void testItemFind() throws Exception {
        int id = this.it.getID();
        Item found = Item.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testItemFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testItemFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testItemFind 2", (Object)found.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreate() throws Exception {
        Item created = Item.create((Context)this.context);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindAll() throws Exception {
        ItemIterator all = Item.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 1", (boolean)added);
    }

    @Test
    public void testFindBySubmitter() throws Exception {
        ItemIterator all = Item.findBySubmitter((Context)this.context, (EPerson)this.context.getCurrentUser());
        Assert.assertThat((String)"testFindBySubmitter 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindBySubmitter 1", (boolean)added);
        this.context.turnOffAuthorisationSystem();
        all = Item.findBySubmitter((Context)this.context, (EPerson)EPerson.create((Context)this.context));
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testFindBySubmitter 2", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindBySubmitter 3", (boolean)all.hasNext());
        Assert.assertThat((String)"testFindBySubmitter 4", (Object)all.next(), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.it.getID() >= 1 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.it.getHandle(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testIsArchived() throws SQLException, AuthorizeException {
        Assert.assertTrue((String)"testIsArchived 0", (boolean)this.it.isArchived());
        this.context.turnOffAuthorisationSystem();
        Item tmp = Item.create((Context)this.context);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsArchived 1", (boolean)tmp.isArchived());
    }

    @Test
    public void testIsWithdrawn() {
        Assert.assertFalse((String)"testIsWithdrawn 0", (boolean)this.it.isWithdrawn());
    }

    @Test
    public void testGetLastModified() {
        Assert.assertThat((String)"testGetLastModified 0", (Object)this.it.getLastModified(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetLastModified 1", (boolean)DateUtils.isSameDay((Date)this.it.getLastModified(), (Date)new Date()));
    }

    @Test
    public void testSetArchived() {
        this.it.setArchived(true);
        Assert.assertTrue((String)"testSetArchived 0", (boolean)this.it.isArchived());
    }

    @Test
    public void testSetOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.context.restoreAuthSystemState();
        this.it.setOwningCollection(c);
        Assert.assertThat((String)"testSetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetOwningCollection 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)c));
    }

    @Test
    public void testGetOwningCollection() throws Exception {
        Assert.assertThat((String)"testGetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetDC() {
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        DCValue[] dc = this.it.getDC(element, qualifier, lang);
        Assert.assertThat((String)"testGetDC 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetDC 1", (dc.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMetadata_4args() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testGetMetadata_4args 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_4args 1", (dc.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMetadata_String() {
        String mdString = "dc.contributor.author";
        DCValue[] dc = this.it.getMetadata(mdString);
        Assert.assertThat((String)"testGetMetadata_String 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 1", (dc.length == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor.*";
        dc = this.it.getMetadata(mdString);
        Assert.assertThat((String)"testGetMetadata_String 2", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 3", (dc.length == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor";
        dc = this.it.getMetadata(mdString);
        Assert.assertThat((String)"testGetMetadata_String 4", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 5", (dc.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDS806() {
        String dcType = "DC-TYPE";
        String testType = "TEST-TYPE";
        this.it.addMetadata("dc", "type", null, null, dcType);
        this.it.addMetadata("test", "type", null, null, testType);
        DCValue[] values = this.it.getMetadata("dc", "type", null, null);
        Assert.assertTrue((String)"Return results", (values.length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddDC_4args_1() {
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String[] values = new String[]{"value0", "value1"};
        this.it.addDC(element, qualifier, lang, values);
        DCValue[] dc = this.it.getDC(element, qualifier, lang);
        Assert.assertThat((String)"testAddDC_4args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddDC_4args_1 1", (dc.length == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddDC_4args_1 2", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddDC_4args_1 3", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddDC_4args_1 4", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddDC_4args_1 5", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddDC_4args_1 6", (Object)dc[1].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddDC_4args_1 7", (Object)dc[1].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddDC_4args_1 8", (Object)dc[1].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddDC_4args_1 9", (Object)dc[1].value, (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void testAddDC_4args_2() {
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String value = "value";
        this.it.addDC(element, qualifier, lang, value);
        DCValue[] dc = this.it.getDC(element, qualifier, lang);
        Assert.assertThat((String)"testAddDC_4args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddDC_4args_2 1", (dc.length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddDC_4args_2 2", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddDC_4args_2 3", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddDC_4args_2 4", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddDC_4args_2 5", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testAddMetadata_5args_1() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String[] values = new String[]{"value0", "value1"};
        this.it.addMetadata(schema, element, qualifier, lang, values);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_5args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_1 1", (dc.length == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_5args_1 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_1 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_1 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_1 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_1 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddMetadata_5args_1 7", (Object)dc[1].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_1 8", (Object)dc[1].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_1 9", (Object)dc[1].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_1 10", (Object)dc[1].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_1 11", (Object)dc[1].value, (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void testAddMetadata_7args_1_authority() throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = "*";
        String[] values = new String[]{"en_US", "en"};
        String[] authorities = new String[]{"accepted", "uncertain"};
        int[] confidences = new int[]{0, 0};
        this.it.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.length == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_1 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddMetadata_7args_1 7", (Object)dc[0].authority, (Matcher)CoreMatchers.equalTo((Object)authorities[0]));
        Assert.assertThat((String)"testAddMetadata_7args_1 8", (Object)dc[0].confidence, (Matcher)CoreMatchers.equalTo((Object)confidences[0]));
        Assert.assertThat((String)"testAddMetadata_7args_1 9", (Object)dc[1].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 10", (Object)dc[1].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 11", (Object)dc[1].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 12", (Object)dc[1].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 13", (Object)dc[1].value, (Matcher)CoreMatchers.equalTo((Object)values[1]));
        Assert.assertThat((String)"testAddMetadata_7args_1 14", (Object)dc[1].authority, (Matcher)CoreMatchers.equalTo((Object)authorities[1]));
        Assert.assertThat((String)"testAddMetadata_7args_1 15", (Object)dc[1].confidence, (Matcher)CoreMatchers.equalTo((Object)confidences[1]));
    }

    @Test
    public void testAddMetadata_7args_1_noauthority() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String[] values = new String[]{"value0", "value1"};
        String[] authorities = new String[]{"auth0", "auth2"};
        int[] confidences = new int[]{0, 0};
        this.it.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.length == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_1 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddMetadata_7args_1 7", (Object)dc[0].authority, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_1 8", (Object)dc[0].confidence, (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((String)"testAddMetadata_7args_1 9", (Object)dc[1].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_1 10", (Object)dc[1].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_1 11", (Object)dc[1].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_1 12", (Object)dc[1].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_1 13", (Object)dc[1].value, (Matcher)CoreMatchers.equalTo((Object)values[1]));
        Assert.assertThat((String)"testAddMetadata_7args_1 14", (Object)dc[1].authority, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_1 15", (Object)dc[1].confidence, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testAddMetadata_5args_2() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String[] values = new String[]{"value0", "value1"};
        this.it.addMetadata(schema, element, qualifier, lang, values);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_5args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_2 1", (dc.length == 2 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_5args_2 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_2 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_2 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_2 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_2 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((String)"testAddMetadata_5args_2 7", (Object)dc[1].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_5args_2 8", (Object)dc[1].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_5args_2 9", (Object)dc[1].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_5args_2 10", (Object)dc[1].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_5args_2 11", (Object)dc[1].value, (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void testAddMetadata_7args_2_authority() {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = "*";
        String values = "en";
        String authorities = "accepted";
        int confidences = 0;
        this.it.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_2 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_2 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_2 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_2 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_2 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values));
        Assert.assertThat((String)"testAddMetadata_7args_2 7", (Object)dc[0].authority, (Matcher)CoreMatchers.equalTo((Object)authorities));
        Assert.assertThat((String)"testAddMetadata_7args_2 8", (Object)dc[0].confidence, (Matcher)CoreMatchers.equalTo((Object)confidences));
    }

    @Test
    public void testAddMetadata_7args_2_noauthority() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String values = "value0";
        String authorities = "auth0";
        int confidences = 0;
        this.it.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddMetadata_7args_2 2", (Object)dc[0].schema, (Matcher)CoreMatchers.equalTo((Object)schema));
        Assert.assertThat((String)"testAddMetadata_7args_2 3", (Object)dc[0].element, (Matcher)CoreMatchers.equalTo((Object)element));
        Assert.assertThat((String)"testAddMetadata_7args_2 4", (Object)dc[0].qualifier, (Matcher)CoreMatchers.equalTo((Object)qualifier));
        Assert.assertThat((String)"testAddMetadata_7args_2 5", (Object)dc[0].language, (Matcher)CoreMatchers.equalTo((Object)lang));
        Assert.assertThat((String)"testAddMetadata_7args_2 6", (Object)dc[0].value, (Matcher)CoreMatchers.equalTo((Object)values));
        Assert.assertThat((String)"testAddMetadata_7args_2 7", (Object)dc[0].authority, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testAddMetadata_7args_2 8", (Object)dc[0].confidence, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testClearDC() {
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String value = "value";
        this.it.addDC(element, qualifier, lang, value);
        this.it.clearDC(element, qualifier, lang);
        DCValue[] dc = this.it.getDC(element, qualifier, lang);
        Assert.assertThat((String)"testClearDC 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testClearDC 1", (dc.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClearMetadata() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        String values = "value0";
        this.it.addMetadata(schema, element, qualifier, lang, values);
        this.it.clearMetadata(schema, element, qualifier, lang);
        DCValue[] dc = this.it.getMetadata(schema, element, qualifier, lang);
        Assert.assertThat((String)"testClearMetadata 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testClearMetadata 1", (dc.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSubmitter() throws Exception {
        Assert.assertThat((String)"testGetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        this.context.turnOffAuthorisationSystem();
        Item tmp = Item.create((Context)this.context);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testGetSubmitter 1", (Object)tmp.getSubmitter(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetSubmitter() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson sub = EPerson.create((Context)this.context);
        this.context.restoreAuthSystemState();
        this.it.setSubmitter(sub);
        Assert.assertThat((String)"testSetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetSubmitter 1", (Object)this.it.getSubmitter().getID(), (Matcher)CoreMatchers.equalTo((Object)sub.getID()));
    }

    @Test
    public void testGetCollections() throws Exception {
        Assert.assertThat((String)"testGetCollections 0", (Object)this.it.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.it.getCollections().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCommunities() throws Exception {
        Assert.assertThat((String)"testGetCommunities 0", (Object)this.it.getCommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCommunities 1", (this.it.getCommunities().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_0args() throws Exception {
        Assert.assertThat((String)"testGetBundles_0args 0", (Object)this.it.getBundles(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_0args 1", (this.it.getBundles().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_String() throws Exception {
        String name = "name";
        Assert.assertThat((String)"testGetBundles_String 0", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_String 1", (this.it.getBundles(name).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBundleAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        String name = "bundle";
        Bundle created = this.it.createBundle(name);
        Assert.assertThat((String)"testCreateBundleAuth 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateBundleAuth 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testCreateBundleAuth 2", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateBundleAuth 3", (this.it.getBundles(name).length == 1 ? 1 : 0) != 0);
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNoName() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        String name = "";
        Bundle created = this.it.createBundle(name);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNoName2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        String name = null;
        Bundle created = this.it.createBundle(name);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateBundleNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = this.it.createBundle(name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddBundleAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        String name = "bundle";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        Assert.assertThat((String)"testAddBundleAuth 0", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddBundleAuth 1", (this.it.getBundles(name).length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddBundleAuth 2", (Object)this.it.getBundles(name)[0], (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddBundleNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveBundleAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4, (boolean)true);
                result = null;
            }
        };
        String name = "bundle";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        this.it.removeBundle(created);
        Assert.assertThat((String)"testRemoveBundleAuth 0", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveBundleAuth 1", (this.it.getBundles(name).length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveBundleNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4);
                result = new AuthorizeException();
            }
        };
        String name = "bundle";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        this.it.removeBundle(created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStream_StringAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), name);
        Assert.assertThat((String)"testCreateSingleBitstream_InputStream_StringAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStream_StringNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = new AuthorizeException();
            }
        };
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStreamAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testCreateSingleBitstream_InputStreamAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStreamNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f));
        Assert.fail((String)"Expected exception");
    }

    @Test
    public void testGetNonInternalBitstreams() throws Exception {
        Assert.assertThat((String)"testGetNonInternalBitstreams 0", (Object)this.it.getNonInternalBitstreams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetNonInternalBitstreams 1", (this.it.getNonInternalBitstreams().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveDSpaceLicenseAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3, (boolean)true);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4, (boolean)true);
                result = null;
            }
        };
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        this.it.removeDSpaceLicense();
        Assert.assertThat((String)"testRemoveDSpaceLicenseAuth 0", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveDSpaceLicenseAuth 1", (this.it.getBundles(name).length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveDSpaceLicenseNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4);
                result = new AuthorizeException();
            }
        };
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        this.it.addBundle(created);
        this.it.removeDSpaceLicense();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveLicensesAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4);
                result = null;
            }
        };
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), bsname);
        result.setFormat(BitstreamFormat.findByShortDescription((Context)this.context, (String)bsname));
        created.addBitstream(result);
        this.it.addBundle(created);
        this.it.removeLicenses();
        Assert.assertThat((String)"testRemoveLicensesAuth 0", (Object)this.it.getBundles(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveLicensesAuth 1", (this.it.getBundles(name).length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveLicensesNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4);
                result = new AuthorizeException();
            }
        };
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), bsname);
        result.setFormat(BitstreamFormat.findByShortDescription((Context)this.context, (String)bsname));
        created.addBitstream(result);
        this.it.addBundle(created);
        this.it.removeLicenses();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = null;
            }
        };
        this.it.update();
    }

    @Test
    public void testUpdateAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        this.it.update();
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = new AuthorizeException();
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)anyBoolean);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)anyBoolean);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        this.it.update();
    }

    @Test
    public void testWithdrawAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)any), (Item)((Item)any));
                result = null;
            }
        };
        this.it.withdraw();
        Assert.assertTrue((String)"testWithdrawAuth 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testWithdrawNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)any), (Item)((Item)any));
                result = new AuthorizeException();
            }
        };
        this.it.withdraw();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testReinstateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)any), (Item)((Item)any));
                result = null;
                AuthorizeUtil.authorizeReinstateItem((Context)((Context)any), (Item)((Item)any));
                result = null;
            }
        };
        this.it.withdraw();
        this.it.reinstate();
        Assert.assertFalse((String)"testReinstate 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testReinstateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeWithdrawItem((Context)((Context)any), (Item)((Item)any));
                result = null;
                AuthorizeUtil.authorizeReinstateItem((Context)((Context)any), (Item)((Item)any));
                result = new AuthorizeException();
            }
        };
        this.it.withdraw();
        this.it.reinstate();
        Assert.fail((String)"Exceotion expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4, (boolean)true);
                result = null;
            }
        };
        int id = this.it.getID();
        this.it.delete();
        Item found = Item.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)4);
                result = new AuthorizeException();
            }
        };
        this.it.delete();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDecache() throws Exception {
        int id = this.it.getID();
        this.it.decache();
        Item found = (Item)this.context.fromCache(Item.class, id);
        Assert.assertThat((String)"testDecache 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)3);
                result = true;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.it.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.it.equals((Object)Item.create((Context)this.context)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.it.equals((Object)this.it));
    }

    @Test
    public void testIsOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.context.restoreAuthSystemState();
        boolean result = this.it.isOwningCollection(c);
        Assert.assertFalse((String)"testIsOwningCollection 0", (boolean)result);
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.it.getType(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testReplaceAllItemPolicies() throws Exception {
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        ResourcePolicy pol1 = ResourcePolicy.create((Context)this.context);
        newpolicies.add(pol1);
        this.it.replaceAllItemPolicies(newpolicies);
        List retrieved = AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)this.it);
        Assert.assertThat((String)"testReplaceAllItemPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testReplaceAllItemPolicies 1", (Object)retrieved.size(), (Matcher)CoreMatchers.equalTo((Object)newpolicies.size()));
    }

    @Test
    public void testReplaceAllBitstreamPolicies() throws Exception {
        Bundle[] bundles;
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), bsname);
        result.setFormat(BitstreamFormat.findByShortDescription((Context)this.context, (String)bsname));
        created.addBitstream(result);
        this.it.addBundle(created);
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        this.context.restoreAuthSystemState();
        this.it.replaceAllBitstreamPolicies(newpolicies);
        ArrayList retrieved = new ArrayList();
        for (Bundle b : bundles = this.it.getBundles()) {
            retrieved.addAll(b.getBundlePolicies());
            retrieved.addAll(b.getBitstreamPolicies());
        }
        Assert.assertFalse((String)"testReplaceAllBitstreamPolicies 0", (boolean)retrieved.isEmpty());
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 1", (boolean)equals);
    }

    @Test
    public void testRemoveGroupPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        Group g = Group.create((Context)this.context);
        ResourcePolicy pol1 = ResourcePolicy.create((Context)this.context);
        newpolicies.add(pol1);
        pol1.setGroup(g);
        this.it.replaceAllBitstreamPolicies(newpolicies);
        this.context.restoreAuthSystemState();
        this.it.removeGroupPolicies(g);
        List retrieved = AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)this.it);
        Assert.assertThat((String)"testRemoveGroupPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveGroupPolicies 1", (boolean)retrieved.isEmpty());
    }

    @Test
    public void testInheritCollectionDefaultPolicies() throws Exception {
        Bundle[] bundles;
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        List newpolicies = AuthorizeManager.getPoliciesActionFilter((Context)this.context, (DSpaceObject)c, (int)9);
        for (ResourcePolicy rp : newpolicies) {
            rp.setAction(0);
        }
        String name = "LICENSE";
        Bundle created = Bundle.create((Context)this.context);
        created.setName(name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.it.createSingleBitstream((InputStream)new FileInputStream(f), bsname);
        result.setFormat(BitstreamFormat.findByShortDescription((Context)this.context, (String)bsname));
        created.addBitstream(result);
        this.it.addBundle(created);
        this.context.restoreAuthSystemState();
        this.it.inheritCollectionDefaultPolicies(c);
        ArrayList retrieved = AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)this.it);
        boolean equals = true;
        for (int i = 0; i < retrieved.size() && equals; ++i) {
            if (newpolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 0", (boolean)equals);
        retrieved = new ArrayList();
        for (Bundle b : bundles = this.it.getBundles()) {
            retrieved.addAll(b.getBundlePolicies());
            retrieved.addAll(b.getBitstreamPolicies());
        }
        Assert.assertFalse((String)"testInheritCollectionDefaultPolicies 1", (boolean)retrieved.isEmpty());
        equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 2", (boolean)equals);
    }

    @Test
    public void testMove() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection from = Collection.create((Context)this.context);
        Collection to = Collection.create((Context)this.context);
        this.it.setOwningCollection(from);
        this.it.move(from, to);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testMove 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testMove 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)to));
    }

    @Test
    public void testHasUploadedFiles() throws Exception {
        Assert.assertFalse((String)"testHasUploadedFiles 0", (boolean)this.it.hasUploadedFiles());
    }

    @Test
    public void testGetCollectionsNotLinked() throws Exception {
        Collection[] result = this.it.getCollectionsNotLinked();
        boolean isin = false;
        for (Collection c : result) {
            ItemIterator iit = c.getAllItems();
            while (iit.hasNext()) {
                if (iit.next().getID() != this.it.getID()) continue;
                isin = true;
            }
        }
        Assert.assertFalse((String)"testGetCollectionsNotLinked 0", (boolean)isin);
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.it.canEdit());
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.it.canEdit());
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.it.canEdit());
    }

    @Test
    public void testCanEditBooleanAuth5() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = new AuthorizeException();
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = null;
            }
        };
        Collection c = Collection.create((Context)this.context);
        c.createTemplateItem();
        c.update();
        Assert.assertTrue((String)"testCanEditBooleanNoAuth5 0", (boolean)c.getTemplateItem().canEdit());
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)anyBoolean);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)anyBoolean);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = new AuthorizeException();
            }
        };
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.it.canEdit());
    }

    @Test
    public void testCanEditBooleanNoAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeManager.class}){
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)anyBoolean);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = true;
            }
        };
        Collection c = Collection.create((Context)this.context);
        WorkspaceItem wi = WorkspaceItem.create((Context)this.context, (Collection)c, (boolean)true);
        Assert.assertFalse((String)"testCanEditBooleanNoAuth2 0", (boolean)wi.getItem().canEdit());
    }

    @Test
    public void testIsInProgressSubmission() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        WorkspaceItem wi = WorkspaceItem.create((Context)this.context, (Collection)c, (boolean)true);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testIsInProgressSubmission 0", (boolean)wi.getItem().isInProgressSubmission());
    }

    @Test
    public void testIsInProgressSubmissionFalse() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        WorkspaceItem wi = WorkspaceItem.create((Context)this.context, (Collection)c, (boolean)true);
        Item item = InstallItem.installItem((Context)this.context, (InProgressSubmission)wi);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse 0", (boolean)item.isInProgressSubmission());
    }

    @Test
    public void testIsInProgressSubmissionFalse2() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = Collection.create((Context)this.context);
        c.createTemplateItem();
        c.update();
        Item item = c.getTemplateItem();
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse2 0", (boolean)item.isInProgressSubmission());
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.it.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindByMetadataField() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String value = "value";
        ItemIterator result = Item.findByMetadataField((Context)this.context, (String)schema, (String)element, (String)qualifier, (String)value);
        Assert.assertThat((String)"testFindByMetadataField 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByMetadataField 1", (boolean)result.hasNext());
        Assert.assertThat((String)"testFindByMetadataField 2", (Object)result.next(), (Matcher)CoreMatchers.nullValue());
        this.it.addMetadata(schema, element, qualifier, "*", value);
        this.it.update();
        result = Item.findByMetadataField((Context)this.context, (String)schema, (String)element, (String)qualifier, (String)value);
        Assert.assertThat((String)"testFindByMetadataField 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByMetadataField 4", (boolean)result.hasNext());
        Assert.assertTrue((String)"testFindByMetadataField 5", (boolean)result.next().equals((Object)this.it));
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Item)this.it.getAdminObject(4)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Item)this.it.getAdminObject(3)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)this.it.getAdminObject(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAdminObject 3", (Object)((Item)this.it.getAdminObject(11)), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            Assert.assertThat((String)"testGetParentObject 0", (Object)this.it.getParentObject(), (Matcher)CoreMatchers.nullValue());
            this.context.turnOffAuthorisationSystem();
            Collection parent = Collection.create((Context)this.context);
            this.it.setOwningCollection(parent);
            this.context.restoreAuthSystemState();
            Assert.assertThat((String)"testGetParentObject 1", (Object)this.it.getParentObject(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testGetParentObject 2", (Object)((Collection)this.it.getParentObject()), (Matcher)CoreMatchers.equalTo((Object)parent));
        }
        catch (AuthorizeException ex) {
            Assert.fail((String)"Authorize exception catched");
        }
    }

    @Test
    public void testFindByAuthorityValue() throws Exception {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String value = "en";
        String authority = "accepted";
        int confidence = 0;
        ItemIterator result = Item.findByAuthorityValue((Context)this.context, (String)schema, (String)element, (String)qualifier, (String)value);
        Assert.assertThat((String)"testFindByAuthorityValue 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByAuthorityValue 1", (boolean)result.hasNext());
        Assert.assertThat((String)"testFindByAuthorityValue 2", (Object)result.next(), (Matcher)CoreMatchers.nullValue());
        this.it.addMetadata(schema, element, qualifier, "*", value, authority, confidence);
        this.it.update();
        result = Item.findByAuthorityValue((Context)this.context, (String)schema, (String)element, (String)qualifier, (String)authority);
        Assert.assertThat((String)"testFindByAuthorityValue 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByAuthorityValue 4", (boolean)result.hasNext());
        Assert.assertThat((String)"testFindByAuthorityValue 5", (Object)result.next(), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }
}

