/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.core.Context;
import org.dspace.core.LicenseManager;
import org.dspace.eperson.EPerson;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LicenseUtilsTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(LicenseUtilsTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testGetLicenseText_5args() throws SQLException, AuthorizeException {
        Locale locale = null;
        Collection collection = null;
        Item item = null;
        EPerson person = null;
        HashMap<String, String> additionalInfo = null;
        String template = "Template license: %1$s %2$s %3$s %5$s %6$s";
        String templateLong = "Template license: %1$s %2$s %3$s %5$s %6$s %8$s %9$s %10$s %11$s";
        String templateResult = "Template license: first name last name test@email.com  ";
        String templateLongResult = "Template license: first name last name test@email.com   arg1 arg2 arg3 arg4";
        String defaultLicense = LicenseManager.getDefaultSubmissionLicense();
        this.context.turnOffAuthorisationSystem();
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 0", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.GERMAN;
        collection = Collection.create((Context)this.context);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 1", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = new HashMap<String, String>();
        additionalInfo.put("arg1", "arg1");
        additionalInfo.put("arg2", "arg2");
        additionalInfo.put("arg3", "arg3");
        Assert.assertThat((String)"testGetLicenseText_5args 2", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        collection.setLicense(template);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 3", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.GERMAN;
        collection = Collection.create((Context)this.context);
        collection.setLicense(template);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 4", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        collection.setLicense(templateLong);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        additionalInfo = new LinkedHashMap();
        additionalInfo.put("arg1", "arg1");
        additionalInfo.put("arg2", "arg2");
        additionalInfo.put("arg3", "arg3");
        additionalInfo.put("arg4", "arg4");
        Assert.assertThat((String)"testGetLicenseText_5args 5", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateLongResult));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetLicenseText_4args() throws SQLException, AuthorizeException {
        Locale locale = null;
        Collection collection = null;
        Item item = null;
        EPerson person = null;
        String template = "Template license: %1$s %2$s %3$s %5$s %6$s";
        String templateResult = "Template license: first name last name test@email.com  ";
        String defaultLicense = LicenseManager.getDefaultSubmissionLicense();
        this.context.turnOffAuthorisationSystem();
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        Assert.assertThat((String)"testGetLicenseText_5args 0", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.GERMAN;
        collection = Collection.create((Context)this.context);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        Assert.assertThat((String)"testGetLicenseText_5args 1", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = Collection.create((Context)this.context);
        collection.setLicense(template);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        Assert.assertThat((String)"testGetLicenseText_5args 3", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.GERMAN;
        collection = Collection.create((Context)this.context);
        collection.setLicense(template);
        item = Item.create((Context)this.context);
        person = EPerson.create((Context)this.context);
        person.setFirstName("first name");
        person.setLastName("last name");
        person.setEmail("test@email.com");
        Assert.assertThat((String)"testGetLicenseText_5args 4", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGrantLicense() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = Item.create((Context)this.context);
        String defaultLicense = LicenseManager.getDefaultSubmissionLicense();
        LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)defaultLicense);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)item.getBundles("LICENSE")[0].getBitstreams()[0].retrieve(), (Writer)writer);
        String license = writer.toString();
        Assert.assertThat((String)"testGrantLicense 0", (Object)license, (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        this.context.restoreAuthSystemState();
    }
}

