/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.MetadataField;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataFieldTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(MetadataFieldTest.class);
    private MetadataField mf;
    private String element = "contributor";
    private String qualifier = "author";
    private String scopeNote = "scope note";

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.mf = MetadataField.findByElement((Context)this.context, (int)1, (String)this.element, (String)this.qualifier);
            this.mf.setScopeNote(this.scopeNote);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorize Error in init", (Throwable)ex);
            Assert.fail((String)("Authorize Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.mf = null;
        super.destroy();
    }

    @Test
    public void testGetElement() {
        Assert.assertThat((String)"testGetElement 0", (Object)this.mf.getElement(), (Matcher)CoreMatchers.equalTo((Object)this.element));
    }

    @Test
    public void testSetElement() {
        String elem = "newelem";
        this.mf.setElement(elem);
        Assert.assertThat((String)"testSetElement 0", (Object)this.mf.getElement(), (Matcher)CoreMatchers.equalTo((Object)elem));
    }

    @Test
    public void testGetFieldID() {
        Assert.assertTrue((String)"testGetFieldID 0", (this.mf.getFieldID() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetQualifier() {
        Assert.assertThat((String)"testGetQualifier 0", (Object)this.mf.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)this.qualifier));
    }

    @Test
    public void testSetQualifier() {
        String qual = "qualif";
        this.mf.setQualifier(qual);
        Assert.assertThat((String)"testSetQualifier 0", (Object)this.mf.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qual));
    }

    @Test
    public void testGetSchemaID() {
        Assert.assertThat((String)"testGetSchemaID 0", (Object)this.mf.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testSetSchemaID() {
        int schemaID = 3;
        this.mf.setSchemaID(schemaID);
        Assert.assertThat((String)"testSetSchemaID 0", (Object)this.mf.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)schemaID));
    }

    @Test
    public void testGetScopeNote() {
        Assert.assertThat((String)"testGetScopeNote 0", (Object)this.mf.getScopeNote(), (Matcher)CoreMatchers.equalTo((Object)this.scopeNote));
    }

    @Test
    public void testSetScopeNote() {
        String scn = "new scope note";
        this.mf.setScopeNote(scn);
        Assert.assertThat((String)"testSetScopeNote 0", (Object)this.mf.getScopeNote(), (Matcher)CoreMatchers.equalTo((Object)scn));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = true;
            }
        };
        String elem = "elem1";
        String qual = "qual1";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        MetadataField found = MetadataField.findByElement((Context)this.context, (int)1, (String)elem, (String)qual);
        Assert.assertThat((String)"testCreateAuth 0", (Object)found.getFieldID(), (Matcher)CoreMatchers.equalTo((Object)m.getFieldID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = false;
            }
        };
        String elem = "elem1";
        String qual = "qual1";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testCreateRepeated() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = true;
            }
        };
        String elem = this.element;
        String qual = this.qualifier;
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByElement() throws Exception {
        MetadataField found = MetadataField.findByElement((Context)this.context, (int)1, (String)this.element, (String)this.qualifier);
        Assert.assertThat((String)"testFindByElement 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByElement 1", (Object)found.getFieldID(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getFieldID()));
        Assert.assertThat((String)"testFindByElement 2", (Object)found.getElement(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getElement()));
        Assert.assertThat((String)"testFindByElement 3", (Object)found.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getQualifier()));
    }

    @Test
    public void testFindAll() throws Exception {
        MetadataField[] found = MetadataField.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataField mdf : found) {
            if (!mdf.equals((Object)this.mf)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFindAllInSchema() throws Exception {
        MetadataField[] found = MetadataField.findAllInSchema((Context)this.context, (int)1);
        Assert.assertThat((String)"testFindAllInSchema 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAllInSchema 1", (found.length >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testFindAllInSchema 2", (found.length <= MetadataField.findAll((Context)this.context).length ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataField mdf : found) {
            if (!mdf.equals((Object)this.mf)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAllInSchema 3", (boolean)added);
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = true;
            }
        };
        String elem = "elem2";
        String qual = "qual2";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        m.update(this.context);
        MetadataField found = MetadataField.findByElement((Context)this.context, (int)1, (String)elem, (String)qual);
        Assert.assertThat((String)"testUpdateAuth 0", (Object)found.getFieldID(), (Matcher)CoreMatchers.equalTo((Object)m.getFieldID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = false;
            }
        };
        String elem = "elem2";
        String qual = "qual2";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.update(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testUpdateRepeated() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = true;
            }
        };
        String elem = this.element;
        String qual = this.qualifier;
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.create(this.context);
        m.setElement(elem);
        m.setQualifier(qual);
        m.update(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = true;
            }
        };
        String elem = "elem3";
        String qual = "qual3";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        this.context.commit();
        m.delete(this.context);
        MetadataField found = MetadataField.findByElement((Context)this.context, (int)1, (String)elem, (String)qual);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataFieldTest.this.context);
                result = false;
            }
        };
        String elem = "elem3";
        String qual = "qual3";
        MetadataField m = new MetadataField();
        m.setSchemaID(1);
        m.setElement(elem);
        m.setQualifier(qual);
        m.create(this.context);
        this.context.commit();
        m.delete(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFormKey() {
        Assert.assertThat((String)"testFormKey 0", (Object)MetadataField.formKey((String)"dc", (String)"elem", null), (Matcher)CoreMatchers.equalTo((Object)"dc_elem"));
        Assert.assertThat((String)"testFormKey 1", (Object)MetadataField.formKey((String)"dc", (String)"elem", (String)"qual"), (Matcher)CoreMatchers.equalTo((Object)"dc_elem_qual"));
    }

    @Test
    public void testFind() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.mf.update(this.context);
        int id = this.mf.getFieldID();
        MetadataField found = MetadataField.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getFieldID(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getFieldID()));
        this.context.restoreAuthSystemState();
    }
}

