/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataValueTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(MetadataValueTest.class);
    private MetadataValue mv;
    private MetadataField mf;
    private String element = "contributor";
    private String qualifier = "author";

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.mf = MetadataField.findByElement((Context)this.context, (int)1, (String)this.element, (String)this.qualifier);
            this.mv = new MetadataValue(this.mf);
            this.mv.setItemId(Item.create((Context)this.context).getID());
            this.context.commit();
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorize Error in init", (Throwable)ex);
            Assert.fail((String)("Authorize Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.mf = null;
        this.mv = null;
        super.destroy();
    }

    @Test
    public void testGetFieldId() {
        MetadataValue instance = new MetadataValue();
        Assert.assertThat((String)"testGetFieldId 0", (Object)instance.getFieldId(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((String)"testGetFieldId 1", (Object)this.mv.getFieldId(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getFieldID()));
    }

    @Test
    public void testSetFieldId() {
        int fieldId = 66;
        this.mv.setFieldId(fieldId);
        Assert.assertThat((String)"testSetFieldId 0", (Object)this.mv.getFieldId(), (Matcher)CoreMatchers.equalTo((Object)fieldId));
    }

    @Test
    public void testGetItemId() {
        Assert.assertTrue((String)"testGetItemId 0", (this.mv.getItemId() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetItemId() {
        int itemId = 55;
        this.mv.setItemId(itemId);
        Assert.assertThat((String)"testSetItemId 0", (Object)this.mv.getItemId(), (Matcher)CoreMatchers.equalTo((Object)itemId));
    }

    @Test
    public void testGetLanguage() {
        Assert.assertThat((String)"testGetLanguage 0", (Object)this.mv.getLanguage(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLanguage() {
        String language = "eng";
        this.mv.setLanguage(language);
        Assert.assertThat((String)"testSetLanguage 0", (Object)this.mv.getLanguage(), (Matcher)CoreMatchers.equalTo((Object)language));
    }

    @Test
    public void testGetPlace() {
        Assert.assertThat((String)"testGetPlace 0", (Object)this.mv.getPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testSetPlace() {
        int place = 5;
        this.mv.setPlace(place);
        Assert.assertThat((String)"testSetPlace 0", (Object)this.mv.getPlace(), (Matcher)CoreMatchers.equalTo((Object)place));
    }

    @Test
    public void testGetValueId() {
        Assert.assertThat((String)"testGetValueId 0", (Object)this.mv.getValueId(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testGetValue() {
        Assert.assertThat((String)"testGetValue 0", (Object)this.mv.getValue(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.mv.setValue(value);
        Assert.assertThat((String)"testSetValue 0", (Object)this.mv.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testGetAuthority() {
        Assert.assertThat((String)"testGetAuthority 0", (Object)this.mv.getAuthority(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetAuthority() {
        String value = "auth_val";
        this.mv.setAuthority(value);
        Assert.assertThat((String)"testSetAuthority 0", (Object)this.mv.getAuthority(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testGetConfidence() {
        Assert.assertThat((String)"testGetConfidence 0", (Object)this.mv.getConfidence(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testSetConfidence() {
        int value = 5;
        this.mv.setConfidence(value);
        Assert.assertThat((String)"testSetConfidence 0", (Object)this.mv.getConfidence(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testCreate() throws Exception {
        this.mv.create(this.context);
    }

    @Test
    public void testFind() throws Exception {
        this.mv.create(this.context);
        int id = this.mv.getValueId();
        MetadataValue found = MetadataValue.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getValueId(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testFindByField() throws Exception {
        this.mv.create(this.context);
        int fieldId = this.mv.getFieldId();
        List found = MetadataValue.findByField((Context)this.context, (int)fieldId);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFind 1", (found.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        this.mv.create(this.context);
        this.mv.update(this.context);
    }

    @Test
    public void testDelete() throws Exception {
        this.mv.create(this.context);
        int id = this.mv.getValueId();
        this.mv.delete(this.context);
        MetadataValue found = MetadataValue.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDelete 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }
}

