/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SiteTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(SiteTest.class);
    private Site s;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            int id = 0;
            this.s = (Site)Site.find((Context)this.context, (int)id);
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.s = null;
        super.destroy();
    }

    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.s.getType(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.s.getID() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.s.getHandle(), (Matcher)CoreMatchers.equalTo((Object)(ConfigurationManager.getProperty((String)"handle.prefix") + "/" + String.valueOf(0))));
    }

    @Test
    public void testGetSiteHandle() {
        Assert.assertThat((String)"testGetSiteHandle 0", (Object)this.s.getHandle(), (Matcher)CoreMatchers.equalTo((Object)(ConfigurationManager.getProperty((String)"handle.prefix") + "/" + String.valueOf(0))));
    }

    @Test
    public void testSiteFind() throws Exception {
        int id = 0;
        Site found = (Site)Site.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testSiteFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSiteFind 1", (Object)found, (Matcher)CoreMatchers.equalTo((Object)this.s));
    }

    @Test
    public void testDelete() throws Exception {
        this.s.delete();
    }

    @Test
    public void testUpdate() throws Exception {
        this.s.update();
    }

    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.s.getName(), (Matcher)CoreMatchers.equalTo((Object)ConfigurationManager.getProperty((String)"dspace.name")));
    }

    @Test
    public void testGetURL() {
        Assert.assertThat((String)"testGetURL 0", (Object)this.s.getURL(), (Matcher)CoreMatchers.equalTo((Object)ConfigurationManager.getProperty((String)"dspace.url")));
    }
}

