/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersioningTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(VersioningTest.class);
    private Item originalItem;
    private Item versionedItem;
    private String summary = "Unit test version";
    private DSpace dspace = new DSpace();
    private VersioningService versioningService = (VersioningService)this.dspace.getSingletonService(VersioningService.class);

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            Collection col = Collection.create((Context)this.context);
            WorkspaceItem is = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
            this.originalItem = InstallItem.installItem((Context)this.context, (InProgressSubmission)is);
            Version version = this.versioningService.createNewVersion(this.context, this.originalItem.getID(), this.summary);
            WorkspaceItem wsi = WorkspaceItem.findByItem((Context)this.context, (Item)version.getItem());
            this.versionedItem = InstallItem.installItem((Context)this.context, (InProgressSubmission)wsi);
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)("IO Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testVersionFind() {
        VersionHistory versionHistory = this.versioningService.findVersionHistory(this.context, this.originalItem.getID());
        Assert.assertThat((String)"testFindVersionHistory", (Object)versionHistory, (Matcher)CoreMatchers.notNullValue());
        Version version = versionHistory.getVersion(this.versionedItem);
        Assert.assertThat((String)"testFindVersion", (Object)version, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testVersionSummary() throws Exception {
        VersionHistory versionHistory = this.versioningService.findVersionHistory(this.context, this.originalItem.getID());
        Version version = versionHistory.getVersion(this.versionedItem);
        Assert.assertThat((String)"Test_version_summary", (Object)this.summary, (Matcher)CoreMatchers.equalTo((Object)version.getSummary()));
    }

    @Test
    public void testVersionHandle() throws Exception {
        Assert.assertThat((String)"Test_version_handle", (Object)this.versionedItem.getHandle(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testVersionDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.versioningService.removeVersion(this.context, this.versionedItem);
        Assert.assertThat((String)"Test_version_delete", (Object)Item.find((Context)this.context, (int)this.versionedItem.getID()), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Test_version_handle_delete", (Object)HandleManager.resolveToObject((Context)this.context, (String)this.versionedItem.getHandle()), (Matcher)CoreMatchers.nullValue());
        this.context.restoreAuthSystemState();
    }
}

