/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import mockit.UsingMocksAndStubs;
import org.apache.commons.codec.DecoderException;
import org.dspace.MockConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.PasswordHash;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.services.ConfigurationService;
import org.dspace.storage.rdbms.MockDatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@UsingMocksAndStubs(value={MockDatabaseManager.class, MockConfigurationManager.class})
public class EPersonTest {
    private static TableRow row1;
    private static DSpaceKernelImpl kernel;
    private static ConfigurationService config;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ArrayList<String> epersonColumns = new ArrayList<String>();
        epersonColumns.add("eperson_id");
        epersonColumns.add("password");
        epersonColumns.add("salt");
        epersonColumns.add("digest_algorithm");
        row1 = new TableRow("EPerson", epersonColumns);
        kernel = DSpaceKernelInit.getKernel(null);
        kernel.start();
        config = kernel.getConfigurationService();
        config.setProperty("db.name", (Object)"H2");
        config.setProperty("db.driver", (Object)"org.h2.Driver");
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCheckPassword() throws SQLException, DecoderException {
        System.out.println("checkPassword");
        String attempt = "secret";
        Context ctx = new Context();
        EPerson instance = new EPerson(ctx, row1);
        String hash = "5ebe2294ecd0e0f08eab7690d2a6ee69";
        instance.setPasswordHash(new PasswordHash(null, null, "5ebe2294ecd0e0f08eab7690d2a6ee69"));
        boolean result = instance.checkPassword("secret");
        Assert.assertTrue((String)"check string with matching MD5 hash", (boolean)result);
        Assert.assertEquals((String)"should have upgraded algorithm", (Object)PasswordHash.getDefaultAlgorithm(), (Object)instance.getPasswordHash().getAlgorithm());
        Assert.assertTrue((String)"upgraded hash should still match", (boolean)instance.checkPassword("secret"));
    }

    @Test
    public void testGetType() throws SQLException {
        System.out.println("getType");
        EPerson instance = new EPerson(new Context(), row1);
        int expResult = 7;
        int result = instance.getType();
        Assert.assertEquals((String)"Should return Constants.EPERSON", (long)expResult, (long)result);
    }
}

