/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.MockDOIConnector;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.ConfigurationService;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DOIIdentifierProviderTest
extends AbstractUnitTest {
    private static final String PREFIX = "10.5072";
    private static final String NAMESPACE_SEPARATOR = "dspaceUnitTests-";
    private static ServiceManager sm = null;
    private static ConfigurationService config = null;
    private static Community community;
    private static Collection collection;
    private static MockDOIConnector connector;
    private DOIIdentifierProvider provider;
    private static int itemID;

    private static void dumpMetadata(Item eyetem) {
        DCValue[] metadata;
        for (DCValue metadatum : metadata = eyetem.getMetadata("dc", "*", "*", "*")) {
            System.out.printf("Metadata: %s.%s.%s(%s) = %s\n", metadatum.schema, metadatum.element, metadatum.qualifier, metadatum.language, metadatum.value);
        }
    }

    private Item newItem(Context ctx) throws SQLException, AuthorizeException, IOException {
        ctx.turnOffAuthorisationSystem();
        ctx.setCurrentUser(eperson);
        WorkspaceItem wsItem = WorkspaceItem.create((Context)ctx, (Collection)collection, (boolean)false);
        WorkflowItem wfItem = WorkflowManager.start((Context)ctx, (WorkspaceItem)wsItem);
        WorkflowManager.advance((Context)ctx, (WorkflowItem)wfItem, (EPerson)ctx.getCurrentUser());
        Item item = wfItem.getItem();
        item.addMetadata("dc", "contributor", "author", null, "Author, A. N.");
        item.addMetadata("dc", "title", null, null, "A Test Object");
        item.addMetadata("dc", "publisher", null, null, "DSpace Test Harness");
        String sql = "DELETE FROM Doi WHERE resource_type_id = ? AND resource_id = ?";
        DatabaseManager.updateQuery((Context)this.context, (String)sql, (Object[])new Object[]{item.getType(), item.getID()});
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        ArrayList<String> remainder = new ArrayList<String>();
        for (DCValue id : metadata) {
            if (id.value.startsWith("http://dx.doi.org")) continue;
            remainder.add(id.value);
        }
        item.clearMetadata("dc", "identifier", "uri", null);
        item.addMetadata("dc", "identifier", "uri", null, remainder.toArray(new String[remainder.size()]));
        item.update();
        ctx.commit();
        ctx.restoreAuthSystemState();
        return item;
    }

    public String createDOI(Item item, Integer status, boolean metadata) throws SQLException, IdentifierException, AuthorizeException {
        return this.createDOI(item, status, metadata, null);
    }

    public String createDOI(Item item, Integer status, boolean metadata, String doi) throws SQLException, IdentifierException, AuthorizeException {
        Random random = new Random();
        if (null == doi) {
            doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime()) + "-" + random.nextInt(997);
        }
        TableRow doiRow = DatabaseManager.create((Context)this.context, (String)"Doi");
        doiRow.setColumn("doi", doi.substring("doi:".length()));
        doiRow.setColumn("resource_type_id", item.getType());
        doiRow.setColumn("resource_id", item.getID());
        if (status == null) {
            doiRow.setColumnNull("status");
        } else {
            doiRow.setColumn("status", status.intValue());
        }
        Assume.assumeTrue((1 == DatabaseManager.update((Context)this.context, (TableRow)doiRow) ? 1 : 0) != 0);
        if (metadata) {
            item.addMetadata("dc", "identifier", "uri", null, DOI.DOIToExternalForm((String)doi));
            item.update();
        }
        this.context.commit();
        return doi;
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        sm = kernelImpl.getServiceManager();
        Context ctx = new Context();
        ctx.turnOffAuthorisationSystem();
        ctx.setCurrentUser(eperson);
        community = Community.create(null, (Context)ctx);
        community.setMetadata("name", "A Test Community");
        community.update();
        collection = community.createCollection();
        collection.setMetadata("name", "A Test Collection");
        collection.update();
        ctx.complete();
        config = kernelImpl.getConfigurationService();
        config.setProperty("identifier.doi.prefix", (Object)PREFIX);
        config.setProperty("identifier.doi.namespaceseparator", (Object)NAMESPACE_SEPARATOR);
        config.setProperty("mail.server.disabled", (Object)"true");
        connector = new MockDOIConnector();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        this.context.setCurrentUser(eperson);
        this.context.turnOffAuthorisationSystem();
        this.provider = new DOIIdentifierProvider();
        this.provider.setConfigurationService(config);
        this.provider.setDOIConnector((DOIConnector)connector);
    }

    @After
    public void tearDown() {
        this.context.restoreAuthSystemState();
        connector.reset();
    }

    @Test
    public void testSupports_Class() {
        Class<DOI> identifier = DOI.class;
        Assert.assertTrue((String)"DOI should be supported", (boolean)this.provider.supports(identifier));
    }

    @Test
    public void testSupports_valid_String() {
        String[] validDOIs;
        for (String doi : validDOIs = new String[]{"10.5072/123abc-lkj/kljl", "10.5072/dspaceUnitTests-lkjljasd1234", "doi:10.5072/123abc-lkj/kljl", "http://dx.doi.org/10.5072/123abc-lkj/kljl", "http://dx.doi.org/10.5072/123abc-lkj/kljl"}) {
            Assert.assertTrue((String)"DOI should be supported", (boolean)this.provider.supports(doi));
        }
    }

    @Test
    public void testDoes_not_support_invalid_String() {
        String[] invalidDOIs;
        for (String notADoi : invalidDOIs = new String[]{"11.5072/123abc-lkj/kljl", "http://hdl.handle.net/handle/10.5072/123abc-lkj/kljl", "", null}) {
            Assert.assertFalse((String)"Invalid DOIs shouldn't be supported", (boolean)this.provider.supports(notADoi));
        }
    }

    @Test
    public void testStore_DOI_as_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        this.provider.saveDOIToObject(this.context, (DSpaceObject)item, doi);
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        boolean result = false;
        for (DCValue id : metadata) {
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi))) continue;
            result = true;
        }
        Assert.assertTrue((String)"Cannot store DOI as item metadata value.", (boolean)result);
    }

    @Test
    public void testGet_DOI_out_of_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        item.addMetadata("dc", "identifier", "uri", null, DOI.DOIToExternalForm((String)doi));
        item.update();
        this.context.commit();
        Assert.assertTrue((String)"Failed to recognize DOI in item metadata.", (boolean)doi.equals(DOIIdentifierProvider.getDOIOutOfObject((DSpaceObject)item)));
    }

    @Test
    public void testRemove_DOI_from_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        item.addMetadata("dc", "identifier", "uri", null, DOI.DOIToExternalForm((String)doi));
        item.update();
        this.context.commit();
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi);
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        boolean foundDOI = false;
        for (DCValue id : metadata) {
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi))) continue;
            foundDOI = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI);
    }

    @Test
    public void testGet_DOI_by_DSpaceObject() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        String retrievedDOI = DOIIdentifierProvider.getDOIByObject((Context)this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Failed to load DOI by DSpaceObject.", (Object)retrievedDOI);
        Assert.assertTrue((String)"Loaded wrong DOI by DSpaceObject.", (boolean)doi.equals(retrievedDOI));
    }

    @Test
    public void testGet_DOI_lookup() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        String retrievedDOI = this.provider.lookup(this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Failed to loookup doi.", (Object)retrievedDOI);
        Assert.assertTrue((String)"Loaded wrong DOI on lookup.", (boolean)doi.equals(retrievedDOI));
    }

    @Test
    public void testGet_DSpaceObject_by_DOI() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        DSpaceObject dso = DOIIdentifierProvider.getObjectByDOI((Context)this.context, (String)doi);
        Assert.assertNotNull((String)"Failed to load DSpaceObject by DOI.", (Object)dso);
        if (item.getType() != dso.getType() || item.getID() != dso.getID()) {
            Assert.fail((String)"Object loaded by DOI was another object then expected!");
        }
    }

    @Test
    public void testResolve_DOI() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        DSpaceObject dso = this.provider.resolve(this.context, doi, new String[0]);
        Assert.assertNotNull((String)"Failed to resolve DOI.", (Object)dso);
        if (item.getType() != dso.getType() || item.getID() != dso.getID()) {
            Assert.fail((String)"Object return by DOI lookup was another object then expected!");
        }
    }

    @Test
    public void testRemove_two_DOIs_from_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi1);
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (DCValue id : metadata) {
            if (id.value.equals(DOI.DOIToExternalForm((String)doi1))) {
                foundDOI1 = true;
            }
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertTrue((String)"Removed wrong DOI from item metadata.", (boolean)foundDOI2);
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi2);
        metadata = item.getMetadata("dc", "identifier", "uri", null);
        foundDOI1 = false;
        foundDOI2 = false;
        for (DCValue id : metadata) {
            if (id.value.equals(DOI.DOIToExternalForm((String)doi1))) {
                foundDOI1 = true;
            }
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI2);
    }

    @Test
    public void testMintDOI() throws SQLException, AuthorizeException, IOException {
        Item item = this.newItem(this.context);
        String doi = null;
        try {
            doi = this.provider.mint(this.context, (DSpaceObject)item);
        }
        catch (IdentifierException e) {
            e.printStackTrace();
            Assert.fail((String)("Got an IdentifierException: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Minted DOI is null!", (Object)doi);
        Assert.assertFalse((String)"Minted DOI is empty!", (boolean)doi.isEmpty());
        try {
            DOI.formatIdentifier((String)doi);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Minted an unrecognizable DOI: " + e.getMessage()));
        }
    }

    @Test
    public void testMint_returns_existing_DOI() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, null, true);
        String retrievedDOI = this.provider.mint(this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Minted DOI is null?!", (Object)retrievedDOI);
        Assert.assertTrue((String)"Mint did not returned an existing DOI!", (boolean)doi.equals(retrievedDOI));
    }

    @Test
    public void testReserve_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, null, true);
        this.provider.reserve(this.context, (DSpaceObject)item, doi);
        TableRow doiRow = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Reservation of DOI did not set the corret DOI status.", (DOIIdentifierProvider.TO_BE_RESERVED.intValue() == doiRow.getIntColumn("status") ? 1 : 0) != 0);
    }

    @Test
    public void testRegister_unreserved_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, null, true);
        this.provider.register(this.context, (DSpaceObject)item, doi);
        TableRow doiRow = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (DOIIdentifierProvider.TO_BE_REGISTERED.intValue() == doiRow.getIntColumn("status") ? 1 : 0) != 0);
    }

    @Test
    public void testRegister_reserved_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_RESERVED, true);
        this.provider.register(this.context, (DSpaceObject)item, doi);
        TableRow doiRow = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (DOIIdentifierProvider.TO_BE_REGISTERED.intValue() == doiRow.getIntColumn("status") ? 1 : 0) != 0);
    }

    @Test
    public void testCreate_and_Register_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi = this.provider.register(this.context, (DSpaceObject)item);
        String formated_doi = DOI.formatIdentifier((String)doi);
        Assert.assertTrue((String)"DOI was not in the expected format!", (boolean)doi.equals(formated_doi));
        TableRow doiRow = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi.substring("doi:".length()));
        Assert.assertNotNull((String)"Created DOI was not stored in database.", (Object)doiRow);
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (DOIIdentifierProvider.TO_BE_REGISTERED.intValue() == doiRow.getIntColumn("status") ? 1 : 0) != 0);
    }

    @Test
    public void testDelete_specified_DOI() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.provider.delete(this.context, (DSpaceObject)item, doi1);
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (DCValue id : metadata) {
            if (id.value.equals(DOI.DOIToExternalForm((String)doi1))) {
                foundDOI1 = true;
            }
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertTrue((String)"Removed wrong DOI from item metadata.", (boolean)foundDOI2);
        TableRow doiRow1 = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow1});
        Assert.assertTrue((String)"Status of deleted DOI was not set correctly.", (DOIIdentifierProvider.TO_BE_DELETED.intValue() == doiRow1.getIntColumn("status") ? 1 : 0) != 0);
        TableRow doiRow2 = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi2.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow2});
        Assert.assertTrue((String)"While deleting a DOI the status of another changed.", (DOIIdentifierProvider.IS_REGISTERED.intValue() == doiRow2.getIntColumn("status") ? 1 : 0) != 0);
    }

    @Test
    public void testDelete_all_DOIs() throws SQLException, AuthorizeException, IOException, IdentifierException {
        Item item = this.newItem(this.context);
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.provider.delete(this.context, (DSpaceObject)item);
        DCValue[] metadata = item.getMetadata("dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (DCValue id : metadata) {
            if (id.value.equals(DOI.DOIToExternalForm((String)doi1))) {
                foundDOI1 = true;
            }
            if (!id.value.equals(DOI.DOIToExternalForm((String)doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertFalse((String)"Did not removed all DOIs from item metadata.", (boolean)foundDOI2);
        TableRow doiRow1 = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow1});
        Assert.assertTrue((String)"Status of deleted DOI was not set correctly.", (DOIIdentifierProvider.TO_BE_DELETED.intValue() == doiRow1.getIntColumn("status") ? 1 : 0) != 0);
        TableRow doiRow2 = DatabaseManager.findByUnique((Context)this.context, (String)"Doi", (String)"doi", (Object)doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow2});
        Assert.assertTrue((String)"Did not set the status of all deleted DOIs as expected.", (DOIIdentifierProvider.TO_BE_DELETED.intValue() == doiRow2.getIntColumn("status") ? 1 : 0) != 0);
    }
}

