/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import javax.servlet.http.HttpServletRequest;
import mockit.Mock;
import mockit.MockClass;
import mockit.Mockit;
import org.dspace.statistics.SolrLogger;
import org.dspace.statistics.util.DummyHttpServletRequest;
import org.dspace.statistics.util.SpiderDetector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpiderDetectorTest {
    private static final String NOT_A_BOT_ADDRESS = "192.168.0.1";

    @BeforeClass
    public static void beforeClass() {
        Mockit.setUpMocks((Object[])new Object[]{MockSolrLogger.class});
    }

    @AfterClass
    public static void afterClass() {
        Mockit.tearDownMocks((Class[])new Class[]{SolrLogger.class});
    }

    @Test
    public void testReadPatterns() {
    }

    @Test
    public void testGetSpiderIpAddresses() {
    }

    @Test
    public void testIsSpiderHttpServletRequest() {
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is watching you");
        Assert.assertTrue((String)"'msnbot' did not match any pattern", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        req.setAgent("Firefox");
        Assert.assertFalse((String)"'Firefox' matched a pattern", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        String candidate = "192.168.2.1";
        req.setAddress(candidate);
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        req.setAddress(NOT_A_BOT_ADDRESS);
        Assert.assertFalse((String)"192.168.0.1 matched IP patterns", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        candidate = "wiki.dspace.org";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testIsSpiderStringStringStringString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, (String)candidate, null));
        candidate = "wiki.dspace.org";
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, (String)candidate, null));
        candidate = "msnbot is watching you";
        Assert.assertTrue((String)("'" + candidate + "' did not match agent patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, null, (String)candidate));
        candidate = "Firefox";
        Assert.assertFalse((String)("'" + candidate + "' matched agent patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, null, (String)candidate));
    }

    @Test
    public void testIsSpiderString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
    }

    @MockClass(realClass=SolrLogger.class)
    public static class MockSolrLogger {
        @Mock
        public void $init() {
        }

        @Mock
        public void $clinit() {
        }

        @Mock
        public boolean isUseProxies() {
            return false;
        }
    }
}

