/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.util.Locale;
import org.dspace.core.I18nUtil;
import org.dspace.statistics.util.LocationUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLocationUtils {
    private static final String UNKNOWN_CONTINENT = I18nUtil.getMessage((String)"org.dspace.statistics.util.LocationUtils.unknown-continent");
    private static final String UNKNOWN_COUNTRY = I18nUtil.getMessage((String)"org.dspace.statistics.util.LocationUtils.unknown-country");

    @Test
    public void testGetContinentCode() {
        Assert.assertEquals((Object)LocationUtils.getContinentCode((String)"US"), (Object)"NA");
        Assert.assertTrue((LocationUtils.getContinentCode(null).length() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((LocationUtils.getContinentCode((String)"xyz").length() > 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetContinentNameString() {
        Assert.assertEquals((Object)"North America", (Object)LocationUtils.getContinentName((String)"NA"));
        Assert.assertEquals((Object)UNKNOWN_CONTINENT, (Object)LocationUtils.getContinentName(null));
        Assert.assertEquals((Object)UNKNOWN_CONTINENT, (Object)LocationUtils.getContinentName((String)"XXXX"));
    }

    @Test
    public void testGetContinentNameStringLocale() {
        Assert.assertEquals((Object)"North America", (Object)LocationUtils.getContinentName((String)"NA", (Locale)Locale.ENGLISH));
    }

    @Test
    public void testGetCountryNameString() {
        Assert.assertEquals((Object)Locale.US.getDisplayCountry(), (Object)LocationUtils.getCountryName((String)"US"));
        Assert.assertEquals((Object)UNKNOWN_COUNTRY, (Object)LocationUtils.getCountryName(null));
        Assert.assertEquals((Object)"XX", (Object)LocationUtils.getCountryName((String)"XX"));
    }

    @Test
    public void testGetCountryNameStringLocale() {
        Assert.assertEquals((Object)"United States", (Object)LocationUtils.getCountryName((String)"US", (Locale)Locale.ENGLISH));
    }
}

