/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import mockit.Mock;
import mockit.MockClass;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.ColumnInfo;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

@MockClass(realClass=DatabaseManager.class)
public class MockDatabaseManager {
    private static Logger log = Logger.getLogger(DatabaseManager.class);
    private static boolean initialized = false;
    private static Map<String, String> insertSQL = new HashMap<String, String>();
    private static boolean isOracle = false;
    private static boolean isPostgres = false;
    private static String poolName;
    private static final Pattern DB_SAFE_NAME;
    private static Map<String, Map<String, ColumnInfo>> info;
    private static ObjectPool connectionPool;

    @Mock
    public void $init() {
    }

    @Mock
    public void $clinit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static void setConstraintDeferred(Context context, String constraintName) throws SQLException {
        Statement statement = null;
        try {
            statement = context.getDBConnection().createStatement();
            statement.execute("SET REFERENTIAL_INTEGRITY FALSE");
            statement.close();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static void setConstraintImmediate(Context context, String constraintName) throws SQLException {
        Statement statement = null;
        try {
            statement = context.getDBConnection().createStatement();
            statement.execute("SET REFERENTIAL_INTEGRITY TRUE");
            statement.close();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Mock
    public static TableRowIterator queryTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Running query \"").append(query).append("\"  with parameters: ");
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)sb.toString());
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            MockDatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery(), MockDatabaseManager.canonicalize(table));
            retTRI.setStatement((Statement)statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    @Mock
    public static TableRowIterator query(Context context, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)("Running query \"" + query + "\"  with parameters: " + sb.toString()));
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            MockDatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery());
            retTRI.setStatement((Statement)statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static TableRow querySingle(Context context, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = null;
        try {
            iterator = MockDatabaseManager.query(context, query, parameters);
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static TableRow querySingleTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = MockDatabaseManager.queryTable(context, MockDatabaseManager.canonicalize(table), query, parameters);
        try {
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static int updateQuery(Context context, String query, Object ... parameters) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Running query \"").append(query).append("\"  with parameters: ");
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)sb.toString());
        }
        try {
            statement = context.getDBConnection().prepareStatement(query);
            MockDatabaseManager.loadParameters(statement, parameters);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Mock
    public static TableRow create(Context context, String table) throws SQLException {
        TableRow row = new TableRow(MockDatabaseManager.canonicalize(table), MockDatabaseManager.getColumnNames(table));
        MockDatabaseManager.insert(context, row);
        return row;
    }

    @Mock
    public static TableRow find(Context context, String table, int id) throws SQLException {
        String ctable = MockDatabaseManager.canonicalize(table);
        return MockDatabaseManager.findByUnique(context, ctable, MockDatabaseManager.getPrimaryKeyColumn(ctable), new Integer(id));
    }

    @Mock
    public static TableRow findByUnique(Context context, String table, String column, Object value) throws SQLException {
        String ctable = MockDatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute select query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute select query because column name (" + column + ") contains non alphanumeric characters.");
        }
        StringBuilder sql = new StringBuilder("select * from ").append(ctable).append(" where ").append(column).append(" = ? ");
        return MockDatabaseManager.querySingleTable(context, ctable, sql.toString(), value);
    }

    @Mock
    public static int delete(Context context, String table, int id) throws SQLException {
        String ctable = MockDatabaseManager.canonicalize(table);
        return MockDatabaseManager.deleteByValue(context, ctable, MockDatabaseManager.getPrimaryKeyColumn(ctable), new Integer(id));
    }

    @Mock
    public static int deleteByValue(Context context, String table, String column, Object value) throws SQLException {
        String ctable = MockDatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute delete query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute delete query because column name (" + column + ") contains non alphanumeric characters.");
        }
        StringBuilder sql = new StringBuilder("delete from ").append(ctable).append(" where ").append(column).append(" = ? ");
        return MockDatabaseManager.updateQuery(context, sql.toString(), value);
    }

    @Mock
    public static Connection getConnection() throws SQLException {
        MockDatabaseManager.initialize();
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        String callers = "";
        for (int i = 0; i < Math.min(elements.length, 4); ++i) {
            callers = callers + " > " + elements[i].getClassName() + ":" + elements[i].getMethodName();
        }
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + poolName);
    }

    @Mock
    public static void freeConnection(Connection c) {
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        String callers = "";
        for (int i = 0; i < Math.min(elements.length, 4); ++i) {
            callers = callers + " > " + elements[i].getClassName() + ":" + elements[i].getMethodName();
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Mock
    public static TableRow row(String table) throws SQLException {
        return new TableRow(MockDatabaseManager.canonicalize(table), MockDatabaseManager.getColumnNames(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static void insert(Context context, TableRow row) throws SQLException {
        int newID = -1;
        String table = row.getTable();
        Statement statement = null;
        ResultSet rs = null;
        try {
            String myQuery = "SELECT NEXTVAL('" + table + "_seq') AS result";
            statement = context.getDBConnection().createStatement();
            rs = statement.executeQuery(myQuery);
            rs.next();
            newID = rs.getInt(1);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException myQuery) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException myQuery) {}
            }
        }
        if (newID < 0) {
            throw new SQLException("Unable to retrieve sequence ID");
        }
        row.setColumn(MockDatabaseManager.getPrimaryKeyColumn(table), newID);
        Collection<ColumnInfo> info = MockDatabaseManager.getColumnInfo(table);
        String sql = insertSQL.get(table);
        if (sql == null) {
            StringBuilder sqlBuilder = new StringBuilder().append("INSERT INTO ").append(table).append(" ( ");
            boolean firstColumn = true;
            for (ColumnInfo col : info) {
                if (firstColumn) {
                    sqlBuilder.append(col.getName());
                    firstColumn = false;
                    continue;
                }
                sqlBuilder.append(",").append(col.getName());
            }
            sqlBuilder.append(") VALUES ( ");
            firstColumn = true;
            for (int i = 0; i < info.size(); ++i) {
                if (firstColumn) {
                    sqlBuilder.append("?");
                    firstColumn = false;
                    continue;
                }
                sqlBuilder.append(",").append("?");
            }
            sqlBuilder.append(")");
            sql = sqlBuilder.toString();
            insertSQL.put(table, sql);
        }
        MockDatabaseManager.execute(context.getDBConnection(), sql.toString(), info, row);
    }

    @Mock
    public static int update(Context context, TableRow row) throws SQLException {
        String table = row.getTable();
        StringBuilder sql = new StringBuilder().append("update ").append(table).append(" set ");
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        ColumnInfo pk = MockDatabaseManager.getPrimaryKeyColumnInfo(table);
        Collection<ColumnInfo> info = MockDatabaseManager.getColumnInfo(table);
        String separator = "";
        for (ColumnInfo col : info) {
            if (col.isPrimaryKey() || !row.hasColumnChanged(col.getName())) continue;
            sql.append(separator).append(col.getName()).append(" = ?");
            columns.add(col);
            separator = ", ";
        }
        if (columns.size() > 0) {
            sql.append(" where ").append(pk.getName()).append(" = ?");
            columns.add(pk);
            return MockDatabaseManager.executeUpdate(context.getDBConnection(), sql.toString(), columns, row);
        }
        return 1;
    }

    @Mock
    public static int delete(Context context, TableRow row) throws SQLException {
        String pk = MockDatabaseManager.getPrimaryKeyColumn(row);
        if (row.isColumnNull(pk)) {
            throw new IllegalArgumentException("Primary key value is null");
        }
        return MockDatabaseManager.delete(context, row.getTable(), row.getIntColumn(pk));
    }

    @Mock
    static Collection<ColumnInfo> getColumnInfo(String table) throws SQLException {
        Map<String, ColumnInfo> cinfo = MockDatabaseManager.getColumnInfoInternal(table);
        return cinfo == null ? null : cinfo.values();
    }

    @Mock
    static ColumnInfo getColumnInfo(String table, String column) throws SQLException {
        Map<String, ColumnInfo> info = MockDatabaseManager.getColumnInfoInternal(table);
        return info == null ? null : info.get(column);
    }

    @Mock
    static List<String> getColumnNames(String table) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        Collection<ColumnInfo> info = MockDatabaseManager.getColumnInfo(table);
        for (ColumnInfo col : info) {
            results.add(col.getName());
        }
        return results;
    }

    @Mock
    static List<String> getColumnNames(ResultSetMetaData meta) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        int columns = meta.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            results.add(meta.getColumnLabel(i + 1));
        }
        return results;
    }

    @Mock
    static String canonicalize(String table) {
        if (isOracle) {
            return table == null ? null : table.toUpperCase();
        }
        return table == null ? null : table.toLowerCase();
    }

    @Mock
    public static void loadSql(String sql) throws SQLException {
        try {
            MockDatabaseManager.loadSql(new StringReader(sql));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    public static void loadSql(Reader r) throws SQLException, IOException {
        BufferedReader reader = new BufferedReader(r);
        StringBuffer sql = new StringBuffer();
        String SQL = null;
        String line = null;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = MockDatabaseManager.getConnection();
            connection.setAutoCommit(true);
            statement = connection.createStatement();
            boolean inquote = false;
            while ((line = reader.readLine()) != null) {
                block14: {
                    int endMarker;
                    String input;
                    int commentStart = line.indexOf("--");
                    String string = input = commentStart != -1 ? line.substring(0, commentStart) : line;
                    if (input.trim().equals("")) continue;
                    sql.append(input.replace(';', ' '));
                    sql.append(" ");
                    int index = 0;
                    int count = 0;
                    int inputlen = input.length();
                    while ((index = input.indexOf("'", count)) != -1) {
                        boolean bl = inquote = !inquote;
                        count = index + 1;
                        if (count < inputlen) continue;
                    }
                    if (inquote || (endMarker = input.indexOf(";", index)) == -1) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running database query \"" + sql + "\""));
                    }
                    SQL = sql.toString();
                    try {
                        boolean bl = statement.execute(SQL);
                    }
                    catch (SQLWarning sqlw) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Got SQL Warning: " + sqlw), (Throwable)sqlw);
                        }
                    }
                    catch (SQLException sqle) {
                        boolean isNoResults;
                        String msg = "Got SQL Exception: " + sqle;
                        String sqlmessage = sqle.getMessage();
                        boolean isDrop = SQL != null && sqlmessage != null && SQL.toUpperCase().startsWith("DROP") && sqlmessage.indexOf("does not exist") != -1;
                        boolean bl = isNoResults = SQL != null && sqlmessage != null && (SQL.toUpperCase().startsWith("CREATE VIEW") || SQL.toUpperCase().startsWith("CREATE FUNCTION")) && sqlmessage.indexOf("No results were returned") != -1;
                        if (isDrop || isNoResults) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg, (Throwable)sqle);
                            }
                        }
                        if (!log.isEnabledFor((Priority)Level.WARN)) break block14;
                        log.warn((Object)msg, (Throwable)sqle);
                    }
                }
                sql = new StringBuffer();
                SQL = null;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Mock
    static TableRow process(ResultSet results, String table) throws SQLException {
        return MockDatabaseManager.process(results, table, null);
    }

    @Mock
    static TableRow process(ResultSet results, String table, List<String> pColumnNames) throws SQLException {
        String dbName = ConfigurationManager.getProperty((String)"db.name");
        ResultSetMetaData meta = results.getMetaData();
        int columns = meta.getColumnCount() + 1;
        List<String> columnNames = pColumnNames != null ? pColumnNames : (table == null ? MockDatabaseManager.getColumnNames(meta) : MockDatabaseManager.getColumnNames(table));
        TableRow row = new TableRow(MockDatabaseManager.canonicalize(table), columnNames);
        for (int i = 1; i < columns; ++i) {
            String name = meta.getColumnName(i);
            int jdbctype = meta.getColumnType(i);
            if (jdbctype == -7 || jdbctype == 16) {
                row.setColumn(name, results.getBoolean(i));
            } else if (jdbctype == 4 || jdbctype == 2 || jdbctype == 3) {
                if ("oracle".equals(dbName)) {
                    long longValue = results.getLong(i);
                    if (longValue <= Integer.MAX_VALUE) {
                        row.setColumn(name, (int)longValue);
                    } else {
                        row.setColumn(name, longValue);
                    }
                } else {
                    row.setColumn(name, results.getInt(i));
                }
            } else if (jdbctype == -5) {
                row.setColumn(name, results.getLong(i));
            } else if (jdbctype == 8) {
                row.setColumn(name, results.getDouble(i));
            } else if (jdbctype == 2005 && "oracle".equals(dbName)) {
                row.setColumn(name, results.getString(i));
            } else if (jdbctype == 12) {
                row.setColumn(name, results.getString(i));
            } else if (jdbctype == 91) {
                row.setColumn(name, (java.util.Date)results.getDate(i));
            } else if (jdbctype == 92) {
                row.setColumn(name, (java.util.Date)results.getTime(i));
            } else if (jdbctype == 93) {
                row.setColumn(name, (java.util.Date)results.getTimestamp(i));
            } else {
                throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype + " (" + name + ")");
            }
            if (!results.wasNull()) continue;
            row.setColumnNull(name);
        }
        row.resetChanged();
        return row;
    }

    @Mock
    public static String getPrimaryKeyColumn(TableRow row) throws SQLException {
        return MockDatabaseManager.getPrimaryKeyColumn(row.getTable());
    }

    @Mock
    protected static String getPrimaryKeyColumn(String table) throws SQLException {
        ColumnInfo cinfo = MockDatabaseManager.getPrimaryKeyColumnInfo(table);
        return cinfo == null ? null : cinfo.getName();
    }

    @Mock
    static ColumnInfo getPrimaryKeyColumnInfo(String table) throws SQLException {
        Collection<ColumnInfo> cinfo = MockDatabaseManager.getColumnInfo(MockDatabaseManager.canonicalize(table));
        for (ColumnInfo info : cinfo) {
            if (!info.isPrimaryKey()) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    private static void execute(Connection connection, String sql, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        try {
            statement = connection.prepareStatement(sql);
            MockDatabaseManager.loadParameters(statement, columns, row);
            statement.execute();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    private static int executeUpdate(Connection connection, String sql, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        try {
            statement = connection.prepareStatement(sql);
            MockDatabaseManager.loadParameters(statement, columns, row);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Mock
    private static Map<String, ColumnInfo> getColumnInfoInternal(String table) throws SQLException {
        String ctable = MockDatabaseManager.canonicalize(table);
        Map<String, ColumnInfo> results = info.get(ctable);
        if (results != null) {
            return results;
        }
        results = MockDatabaseManager.retrieveColumnInfo(ctable);
        info.put(ctable, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mock
    private static Map<String, ColumnInfo> retrieveColumnInfo(String table) throws SQLException {
        Connection connection = null;
        ResultSet pkcolumns = null;
        ResultSet columns = null;
        try {
            String schema = ConfigurationManager.getProperty((String)"db.schema");
            String catalog = null;
            int dotIndex = table.indexOf(".");
            if (dotIndex > 0) {
                catalog = table.substring(0, dotIndex);
                table = table.substring(dotIndex + 1, table.length());
                log.warn((Object)("catalog: " + catalog));
                log.warn((Object)("table: " + table));
            }
            connection = MockDatabaseManager.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            HashMap<String, ColumnInfo> results = new HashMap<String, ColumnInfo>();
            pkcolumns = metadata.getPrimaryKeys(catalog, schema, table);
            HashSet<String> pks = new HashSet<String>();
            while (pkcolumns.next()) {
                pks.add(pkcolumns.getString(4));
            }
            columns = metadata.getColumns(catalog, schema, table, null);
            while (columns.next()) {
                String column = columns.getString(4);
                ColumnInfo cinfo = new ColumnInfo();
                cinfo.setName(column);
                cinfo.setType((int)columns.getShort(5));
                if (pks.contains(column)) {
                    cinfo.setIsPrimaryKey(true);
                }
                results.put(column, cinfo);
            }
            HashMap<String, ColumnInfo> hashMap = results;
            return hashMap;
        }
        finally {
            if (pkcolumns != null) {
                try {
                    pkcolumns.close();
                }
                catch (SQLException sQLException) {}
            }
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Mock
    public static synchronized void shutdown() throws SQLException {
        if (initialized) {
            initialized = false;
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            if (driver != null) {
                driver.closePool(poolName);
            }
        }
    }

    @Mock
    private static synchronized void initialize() throws SQLException {
        if (initialized) {
            return;
        }
        try {
            PoolingDriver driver;
            Class.forName(ConfigurationManager.getProperty((String)"db.driver"));
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
            int maxConnections = ConfigurationManager.getIntProperty((String)"db.maxconnections");
            if (ConfigurationManager.getProperty((String)"db.maxconnections") == null) {
                maxConnections = 30;
            }
            int maxWait = ConfigurationManager.getIntProperty((String)"db.maxwait");
            if (ConfigurationManager.getProperty((String)"db.maxwait") == null) {
                maxWait = 5000;
            }
            int maxIdle = ConfigurationManager.getIntProperty((String)"db.maxidle");
            if (ConfigurationManager.getProperty((String)"db.maxidle") == null) {
                maxIdle = -1;
            }
            boolean useStatementPool = ConfigurationManager.getBooleanProperty((String)"db.statementpool", (boolean)true);
            connectionPool = new GenericObjectPool(null, maxConnections, 1, (long)maxWait, maxIdle, true, false);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(ConfigurationManager.getProperty((String)"db.url"), ConfigurationManager.getProperty((String)"db.username"), ConfigurationManager.getProperty((String)"db.password"));
            String validationQuery = "SELECT 1";
            if ("oracle".equals(ConfigurationManager.getProperty((String)"db.name"))) {
                validationQuery = "SELECT 1 FROM DUAL";
            }
            GenericKeyedObjectPoolFactory statementFactory = null;
            if (useStatementPool) {
                GenericKeyedObjectPool.Config statementFactoryConfig = new GenericKeyedObjectPool.Config();
                statementFactoryConfig.whenExhaustedAction = (byte)2;
                statementFactory = new GenericKeyedObjectPoolFactory(null, statementFactoryConfig);
            }
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, connectionPool, statementFactory, validationQuery, false, false);
            if (ConfigurationManager.getProperty((String)"db.poolname") != null) {
                poolName = ConfigurationManager.getProperty((String)"db.poolname");
            }
            if ((driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:")) != null) {
                driver.registerPool(poolName, connectionPool);
            }
            String s = new String();
            StringBuilder sb = new StringBuilder();
            String schemaPath = System.getProperty("db.schema.path");
            if (null == schemaPath) {
                throw new IllegalArgumentException("System property db.schema.path must be defined");
            }
            FileReader fr = new FileReader(new File(schemaPath));
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                if ("".equals(s.trim()) || s.trim().startsWith("--")) continue;
                sb.append(s);
            }
            br.close();
            String[] stmts = sb.toString().split(";");
            Connection con = DriverManager.getConnection("jdbc:apache:commons:dbcp:" + poolName);
            Statement st = con.createStatement();
            for (int i = 0; i < stmts.length; ++i) {
                if (stmts[i].trim().equals("")) continue;
                st.executeUpdate(stmts[i]);
                log.debug((Object)("Loading into database: " + stmts[i]));
            }
            con.commit();
            con.close();
            initialized = true;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            log.warn((Object)"Exception initializing DB pool", (Throwable)e);
            throw new SQLException(e.toString());
        }
    }

    @Mock
    protected static void loadParameters(PreparedStatement statement, Object[] parameters) throws SQLException {
        statement.clearParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            int idx = i + 1;
            if (parameter == null) {
                throw new SQLException("Attempting to insert null value into SQL query.");
            }
            if (parameter instanceof String) {
                statement.setString(idx, (String)parameters[i]);
                continue;
            }
            if (parameter instanceof Integer) {
                int ii = (Integer)parameter;
                statement.setInt(idx, ii);
                continue;
            }
            if (parameter instanceof Double) {
                double d = (Double)parameter;
                statement.setDouble(idx, d);
                continue;
            }
            if (parameter instanceof Float) {
                float f = ((Float)parameter).floatValue();
                statement.setFloat(idx, f);
                continue;
            }
            if (parameter instanceof Short) {
                short s = (Short)parameter;
                statement.setShort(idx, s);
                continue;
            }
            if (parameter instanceof Long) {
                long l = (Long)parameter;
                statement.setLong(idx, l);
                continue;
            }
            if (parameter instanceof Date) {
                Date date = (Date)parameter;
                statement.setDate(idx, date);
                continue;
            }
            if (parameter instanceof Time) {
                Time time = (Time)parameter;
                statement.setTime(idx, time);
                continue;
            }
            if (parameter instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)parameter;
                statement.setTimestamp(idx, timestamp);
                continue;
            }
            throw new SQLException("Attempting to insert unknown datatype (" + parameter.getClass().getName() + ") into SQL statement.");
        }
    }

    @Mock
    private static void loadParameters(PreparedStatement statement, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        int count = 0;
        block11: for (ColumnInfo info : columns) {
            ++count;
            String column = info.getName();
            int jdbctype = info.getType();
            if (row.isColumnNull(column)) {
                statement.setNull(count, jdbctype);
                continue;
            }
            switch (jdbctype) {
                case -7: 
                case 16: {
                    statement.setBoolean(count, row.getBooleanColumn(column));
                    continue block11;
                }
                case 4: {
                    if (isOracle) {
                        statement.setLong(count, row.getLongColumn(column));
                        continue block11;
                    }
                    statement.setInt(count, row.getIntColumn(column));
                    continue block11;
                }
                case 2: 
                case 3: {
                    statement.setLong(count, row.getLongColumn(column));
                    continue block11;
                }
                case -5: {
                    statement.setLong(count, row.getLongColumn(column));
                    continue block11;
                }
                case 2005: {
                    if (isOracle) {
                        statement.setString(count, row.getStringColumn(column));
                        continue block11;
                    }
                    throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
                }
                case 12: {
                    statement.setString(count, row.getStringColumn(column));
                    continue block11;
                }
                case 91: {
                    statement.setDate(count, new Date(row.getDateColumn(column).getTime()));
                    continue block11;
                }
                case 92: {
                    statement.setTime(count, new Time(row.getDateColumn(column).getTime()));
                    continue block11;
                }
                case 93: {
                    statement.setTimestamp(count, new Timestamp(row.getDateColumn(column).getTime()));
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
        }
    }

    static {
        if ("oracle".equals(ConfigurationManager.getProperty((String)"db.name"))) {
            isOracle = true;
            isPostgres = false;
        } else {
            isOracle = false;
            isPostgres = true;
        }
        poolName = "dspacepool";
        DB_SAFE_NAME = Pattern.compile("^[a-zA-Z_1-9.]+$");
        info = new HashMap<String, Map<String, ColumnInfo>>();
    }
}

