/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.CollectionHelper;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicWorkflowAuthorizationIntegrationTest
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(BasicWorkflowAuthorizationIntegrationTest.class);
    protected ConfigurationService configurationService = new DSpace().getConfigurationService();
    protected Community owningCommunity = null;
    protected Collection collection = null;
    protected Group group = null;
    protected EPerson member = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = Community.create(null, (Context)this.context);
            this.collection = this.owningCommunity.createCollection();
            this.member = EPerson.create((Context)this.context);
            this.member.setEmail("john.smith@example.com");
            this.member.setFirstName("John");
            this.member.setLastName("Smith");
            this.group = Group.create((Context)this.context);
            this.group.addMember(this.member);
            this.group.update();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void destroy() {
        block22: {
            try {
                this.context.turnOffAuthorisationSystem();
                if (this.collection != null) {
                    try {
                        CollectionHelper.delete(this.collection);
                    }
                    catch (IOException e) {
                        log.error((Object)"deleting collection", (Throwable)e);
                    }
                    catch (SQLException e) {
                        log.error((Object)"deleting collection", (Throwable)e);
                    }
                    catch (AuthorizeException e) {
                        log.error((Object)"deleting collection", (Throwable)e);
                    }
                    this.collection = null;
                }
                if (this.owningCommunity != null) {
                    try {
                        this.owningCommunity.delete();
                    }
                    catch (IOException e) {
                        log.error((Object)"deleting community", (Throwable)e);
                    }
                    catch (SQLException e) {
                        log.error((Object)"deleting community", (Throwable)e);
                    }
                    catch (AuthorizeException e) {
                        log.error((Object)"deleting community", (Throwable)e);
                    }
                    this.owningCommunity = null;
                }
                if (this.member == null) break block22;
                if (this.group != null) {
                    try {
                        this.group.removeMember(this.member);
                    }
                    catch (Exception e) {
                        log.error((Object)"detaching group relationship", (Throwable)e);
                    }
                    try {
                        this.group.delete();
                    }
                    catch (SQLException e) {
                        log.error((Object)"deleting group");
                    }
                    this.group = null;
                }
                try {
                    this.member.delete();
                }
                catch (SQLException e) {
                    log.error((Object)"deleting user", (Throwable)e);
                }
                catch (AuthorizeException e) {
                    log.error((Object)"deleting user", (Throwable)e);
                }
                catch (EPersonDeletionException e) {
                    log.error((Object)"deleting user", (Throwable)e);
                }
            }
            finally {
                this.context.restoreAuthSystemState();
            }
        }
        super.destroy();
    }

    private void setWorkflowGroup(Collection collection, int step, Group group) throws SQLException, AuthorizeException {
        collection.setWorkflowGroup(step, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowGroupSetsPermission() throws SQLException, AuthorizeException {
        int step = 1;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, step, this.group);
            this.collection.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.setCurrentUser(this.member);
        Assert.assertThat((String)("Workflow step " + step + " Group is not our test Group"), (Object)this.collection.getWorkflowGroup(step), (Matcher)CoreMatchers.equalTo((Object)this.group));
        Assert.assertTrue((String)"Test EPerson is not member of test Group", (boolean)this.group.isMember(this.member));
        Assert.assertTrue((String)("Test EPerson is not authorized for step " + step), (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)this.collection, (int)5, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowGroupRevokesPermission() throws SQLException, AuthorizeException {
        int step = 1;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, step, this.group);
            this.collection.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.setCurrentUser(this.member);
        Assert.assertThat((String)("Test workflow group is not the group for step " + step), (Object)this.collection.getWorkflowGroup(step), (Matcher)CoreMatchers.equalTo((Object)this.group));
        Assert.assertTrue((String)("Member of test workflow group not authorized for step " + step), (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)this.collection, (int)5, (boolean)true));
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, step, null);
            this.collection.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        Assert.assertThat((String)("Workflow step " + step + "group is not null"), (Object)this.collection.getWorkflowGroup(step), (Matcher)CoreMatchers.nullValue());
        Assert.assertFalse((String)("Member of test workflow group is still authorized for step " + step), (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)this.collection, (int)5, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReviewerPermissions() throws SQLException, AuthorizeException, IOException {
        Bundle bundle;
        WorkflowItem wfi = null;
        try {
            this.context.turnOffAuthorisationSystem();
            this.setWorkflowGroup(this.collection, 1, this.group);
            this.collection.update();
            WorkspaceItem wsi = WorkspaceItem.create((Context)this.context, (Collection)this.collection, (boolean)false);
            Item item = wsi.getItem();
            bundle = item.createBundle("ORIGINAL");
            File f = new File(testProps.get("test.bitstream").toString());
            Bitstream bs = bundle.createBitstream((InputStream)new FileInputStream(f));
            bundle.update();
            item.update();
            wsi.update();
            wfi = WorkflowManager.startWithoutNotify((Context)this.context, (WorkspaceItem)wsi);
            wfi.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.setCurrentUser(this.member);
        wfi = WorkflowItem.find((Context)this.context, (int)wfi.getID());
        WorkflowManager.claim((Context)this.context, (WorkflowItem)wfi, (EPerson)this.context.getCurrentUser());
        Item item = wfi.getItem();
        int i = 0;
        for (int action : new int[]{0, 1, 3, 4, 2}) {
            Assert.assertTrue((String)("testReviewerPermissions 1-" + i++), (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)item, (int)action, (boolean)false));
        }
        bundle = item.getBundles("ORIGINAL")[0];
        Bitstream bitstream = bundle.getBitstreams()[0];
        Assert.assertTrue((String)"testReviewerPermissions 2-1", (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bundle, (int)0, (boolean)false));
        Assert.assertTrue((String)("testReviewerPermissions 2-2" + i++), (boolean)AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bitstream, (int)0, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AuthorizeException.class)
    public void testNonWorkflowGroupMemberCannotClaimTask() throws SQLException, AuthorizeException, IOException {
        WorkflowItem wfi = null;
        EPerson someone = null;
        try {
            this.context.turnOffAuthorisationSystem();
            someone = EPerson.create((Context)this.context);
            someone.setEmail("jane.doe@example.com");
            someone.setFirstName("Jane");
            someone.setLastName("Doe");
            this.setWorkflowGroup(this.collection, 1, this.group);
            this.collection.update();
            WorkspaceItem wsi = WorkspaceItem.create((Context)this.context, (Collection)this.collection, (boolean)false);
            Item item = wsi.getItem();
            Bundle bundle = item.createBundle("ORIGINAL");
            File f = new File(testProps.get("test.bitstream").toString());
            Bitstream bs = bundle.createBitstream((InputStream)new FileInputStream(f));
            bundle.update();
            item.update();
            wsi.update();
            wfi = WorkflowManager.startWithoutNotify((Context)this.context, (WorkspaceItem)wsi);
            wfi.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.setCurrentUser(someone);
        wfi = WorkflowItem.find((Context)this.context, (int)wfi.getID());
        WorkflowManager.claim((Context)this.context, (WorkflowItem)wfi, (EPerson)this.context.getCurrentUser());
        Assert.fail((String)"Someone, not part of a workflow step group was able to claim a task without an AUthorizeException.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AuthorizeException.class)
    public void testNonWorkflowGroupSubmitterCannotClaimTask() throws SQLException, AuthorizeException, IOException {
        WorkflowItem wfi = null;
        EPerson submitter = null;
        try {
            this.context.turnOffAuthorisationSystem();
            submitter = EPerson.create((Context)this.context);
            submitter.setEmail("richard.roe@example.com");
            submitter.setFirstName("Richard");
            submitter.setLastName("Roe");
            this.setWorkflowGroup(this.collection, 1, this.group);
            this.collection.update();
            WorkspaceItem wsi = WorkspaceItem.create((Context)this.context, (Collection)this.collection, (boolean)false);
            Item item = wsi.getItem();
            item.setSubmitter(submitter);
            Bundle bundle = item.createBundle("ORIGINAL");
            File f = new File(testProps.get("test.bitstream").toString());
            Bitstream bs = bundle.createBitstream((InputStream)new FileInputStream(f));
            bundle.update();
            item.update();
            wsi.update();
            wfi = WorkflowManager.startWithoutNotify((Context)this.context, (WorkspaceItem)wsi);
            wfi.update();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.setCurrentUser(submitter);
        wfi = WorkflowItem.find((Context)this.context, (int)wfi.getID());
        WorkflowManager.claim((Context)this.context, (WorkflowItem)wfi, (EPerson)this.context.getCurrentUser());
        Assert.fail((String)"A submitter was able to claim a task without being a member of the appropriate workflow step group. Expected: AuthorizeException.");
    }
}

