/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicWorkflowAuthorizationRolesIntegrationTest
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(BasicWorkflowAuthorizationRolesIntegrationTest.class);
    protected ConfigurationService configurationService = new DSpace().getConfigurationService();
    protected Community owningCommunity = null;
    protected Collection collection = null;
    protected Item item = null;
    protected WorkflowItem wfi = null;
    protected Group mgroup = null;
    protected EPerson member = null;
    protected WorkspaceItem wsi = null;
    protected HashMap<ROLE, Group> roleGroups = new HashMap();
    protected HashMap<ROLE, EPerson> roleEPersons = new HashMap();
    protected final String aLanguage = Locale.US.getLanguage();

    public BasicWorkflowAuthorizationRolesIntegrationTest() {
        this.roleGroups.clear();
        this.roleEPersons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.configurationService.setProperty("workflow.notify.returned.tasks", (Object)false);
            this.context.turnOffAuthorisationSystem();
            long date = new Date().getTime();
            this.owningCommunity = Community.create(null, (Context)this.context);
            this.owningCommunity.update();
            this.collection = this.owningCommunity.createCollection();
            this.collection.update();
            this.member = EPerson.create((Context)this.context);
            this.member.setEmail(String.format("wf-member-%d@example.org", date));
            this.member.setFirstName("Member");
            this.member.setLanguage(this.aLanguage);
            this.member.update();
            this.mgroup = Group.create((Context)this.context);
            this.mgroup.addMember(this.member);
            this.mgroup.setName(String.format("Member Group %d", date));
            this.mgroup.update();
            for (ROLE role : ROLE.values()) {
                EPerson person = EPerson.create((Context)this.context);
                person.setFirstName(String.format("%d", date));
                person.setLastName(String.format("Role %s", role.toString()));
                person.setEmail(String.format("basicwf-test-%s-%d@example.org", role.toString(), date));
                person.setLanguage(this.aLanguage);
                person.update();
                this.roleEPersons.put(role, person);
                Group pgroup = Group.create((Context)this.context);
                this.roleGroups.put(role, pgroup);
                pgroup.setName(String.format("Group %s %d", role.toString(), date));
                pgroup.addMember(person);
                pgroup.update();
                log.info((Object)String.format("Create ROLE %s GROUP %s PERSON %s", role.toString(), pgroup.getName(), person.getFullName()));
            }
            this.context.commit();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    private void contextReload() {
        try {
            if (this.context.isValid()) {
                this.context.commit();
            } else {
                this.context.abort();
            }
            this.context.complete();
            this.context = new Context();
            if (this.item != null) {
                int itemid = this.item.getID();
                this.item = Item.find((Context)this.context, (int)itemid);
            }
            if (this.wfi != null) {
                int wfid = this.wfi.getID();
                this.wfi = WorkflowItem.find((Context)this.context, (int)wfid);
            }
            for (ROLE role : ROLE.values()) {
                EPerson eperson = this.roleEPersons.get((Object)role);
                Group grp = this.roleGroups.get((Object)role);
                eperson = EPerson.find((Context)this.context, (int)eperson.getID());
                Assert.assertNotNull((Object)eperson);
                this.roleEPersons.put(role, eperson);
                this.roleGroups.put(role, Group.find((Context)this.context, (int)grp.getID()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error reloading context", (Throwable)e);
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.complete();
            super.destroy();
            this.context.clearCache();
        }
        catch (Exception e) {
            log.error((Object)"Error in destroy", (Throwable)e);
        }
    }

    private void setupItemAndStartWorkflow() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        this.context.setCurrentUser(this.roleEPersons.get((Object)ROLE.SUB));
        this.wsi = WorkspaceItem.create((Context)this.context, (Collection)this.collection, (boolean)false);
        this.item = this.wsi.getItem();
        Bundle bundle = this.item.createBundle("ORIGINAL");
        bundle.update();
        this.item.update();
        this.wsi.update();
        this.wfi = WorkflowManager.start((Context)this.context, (WorkspaceItem)this.wsi);
        this.wfi.update();
        this.context.commit();
    }

    private void setWorkflowGroup(Context context, int step, Group group) throws SQLException, AuthorizeException {
        this.collection.setWorkflowGroup(step, group);
    }

    private void setStepPermissions(ROLE step1, ROLE step2, ROLE step3) throws SQLException, AuthorizeException {
        Group group;
        AuthorizeManager.addPolicy((Context)this.context, (DSpaceObject)this.collection, (int)11, (Group)this.roleGroups.get((Object)ROLE.ADMIN));
        Group last = null;
        if (step1 != null) {
            group = this.roleGroups.get((Object)step1);
            this.setWorkflowGroup(this.context, 1, group);
            last = group;
        }
        if (step2 != null) {
            group = this.roleGroups.get((Object)step2);
            this.setWorkflowGroup(this.context, 2, group);
            last = group;
        }
        if (step3 != null) {
            group = this.roleGroups.get((Object)step3);
            this.setWorkflowGroup(this.context, 3, group);
            last = group;
        }
        AuthorizeManager.addPolicy((Context)this.context, (DSpaceObject)this.collection, (int)3, last);
        this.collection.update();
        this.context.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep1AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep1AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep1ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep1Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP1, false);
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP1, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep2AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep2AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep2ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep2Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP2, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep3AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep3AllRolesClaim() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep3ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithStep3Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemUnclaim(ROLE.STEP3, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps12AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps12ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps12Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, null);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP2, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps13AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps13ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps13Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, null, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertNull((Object)this.collection.getWorkflowGroup(2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps23AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps23ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps23Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(null, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertNull((Object)this.collection.getWorkflowGroup(1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps123AllRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps123ExpectedRoles() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testsetWorkflowWithSteps123Submitter() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        try {
            this.context.turnOffAuthorisationSystem();
            this.setStepPermissions(ROLE.STEP1, ROLE.STEP2, ROLE.STEP3);
            this.setupItemAndStartWorkflow();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            this.contextReload();
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(1), (Object)this.roleGroups.get((Object)ROLE.STEP1));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(2), (Object)this.roleGroups.get((Object)ROLE.STEP2));
            Assert.assertEquals((Object)this.collection.getWorkflowGroup(3), (Object)this.roleGroups.get((Object)ROLE.STEP3));
            Assert.assertEquals((long)1L, (long)this.wfi.getState());
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP1, false);
            Assert.assertEquals((long)2L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP1, false);
            Assert.assertEquals((long)3L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP2, false);
            Assert.assertEquals((long)4L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvance(ROLE.SUB, true);
            this.attemptItemAdvance(ROLE.STEP2, false);
            Assert.assertEquals((long)5L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemClaim(ROLE.SUB, true);
            this.attemptItemClaim(ROLE.STEP3, false);
            Assert.assertEquals((long)6L, (long)this.wfi.getState());
            this.contextReload();
            this.attemptItemAdvanceFinal(ROLE.SUB, true);
            this.attemptItemAdvanceFinal(ROLE.STEP3, false);
            this.contextReload();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
        catch (AuthorizeException e) {
            e.printStackTrace(System.err);
            log.error((Object)"Exception found in processing", (Throwable)e);
            this.contextReload();
            throw e;
        }
    }

    public void attemptItemClaim(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemClaim(role, true);
        }
        if (roleValid != null) {
            this.attemptItemClaim(roleValid, false);
        }
    }

    public void attemptItemAdvance(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemAdvance(role, true);
        }
        if (roleValid != null) {
            this.attemptItemAdvance(roleValid, false);
        }
    }

    public void attemptItemAdvanceFinal(ROLE roleValid) throws SQLException, AuthorizeException, IOException {
        for (ROLE role : ROLE.values()) {
            if (role == ROLE.ADMIN || role == roleValid) continue;
            this.attemptItemAdvanceFinal(role, true);
        }
        if (roleValid != null) {
            this.attemptItemAdvanceFinal(roleValid, false);
        }
    }

    public void attemptItemClaim(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        if (expectAuthFail) {
            try {
                WorkflowManager.claim((Context)this.context, (WorkflowItem)this.wfi, (EPerson)this.context.getCurrentUser());
            }
            catch (AuthorizeException authorizeException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to claim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertNull((Object)this.wfi.getOwner());
        } else {
            WorkflowManager.claim((Context)this.context, (WorkflowItem)this.wfi, (EPerson)this.context.getCurrentUser());
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to claim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertThat((Object)state, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.wfi.getState())));
            Assert.assertNotNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemUnclaim(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        if (expectAuthFail) {
            try {
                WorkflowManager.unclaim((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            }
            catch (AuthorizeException authorizeException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to unclaim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertNotNull((Object)this.wfi.getOwner());
        } else {
            WorkflowManager.unclaim((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to unclaim task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertThat((Object)state, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.wfi.getState())));
            Assert.assertNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemAdvance(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        EPerson owner = this.wfi.getOwner();
        if (expectAuthFail) {
            try {
                WorkflowManager.advance((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            }
            catch (AuthorizeException authorizeException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contextReload();
            owner = EPerson.find((Context)this.context, (int)owner.getID());
            eperson = this.roleEPersons.get((Object)role);
            if (state != this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is able to advance task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertEquals((Object)owner, (Object)this.wfi.getOwner());
        } else {
            WorkflowManager.advance((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (state == this.wfi.getState()) {
                log.error((Object)String.format("USER[%-20s] is unable to advance task (state %d -> %d) (unexpected)", eperson.getFullName(), state, this.wfi.getState()), (Throwable)new Exception());
            }
            Assert.assertThat((Object)state, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.wfi.getState())));
            Assert.assertNull((Object)this.wfi.getOwner());
        }
        Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
    }

    public void attemptItemAdvanceFinal(ROLE role, boolean expectAuthFail) throws SQLException, AuthorizeException, IOException {
        EPerson eperson = this.roleEPersons.get((Object)role);
        this.context.setCurrentUser(eperson);
        int state = this.wfi.getState();
        EPerson owner = this.wfi.getOwner();
        if (expectAuthFail) {
            try {
                WorkflowManager.advance((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            }
            catch (AuthorizeException authorizeException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contextReload();
            owner = EPerson.find((Context)this.context, (int)owner.getID());
            eperson = this.roleEPersons.get((Object)role);
            if (this.wfi == null) {
                log.error((Object)String.format("USER[%-20s] is able to advance task to completion from state %d (unexpected)", eperson.getFullName(), state), (Throwable)new Exception());
            }
            Assert.assertNotNull((Object)this.wfi);
            Assert.assertEquals((long)state, (long)this.wfi.getState());
            Assert.assertEquals((Object)owner, (Object)this.wfi.getOwner());
            Assert.assertFalse((boolean)this.wfi.getItem().isArchived());
        } else {
            WorkflowManager.advance((Context)this.context, (WorkflowItem)this.wfi, (EPerson)eperson);
            this.contextReload();
            eperson = this.roleEPersons.get((Object)role);
            if (this.wfi != null) {
                log.error((Object)String.format("USER[%-20s] is unable to advance task to completion from state %d (unexpected)", eperson.getFullName(), state), (Throwable)new Exception());
            }
            Assert.assertNull((Object)this.wfi);
            Assert.assertTrue((boolean)this.item.isArchived());
        }
    }

    protected static enum ROLE {
        ADMIN,
        SUB,
        STEP1,
        STEP2,
        STEP3;

    }
}

