/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.curate.CurationTask;
import org.dspace.curate.Curator;
import org.dspace.handle.HandleManager;

public abstract class AbstractCurationTask
implements CurationTask {
    protected Curator curator = null;
    protected String taskId = null;
    private Properties taskProps = null;
    private static Logger log = Logger.getLogger(AbstractCurationTask.class);

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        this.curator = curator;
        this.taskId = taskId;
    }

    @Override
    public abstract int perform(DSpaceObject var1) throws IOException;

    protected void distribute(DSpaceObject dso) throws IOException {
        try {
            this.performObject(dso);
            int type = dso.getType();
            if (3 == type) {
                ItemIterator iter = ((Collection)dso).getItems();
                while (iter.hasNext()) {
                    this.performObject(iter.next());
                }
            } else if (4 == type) {
                Community comm = (Community)dso;
                for (Community community : comm.getSubcommunities()) {
                    this.distribute(community);
                }
                for (DSpaceObject dSpaceObject : comm.getCollections()) {
                    this.distribute(dSpaceObject);
                }
            } else if (5 == type) {
                Community[] topComm;
                for (Community community : topComm = Community.findAllTop(Curator.curationContext())) {
                    this.distribute(community);
                }
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void performObject(DSpaceObject dso) throws SQLException, IOException {
        if (dso.getType() == 2) {
            this.performItem((Item)dso);
        }
    }

    protected void performItem(Item item) throws SQLException, IOException {
    }

    @Override
    public int perform(Context ctx, String id) throws IOException {
        DSpaceObject dso = this.dereference(ctx, id);
        return dso != null ? this.perform(dso) : 1;
    }

    protected DSpaceObject dereference(Context ctx, String id) throws IOException {
        try {
            return HandleManager.resolveToObject(ctx, id);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void report(String message) {
        this.curator.report(message);
    }

    protected void setResult(String result) {
        this.curator.setResult(this.taskId, result);
    }

    protected String taskProperty(String name) {
        if (this.taskProps == null) {
            this.taskProps = new Properties();
            StringBuilder modName = new StringBuilder();
            for (String segment : this.taskId.split("\\.")) {
                modName.append(segment);
                Properties modProps = ConfigurationManager.getProperties(modName.toString());
                if (modProps != null) {
                    this.taskProps.putAll((Map<?, ?>)modProps);
                }
                modName.append(".");
            }
            if (this.taskProps.size() == 0) {
                log.warn((Object)("Warning: No configuration properties found for task: " + this.taskId));
            }
        }
        return this.taskProps.getProperty(name);
    }

    protected int taskIntProperty(String name, int defaultValue) {
        int intVal = defaultValue;
        String strVal = this.taskProperty(name);
        if (strVal != null) {
            try {
                intVal = Integer.parseInt(strVal.trim());
            }
            catch (NumberFormatException nfE) {
                log.warn((Object)("Warning: Number format error in module: " + this.taskId + " property: " + name));
            }
        }
        return intVal;
    }

    protected long taskLongProperty(String name, long defaultValue) {
        long longVal = defaultValue;
        String strVal = this.taskProperty(name);
        if (strVal != null) {
            try {
                longVal = Long.parseLong(strVal.trim());
            }
            catch (NumberFormatException nfE) {
                log.warn((Object)("Warning: Number format error in module: " + this.taskId + " property: " + name));
            }
        }
        return longVal;
    }

    protected boolean taskBooleanProperty(String name, boolean defaultValue) {
        String strVal = this.taskProperty(name);
        if (strVal != null) {
            return (strVal = strVal.trim()).equalsIgnoreCase("true") || strVal.equalsIgnoreCase("yes");
        }
        return defaultValue;
    }
}

