/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class CollectionRole {
    private Context myContext;
    private TableRow myRow;

    CollectionRole(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static CollectionRole find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "cwf_collectionrole", id);
        if (row == null) {
            return null;
        }
        return new CollectionRole(context, row);
    }

    public static CollectionRole find(Context context, int collection, String role) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_collectionrole", "SELECT * FROM cwf_collectionrole WHERE collection_id=" + collection + " AND role_id= ? ", role);
        TableRow row = null;
        if (tri.hasNext()) {
            row = tri.next();
        }
        tri.close();
        if (row == null) {
            return null;
        }
        return new CollectionRole(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionRole[] findByCollection(Context context, int collection) throws SQLException {
        ArrayList<CollectionRole> collectionRoles = new ArrayList<CollectionRole>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_collectionrole", "SELECT * FROM cwf_collectionrole WHERE collection_id=?", collection);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                collectionRoles.add(new CollectionRole(context, row));
            }
        }
        return collectionRoles.toArray(new CollectionRole[collectionRoles.size()]);
    }

    public static CollectionRole create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "cwf_collectionrole");
        return new CollectionRole(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }

    public void setRoleId(String id) {
        this.myRow.setColumn("role_id", id);
    }

    public String getRoleId() {
        return this.myRow.getStringColumn("role_id");
    }

    public void setCollectionId(int id) {
        this.myRow.setColumn("collection_id", id);
    }

    public int getCollectionId() {
        return this.myRow.getIntColumn("collection_id");
    }

    public void setGroupId(Group group) {
        this.myRow.setColumn("group_id", group.getID());
    }

    public Group getGroup() throws SQLException {
        return Group.find(this.myContext, this.myRow.getIntColumn("group_id"));
    }
}

