/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.IOException;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.xpath.XPathAPI;
import org.dspace.administer.RegistryImportException;
import org.dspace.administer.RegistryImporter;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataImporter {
    private static final Logger log = LoggerFactory.getLogger(MetadataImporter.class);

    public static void main(String[] args) throws ParseException, SQLException, IOException, TransformerException, ParserConfigurationException, AuthorizeException, SAXException, NonUniqueMetadataException, RegistryImportException {
        boolean forceUpdate = false;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("f", "file", true, "source xml file for DC fields");
        options.addOption("u", "update", false, "update an existing schema");
        CommandLine line = parser.parse(options, args);
        String file = null;
        if (line.hasOption('f')) {
            file = line.getOptionValue('f');
        } else {
            MetadataImporter.usage();
            System.exit(0);
        }
        forceUpdate = line.hasOption('u');
        MetadataImporter.loadRegistry(file, forceUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRegistry(String file, boolean forceUpdate) throws SQLException, IOException, TransformerException, ParserConfigurationException, AuthorizeException, SAXException, NonUniqueMetadataException, RegistryImportException {
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            Document document = RegistryImporter.loadXML(file);
            NodeList schemaNodes = XPathAPI.selectNodeList((Node)document, (String)"/dspace-dc-types/dc-schema");
            for (int i = 0; i < schemaNodes.getLength(); ++i) {
                Node n = schemaNodes.item(i);
                MetadataImporter.loadSchema(context, n, forceUpdate);
            }
            NodeList typeNodes = XPathAPI.selectNodeList((Node)document, (String)"/dspace-dc-types/dc-type");
            for (int i = 0; i < typeNodes.getLength(); ++i) {
                Node n = typeNodes.item(i);
                MetadataImporter.loadType(context, n);
            }
            context.restoreAuthSystemState();
            context.complete();
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    private static void loadSchema(Context context, Node node, boolean updateExisting) throws SQLException, IOException, TransformerException, AuthorizeException, NonUniqueMetadataException, RegistryImportException {
        String name = RegistryImporter.getElementData(node, "name");
        String namespace = RegistryImporter.getElementData(node, "namespace");
        if (name == null || "".equals(name)) {
            throw new RegistryImportException("Name of schema must be supplied");
        }
        if (namespace == null || "".equals(namespace)) {
            throw new RegistryImportException("Namespace of schema must be supplied");
        }
        MetadataSchema s = MetadataSchema.find(context, name);
        if (s == null) {
            log.info("Registering Schema " + name + " (" + namespace + ")");
            MetadataSchema schema = new MetadataSchema(namespace, name);
            schema.create(context);
        } else {
            if (s.getNamespace().equals(namespace)) {
                return;
            }
            if (updateExisting) {
                log.info("Updating Schema " + name + ": New namespace " + namespace);
                s.setNamespace(namespace);
                s.update(context);
            } else {
                throw new RegistryImportException("Schema " + name + " already registered with different namespace " + namespace + ". Rerun with 'update' option enabled if you wish to update this schema.");
            }
        }
    }

    private static void loadType(Context context, Node node) throws SQLException, IOException, TransformerException, AuthorizeException, NonUniqueMetadataException, RegistryImportException {
        MetadataSchema schemaObj;
        String schema = RegistryImporter.getElementData(node, "schema");
        String element = RegistryImporter.getElementData(node, "element");
        String qualifier = RegistryImporter.getElementData(node, "qualifier");
        String scopeNote = RegistryImporter.getElementData(node, "scope_note");
        if (schema == null) {
            schema = "dc";
        }
        if ((schemaObj = MetadataSchema.find(context, schema)) == null) {
            throw new RegistryImportException("Schema '" + schema + "' is not registered and does not exist.");
        }
        MetadataField mf = MetadataField.findByElement(context, schemaObj.getSchemaID(), element, qualifier);
        if (mf != null) {
            return;
        }
        String fieldName = schema + "." + element + "." + qualifier;
        if (qualifier == null) {
            fieldName = schema + "." + element;
        }
        log.info("Registering metadata field " + fieldName);
        MetadataField field = new MetadataField();
        field.setSchemaID(schemaObj.getSchemaID());
        field.setElement(element);
        field.setQualifier(qualifier);
        field.setScopeNote(scopeNote);
        field.create(context);
    }

    public static void usage() {
        String usage = "Use this class with the following option:\n -f <xml source file> : specify which xml source file contains the DC fields to import.\n";
        System.out.println(usage);
    }
}

