/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.DecoderException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RoleIngester
implements PackageIngester {
    private static final Logger log = LoggerFactory.getLogger(RoleIngester.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void ingestDocument(Context context, DSpaceObject parent, PackageParameters params, Document document) throws SQLException, AuthorizeException, PackageException {
        DSpaceObject groupObj;
        String name;
        Element group;
        int groupx;
        DSpaceObject collider;
        String myEmail = context.getCurrentUser().getEmail();
        String myNetid = context.getCurrentUser().getNetid();
        NodeList users = document.getElementsByTagName("Person");
        for (int i = 0; i < users.getLength(); ++i) {
            EPerson eperson;
            String netid;
            String email;
            Element user;
            block40: {
                String identity;
                user = (Element)users.item(i);
                NodeList emails = user.getElementsByTagName("Email");
                NodeList netids = user.getElementsByTagName("Netid");
                email = null;
                netid = null;
                if (emails.getLength() > 0) {
                    email = emails.item(0).getTextContent();
                    if (email.equals(myEmail)) continue;
                    identity = email;
                    collider = EPerson.findByEmail(context, identity);
                } else {
                    if (netids.getLength() <= 0) {
                        throw new PackageException("EPerson has neither email nor netid.");
                    }
                    netid = netids.item(0).getTextContent();
                    if (netid.equals(myNetid)) continue;
                    identity = netid;
                    collider = EPerson.findByNetid(context, identity);
                }
                if (null != collider) {
                    if (params.replaceModeEnabled()) {
                        eperson = collider;
                        break block40;
                    } else {
                        if (!params.keepExistingModeEnabled()) {
                            throw new PackageException("EPerson " + identity + " already exists.");
                        }
                        log.warn("Existing EPerson {} was not restored from the package.", (Object)identity);
                        continue;
                    }
                }
                eperson = EPerson.create(context);
                log.info("Created EPerson {}.", (Object)identity);
            }
            eperson.setEmail(email);
            eperson.setNetid(netid);
            NodeList nodeList = user.getElementsByTagName("FirstName");
            if (nodeList.getLength() > 0) {
                eperson.setFirstName(nodeList.item(0).getTextContent());
            } else {
                eperson.setFirstName(null);
            }
            NodeList nodeList2 = user.getElementsByTagName("LastName");
            if (nodeList2.getLength() > 0) {
                eperson.setLastName(nodeList2.item(0).getTextContent());
            } else {
                eperson.setLastName(null);
            }
            NodeList nodeList3 = user.getElementsByTagName("Language");
            if (nodeList3.getLength() > 0) {
                eperson.setLanguage(nodeList3.item(0).getTextContent());
            } else {
                eperson.setLanguage(null);
            }
            NodeList nodeList4 = user.getElementsByTagName("CanLogin");
            eperson.setCanLogIn(nodeList4.getLength() > 0);
            NodeList nodeList5 = user.getElementsByTagName("RequireCertificate");
            eperson.setRequireCertificate(nodeList5.getLength() > 0);
            NodeList nodeList6 = user.getElementsByTagName("SelfRegistered");
            eperson.setSelfRegistered(nodeList6.getLength() > 0);
            NodeList nodeList7 = user.getElementsByTagName("PasswordHash");
            if (nodeList7.getLength() > 0) {
                PasswordHash password;
                Node element = nodeList7.item(0);
                NamedNodeMap attributes = element.getAttributes();
                Node algorithm = attributes.getNamedItem("digest");
                String algorithmText = null != algorithm ? algorithm.getNodeValue() : null;
                Node salt = attributes.getNamedItem("salt");
                String saltText = null != salt ? salt.getNodeValue() : null;
                try {
                    password = new PasswordHash(algorithmText, saltText, element.getTextContent());
                }
                catch (DecoderException ex) {
                    throw new PackageValidationException("Unable to decode hexadecimal password hash or salt", (Exception)((Object)ex));
                }
                eperson.setPasswordHash(password);
            } else {
                eperson.setPasswordHash(null);
            }
            eperson.update();
        }
        NodeList groups = document.getElementsByTagName("Group");
        for (groupx = 0; groupx < groups.getLength(); ++groupx) {
            block41: {
                block43: {
                    String type;
                    block44: {
                        Collection collection;
                        block47: {
                            block46: {
                                block45: {
                                    group = (Element)groups.item(groupx);
                                    name = group.getAttribute("Name");
                                    log.debug("Processing group {}", (Object)name);
                                    try {
                                        name = PackageUtils.translateGroupNameForImport(context, name);
                                    }
                                    catch (PackageException pe) {
                                        log.warn("Skipping group named '" + name + "' as it seems to correspond to a Community or Collection that does not exist in the system.  " + "If you are performing an AIP restore, you can ignore this warning as the Community/Collection AIP will likely create this group once it is processed.");
                                        continue;
                                    }
                                    log.debug("Translated group name:  {}", (Object)name);
                                    groupObj = null;
                                    collider = Group.findByName(context, name);
                                    if (null != collider) {
                                        if (params.replaceModeEnabled()) {
                                            for (Group group2 : ((Group)collider).getMemberGroups()) {
                                                ((Group)collider).removeMember(group2);
                                            }
                                            for (DSpaceObject dSpaceObject : ((Group)collider).getMembers()) {
                                                if (((Group)collider).equals(Group.find(context, 1)) && ((EPerson)dSpaceObject).equals(context.getCurrentUser())) continue;
                                                ((Group)collider).removeMember((EPerson)dSpaceObject);
                                            }
                                            log.info("Existing Group {} was cleared. Its members will be replaced.", (Object)name);
                                            groupObj = collider;
                                            break block41;
                                        } else {
                                            if (!params.keepExistingModeEnabled()) {
                                                throw new PackageException("Group " + name + " already exists");
                                            }
                                            log.warn("Existing Group {} was not replaced from the package.", (Object)name);
                                            continue;
                                        }
                                    }
                                    log.debug("Creating group for a {}", (Object)parent.getTypeText());
                                    type = group.getAttribute("Type");
                                    log.debug("Group type is {}", (Object)type);
                                    if (type == null || type.isEmpty() || parent == null) break block43;
                                    if (parent.getType() != 3) break block44;
                                    collection = (Collection)parent;
                                    if (!type.equals("ADMIN")) break block45;
                                    groupObj = collection.createAdministrators();
                                    break block43;
                                }
                                if (!type.equals("SUBMIT")) break block46;
                                groupObj = collection.createSubmitters();
                                break block43;
                            }
                            if (!type.equals("WORKFLOW_STEP_1")) break block47;
                            groupObj = collection.createWorkflowGroup(1);
                            break block43;
                        }
                        if (type.equals("WORKFLOW_STEP_2")) {
                            groupObj = collection.createWorkflowGroup(2);
                            break block43;
                        } else if (type.equals("WORKFLOW_STEP_3")) {
                            groupObj = collection.createWorkflowGroup(3);
                        }
                        break block43;
                    }
                    if (parent.getType() == 4) {
                        Community community = (Community)parent;
                        if (type.equals("ADMIN")) {
                            groupObj = community.createAdministrators();
                        }
                    }
                }
                if (groupObj == null) {
                    groupObj = Group.create(context);
                }
                ((Group)groupObj).setName(name);
                log.info("Created Group {}.", (Object)((Group)groupObj).getName());
            }
            NodeList members = group.getElementsByTagName("Member");
            for (int memberx = 0; memberx < members.getLength(); ++memberx) {
                Element member = (Element)members.item(memberx);
                String string = member.getAttribute("Name");
                EPerson memberEPerson = EPerson.findByEmail(context, string);
                if (null == memberEPerson) {
                    throw new PackageValidationException("EPerson " + string + " not found, not added to " + name);
                }
                ((Group)groupObj).addMember(memberEPerson);
            }
            ((Group)groupObj).update();
        }
        groupx = 0;
        while (true) {
            block42: {
                if (groupx >= groups.getLength()) {
                    return;
                }
                group = (Element)groups.item(groupx);
                name = group.getAttribute("Name");
                log.debug("Processing group {}", (Object)name);
                try {
                    name = PackageUtils.translateGroupNameForImport(context, name);
                    log.debug("Translated group name:  {}", (Object)name);
                }
                catch (PackageException pe) {
                    break block42;
                }
                groupObj = Group.findByName(context, name);
                log.debug("Looked up the group and found {}", (Object)groupObj);
                NodeList members = group.getElementsByTagName("MemberGroup");
                for (int memberx = 0; memberx < members.getLength(); ++memberx) {
                    Element member = (Element)members.item(memberx);
                    String memberName = member.getAttribute("Name");
                    memberName = PackageUtils.translateGroupNameForImport(context, memberName);
                    Group group3 = Group.findByName(context, memberName);
                    ((Group)groupObj).addMember(group3);
                }
                ((Group)groupObj).update();
            }
            ++groupx;
        }
    }

    public static void ingestStream(Context context, DSpaceObject parent, PackageParameters params, InputStream stream) throws PackageException, SQLException, AuthorizeException {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setCoalescing(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new PackageException(e);
        }
        catch (SAXException e) {
            throw new PackageException(e);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        RoleIngester.ingestDocument(context, parent, params, document);
    }

    @Override
    public DSpaceObject ingest(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setCoalescing(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(pkgFile);
        }
        catch (ParserConfigurationException e) {
            throw new PackageException(e);
        }
        catch (SAXException e) {
            throw new PackageException(e);
        }
        RoleIngester.ingestDocument(context, parent, params, document);
        return null;
    }

    @Override
    public List<DSpaceObject> ingestAll(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new PackageException("ingestAll() is not implemented, as ingest() method already handles ingestion of all roles from an external file.");
    }

    @Override
    public DSpaceObject replace(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        return this.ingest(context, dso, pkgFile, params, null);
    }

    @Override
    public List<DSpaceObject> replaceAll(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new PackageException("replaceAll() is not implemented, as replace() method already handles replacement of all roles from an external file.");
    }

    @Override
    public String getParameterHelp() {
        return "No additional options available.";
    }
}

