/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.sql.SQLException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.rdf.RDFMissingIdentifierException;
import org.dspace.rdf.RDFUtil;

public class RDFConsumer
implements Consumer {
    private static final Logger log = Logger.getLogger(RDFConsumer.class);
    protected Deque<DSOIdentifier> toConvert;
    protected Deque<DSOIdentifier> toDelete;

    @Override
    public void consume(Context ctx, Event event) throws SQLException {
        if (this.toConvert == null) {
            log.debug((Object)"Initalized first queue.");
            this.toConvert = new LinkedList<DSOIdentifier>();
        }
        if (this.toDelete == null) {
            log.debug((Object)"Initalized second queue.");
            this.toDelete = new LinkedList<DSOIdentifier>();
        }
        int sType = event.getSubjectType();
        switch (sType) {
            case 0: {
                this.consumeBitstream(ctx, event);
            }
            case 1: {
                this.consumeBundles(ctx, event);
                return;
            }
            case 2: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 3: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 4: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 5: {
                this.consumeSite(ctx, event);
                return;
            }
        }
        log.warn((Object)("RDFConsumer should not have been given this kind of subject in an event, skipping: " + event.toString()));
    }

    public void consumeBitstream(Context ctx, Event event) throws SQLException {
        if (event.getEventType() == 2 || event.getEventType() == 4) {
            Bundle[] bundles;
            Bitstream bitstream = Bitstream.find(ctx, event.getSubjectID());
            if (bitstream == null) {
                log.warn((Object)("Cannot find bitstream " + event.getSubjectID() + "! " + "Ignoring, as it is likely it was deleted " + "and we'll cover it by a REMOVE event on its bundle."));
                return;
            }
            for (Bundle b : bundles = bitstream.getBundles()) {
                Item[] items;
                for (Item i : items = b.getItems()) {
                    DSOIdentifier id = new DSOIdentifier(i, ctx);
                    if (this.toDelete.contains(id) || this.toConvert.contains(id)) continue;
                    this.toConvert.addLast(id);
                }
            }
            return;
        }
        if (event.getEventType() == 1 || event.getEventType() == 32) {
            return;
        }
        log.warn((Object)("Got an unexpected event type (" + event.getEventTypeAsString() + ") for a bitstream. Ignoring."));
    }

    public void consumeBundles(Context ctx, Event event) throws SQLException {
        if (event.getEventType() == 8 || event.getEventType() == 16 || event.getEventType() == 2 || event.getEventType() == 4) {
            Item[] items;
            Bundle bundle = Bundle.find(ctx, event.getSubjectID());
            if (bundle == null) {
                log.warn((Object)("Cannot find bundle " + event.getSubjectID() + "! " + "Ignoring, as it is likely it was deleted " + "and we'll cover it by a REMOVE event on its item."));
                return;
            }
            for (Item i : items = bundle.getItems()) {
                DSOIdentifier id = new DSOIdentifier(i, ctx);
                if (this.toDelete.contains(id) || this.toConvert.contains(id)) continue;
                this.toConvert.addLast(id);
            }
        }
        if (event.getEventType() == 1 || event.getEventType() == 32) {
            return;
        }
        log.warn((Object)("Got an unexpected event type (" + event.getEventTypeAsString() + ") for a bundle. Ignoring."));
    }

    public void consumeCommunityCollectionItem(Context ctx, Event event) throws SQLException {
        if (event.getSubjectType() != 4 && event.getSubjectType() != 3 && event.getSubjectType() != 2) {
            log.error((Object)("Called on an unexpected Event with subject type " + event.getSubjectTypeAsString() + " and event type " + event.getEventTypeAsString() + ", ignoring."));
            return;
        }
        if (event.getEventType() == 32) {
            DSOIdentifier id = new DSOIdentifier(event.getSubjectType(), event.getSubjectID(), event.getDetail(), event.getIdentifiers());
            if (this.toConvert.contains(id)) {
                this.toConvert.remove(id);
            }
            if (!this.toDelete.contains(id)) {
                this.toDelete.addLast(id);
            }
            return;
        }
        if (event.getEventType() == 2 || event.getEventType() == 4 || event.getEventType() == 8 || event.getEventType() == 16 || event.getEventType() == 1) {
            DSpaceObject dso = event.getSubject(ctx);
            if (dso == null) {
                log.warn((Object)("Cannot find " + event.getSubjectTypeAsString() + " " + event.getSubjectID() + "! " + "Ignoring, as it is " + "likely it was deleted and we'll cover it by another " + "event with the type REMOVE."));
                return;
            }
            DSOIdentifier id = new DSOIdentifier(dso, ctx);
            if (dso instanceof Item && event.getDetail() != null && event.getDetail().equals("WITHDRAW")) {
                if (this.toConvert.contains(id)) {
                    this.toConvert.remove(id);
                }
                if (!this.toDelete.contains(id)) {
                    this.toDelete.add(id);
                    return;
                }
            }
            if (!this.toDelete.contains(id) && !this.toConvert.contains(id)) {
                this.toConvert.addLast(id);
            }
        }
    }

    public void consumeSite(Context ctx, Event event) {
        if (event.getEventType() == 8 || event.getEventType() == 16) {
            DSOIdentifier id = new DSOIdentifier(5, 0, Site.getSiteHandle(), new String[]{Site.getSiteHandle()});
            if (!this.toConvert.contains(id)) {
                this.toConvert.add(id);
            }
            return;
        }
        log.warn((Object)("Got an unexpected Event for the SITE. Event type is " + event.getEventTypeAsString() + ", ignoring."));
    }

    @Override
    public void end(Context ctx) throws Exception {
        DSOIdentifier id;
        log.debug((Object)"Started processing of queued events.");
        ctx = new Context(1);
        if (this.toDelete == null) {
            log.debug((Object)"Deletion queue does not exists, creating empty queue.");
            this.toDelete = new LinkedList<DSOIdentifier>();
        }
        if (this.toConvert != null) {
            log.debug((Object)"Starting conversion of DSpaceObjects.");
            while (true) {
                try {
                    id = this.toConvert.removeFirst();
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                if (this.toDelete.contains(id)) {
                    log.debug((Object)("Skipping " + Constants.typeText[id.type] + " " + Integer.toString(id.id) + " as it is marked for " + "deletion as well."));
                    continue;
                }
                log.debug((Object)("Converting " + Constants.typeText[id.type] + " " + Integer.toString(id.id) + "."));
                this.convert(ctx, id);
            }
            log.debug((Object)"Conversion ended.");
        }
        log.debug((Object)"Starting to delete data from the triple store...");
        while (true) {
            try {
                id = this.toDelete.removeFirst();
            }
            catch (NoSuchElementException ex) {
                break;
            }
            log.debug((Object)("Going to delete data from " + Constants.typeText[id.type] + " " + Integer.toString(id.id) + "."));
            this.delete(ctx, id);
        }
        ctx.abort();
        log.debug((Object)"Deletion finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convert(Context ctx, DSOIdentifier id) throws SQLException {
        try (Model m = null;){
            if (id.type == 5) {
                m = RDFUtil.convertAndStore(ctx, Site.find(ctx, 0));
                return;
            }
            DSpaceObject dso = DSpaceObject.find(ctx, id.type, id.id);
            if (dso == null) {
                log.error((Object)("Cannot find " + Constants.typeText[id.type] + " " + id.id + " unexpectedly! Will delete all " + "information about it in the triple store."));
                this.toDelete.add(id);
                return;
            }
            m = RDFUtil.convertAndStore(ctx, dso);
        }
    }

    void delete(Context context, DSOIdentifier id) throws SQLException {
        try {
            RDFUtil.delete(context, id.type, id.id, id.handle, id.identifiers);
        }
        catch (RDFMissingIdentifierException ex) {
            log.warn((Object)("Cannot delete " + Constants.typeText[id.type] + " " + Integer.toString(id.id) + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }

    @Override
    public void initialize() throws Exception {
    }

    class DSOIdentifier {
        int type;
        int id;
        String handle;
        String[] identifiers;

        DSOIdentifier(int type, int id, String handle, String[] identifiers) {
            this.type = type;
            this.id = id;
            this.handle = handle;
            this.identifiers = identifiers;
        }

        DSOIdentifier(DSpaceObject dso, Context ctx) {
            if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
                throw new IllegalArgumentException("Provided DSpaceObject does not have a handle!");
            }
            this.type = dso.getType();
            this.id = dso.getID();
            this.handle = dso.getHandle();
            this.identifiers = dso.getIdentifiers(ctx);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DSOIdentifier)) {
                return false;
            }
            DSOIdentifier dsoId = (DSOIdentifier)o;
            return this.type == dsoId.type && this.id == dsoId.id;
        }

        public int hashCode() {
            return this.type + 10 * this.id;
        }
    }
}

