/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.indexer.AuthorityIndexingService;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;

public class AuthorityIndexClient {
    private static Logger log = Logger.getLogger(AuthorityIndexClient.class);

    public static void main(String[] args) throws Exception {
        ContextNoCaching context = new ContextNoCaching();
        context.turnOffAuthorisationSystem();
        ServiceManager serviceManager = AuthorityIndexClient.getServiceManager();
        AuthorityIndexingService indexingService = (AuthorityIndexingService)serviceManager.getServiceByName(AuthorityIndexingService.class.getName(), AuthorityIndexingService.class);
        List indexers = serviceManager.getServicesByType(AuthorityIndexerInterface.class);
        if (!AuthorityIndexClient.isConfigurationValid(indexingService, indexers)) {
            System.out.println("Cannot index authority values since the configuration isn't valid. Check dspace logs for more information.");
            return;
        }
        System.out.println("Retrieving all data");
        log.info((Object)"Retrieving all data");
        HashMap<String, AuthorityValue> toIndexValues = new HashMap<String, AuthorityValue>();
        for (AuthorityIndexerInterface indexerInterface : indexers) {
            log.info((Object)("Initialize " + indexerInterface.getClass().getName()));
            System.out.println("Initialize " + indexerInterface.getClass().getName());
            indexerInterface.init(context);
            while (indexerInterface.hasMore()) {
                AuthorityValue authorityValue = indexerInterface.nextValue();
                if (authorityValue == null) continue;
                toIndexValues.put(authorityValue.getId(), authorityValue);
            }
            indexerInterface.close();
        }
        log.info((Object)"Cleaning the old index");
        System.out.println("Cleaning the old index");
        indexingService.cleanIndex();
        log.info((Object)"Writing new data");
        System.out.println("Writing new data");
        for (String id : toIndexValues.keySet()) {
            indexingService.indexContent((AuthorityValue)toIndexValues.get(id), true);
        }
        context.commit();
        indexingService.commit();
        context.abort();
        System.out.println("All done !");
        log.info((Object)"All done !");
    }

    public static void indexItem(Context context, Item item) {
        List indexers;
        ServiceManager serviceManager = AuthorityIndexClient.getServiceManager();
        AuthorityIndexingService indexingService = (AuthorityIndexingService)serviceManager.getServiceByName(AuthorityIndexingService.class.getName(), AuthorityIndexingService.class);
        if (!AuthorityIndexClient.isConfigurationValid(indexingService, indexers = serviceManager.getServicesByType(AuthorityIndexerInterface.class))) {
            return;
        }
        for (AuthorityIndexerInterface indexerInterface : indexers) {
            indexerInterface.init(context, item);
            while (indexerInterface.hasMore()) {
                AuthorityValue authorityValue = indexerInterface.nextValue();
                if (authorityValue == null) continue;
                indexingService.indexContent(authorityValue, true);
            }
            indexerInterface.close();
        }
        indexingService.commit();
    }

    private static ServiceManager getServiceManager() {
        DSpace dspace = new DSpace();
        return dspace.getServiceManager();
    }

    private static boolean isConfigurationValid(AuthorityIndexingService indexingService, List<AuthorityIndexerInterface> indexers) {
        if (!indexingService.isConfiguredProperly()) {
            return false;
        }
        for (AuthorityIndexerInterface indexerInterface : indexers) {
            if (indexerInterface.isConfiguredProperly()) continue;
            return false;
        }
        return true;
    }

    private static class ContextNoCaching
    extends Context {
        @Override
        public void cache(Object o, int id) {
        }
    }
}

