/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.AuthorityValueFinder;
import org.dspace.authority.AuthorityValueGenerator;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceAuthorityIndexer
implements AuthorityIndexerInterface,
InitializingBean {
    private static final Logger log = Logger.getLogger(DSpaceAuthorityIndexer.class);
    private ItemIterator itemIterator;
    private Item currentItem;
    private List<String> metadataFields;
    private int currentFieldIndex;
    private int currentMetadataIndex;
    private AuthorityValue nextValue;
    private Context context;
    private AuthorityValueFinder authorityValueFinder;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    public void afterPropertiesSet() throws Exception {
        String field;
        int counter = 1;
        this.metadataFields = new ArrayList<String>();
        while ((field = this.configurationService.getProperty("authority.author.indexer.field." + counter)) != null) {
            this.metadataFields.add(field);
            ++counter;
        }
    }

    @Override
    public void init(Context context, Item item) {
        ArrayList<Integer> itemList = new ArrayList<Integer>();
        itemList.add(item.getID());
        this.itemIterator = new ItemIterator(context, itemList);
        try {
            this.currentItem = this.itemIterator.next();
        }
        catch (SQLException e) {
            log.error((Object)"Error while retrieving an item in the metadata indexer");
        }
        this.initialize(context);
    }

    @Override
    public void init(Context context) {
        try {
            this.itemIterator = Item.findAll(context);
            this.currentItem = this.itemIterator.next();
        }
        catch (SQLException e) {
            log.error((Object)"Error while retrieving all items in the metadata indexer");
        }
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.context = context;
        this.authorityValueFinder = new AuthorityValueFinder();
        this.currentFieldIndex = 0;
        this.currentMetadataIndex = 0;
    }

    @Override
    public AuthorityValue nextValue() {
        return this.nextValue;
    }

    @Override
    public boolean hasMore() {
        if (this.currentItem == null) {
            return false;
        }
        String metadataField = this.metadataFields.get(this.currentFieldIndex);
        Metadatum[] values = this.currentItem.getMetadataByMetadataString(metadataField);
        if (this.currentMetadataIndex < values.length) {
            this.prepareNextValue(metadataField, values[this.currentMetadataIndex]);
            ++this.currentMetadataIndex;
            return true;
        }
        if (this.currentFieldIndex + 1 < this.metadataFields.size()) {
            ++this.currentFieldIndex;
            this.currentMetadataIndex = 0;
            return this.hasMore();
        }
        try {
            if (this.itemIterator.hasNext()) {
                this.currentItem = this.itemIterator.next();
                this.currentFieldIndex = 0;
                this.currentMetadataIndex = 0;
            } else {
                this.currentItem = null;
            }
            return this.hasMore();
        }
        catch (SQLException e) {
            this.currentItem = null;
            log.error((Object)"Error while retrieving next item in the author indexer", (Throwable)e);
            return false;
        }
    }

    private void prepareNextValue(String metadataField, Metadatum value) {
        boolean requiresItemUpdate;
        this.nextValue = null;
        String content = value.value;
        String uid = value.authority;
        boolean bl = requiresItemUpdate = StringUtils.isBlank((String)uid) || StringUtils.startsWith((String)uid, (String)"will be generated::");
        if (StringUtils.isNotBlank((String)uid) && !uid.startsWith("will be generated::")) {
            this.nextValue = this.authorityValueFinder.findByUID(this.context, uid);
        }
        if (this.nextValue == null) {
            this.nextValue = AuthorityValueGenerator.generate(uid, content, metadataField.replaceAll("\\.", "_"));
        }
        if (this.nextValue != null && requiresItemUpdate) {
            this.nextValue.updateItem(this.currentItem, value);
            try {
                this.currentItem.update();
            }
            catch (Exception e) {
                log.error((Object)"Error creating a metadatavalue's authority", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.itemIterator.close();
        this.itemIterator = null;
    }

    @Override
    public boolean isConfiguredProperly() {
        boolean isConfiguredProperly = true;
        if (CollectionUtils.isEmpty(this.metadataFields)) {
            log.warn((Object)"Authority indexer not properly configured, no metadata fields configured for indexing. Check the \"authority.author.indexer.field\" properties.");
            isConfiguredProperly = false;
        }
        return isConfiguredProperly;
    }
}

