/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.sort.OrderFormat;

public class ItemComparator
implements Comparator,
Serializable {
    private String element;
    private String qualifier;
    private String language;
    private boolean max;

    public ItemComparator(String element, String qualifier, String language, boolean max) {
        this.element = element;
        this.qualifier = qualifier;
        this.language = language;
        this.max = max;
    }

    public int compare(Object first, Object second) {
        if (!(first instanceof Item) || !(second instanceof Item)) {
            throw new IllegalArgumentException("Arguments must be Items");
        }
        String firstValue = this.getValue((Item)first);
        String secondValue = this.getValue((Item)second);
        if (firstValue == null && secondValue == null) {
            return 0;
        }
        if (firstValue == null) {
            return -1;
        }
        if (secondValue == null) {
            return 1;
        }
        return firstValue.compareTo(secondValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ItemComparator)) {
            return false;
        }
        ItemComparator other = (ItemComparator)obj;
        return this.equalsWithNull(this.element, other.element) && this.equalsWithNull(this.qualifier, other.qualifier) && this.equalsWithNull(this.language, other.language) && this.max == other.max;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.element).append((Object)this.qualifier).append((Object)this.language).append(this.max).toHashCode();
    }

    private boolean equalsWithNull(String first, String second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    private String getValue(Item item) {
        Metadatum[] dcvalues = item.getDC(this.element, this.qualifier, this.language);
        if (dcvalues.length == 0) {
            return null;
        }
        if (dcvalues.length == 1) {
            return this.normalizeTitle(dcvalues[0]);
        }
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (int i = 0; i < dcvalues.length; ++i) {
            String value = dcvalues[i].value;
            if (value == null) continue;
            values.put(value, i);
        }
        if (values.size() == 0) {
            return null;
        }
        Set valueSet = values.keySet();
        String chosen = this.max ? (String)Collections.max(valueSet) : (String)Collections.min(valueSet);
        int index = (Integer)values.get(chosen);
        return this.normalizeTitle(dcvalues[index]);
    }

    private String normalizeTitle(Metadatum value) {
        if (!"title".equals(this.element)) {
            return value.value;
        }
        return OrderFormat.makeSortString(value.value, value.language, "title");
    }
}

