/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.dspace.authority.AuthoritySearchService;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.rest.RestSource;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;

public class SolrAuthority
implements ChoiceAuthority {
    private static final Logger log = Logger.getLogger(SolrAuthority.class);
    private RestSource source = (RestSource)new DSpace().getServiceManager().getServiceByName("AuthoritySource", RestSource.class);
    private boolean externalResults = false;

    public Choices getMatches(String field, String text, int collection, int start, int limit, String locale, boolean bestMatch) {
        Choices result;
        if (limit == 0) {
            limit = 10;
        }
        SolrQuery queryArgs = new SolrQuery();
        if (text == null || text.trim().equals("")) {
            queryArgs.setQuery("*:*");
        } else {
            String searchField = "value";
            String localSearchField = "";
            try {
                Integer.parseInt(locale);
                locale = null;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (locale != null && !"".equals(locale)) {
                localSearchField = searchField + "_" + locale;
            }
            String query = "(" + this.toQuery(searchField, text) + ") ";
            if (!localSearchField.equals("")) {
                query = query + " or (" + this.toQuery(localSearchField, text) + ")";
            }
            queryArgs.setQuery(query);
        }
        queryArgs.addFilterQuery(new String[]{"field:" + field});
        queryArgs.set("start", start);
        int maxNumberOfSolrResults = limit + 1;
        if (this.externalResults) {
            maxNumberOfSolrResults = ConfigurationManager.getIntProperty("xmlui.lookup.select.size", 12);
        }
        queryArgs.set("rows", maxNumberOfSolrResults);
        String sortField = "value";
        String localSortField = "";
        if (StringUtils.isNotBlank((String)locale)) {
            localSortField = sortField + "_" + locale;
            queryArgs.setSortField(localSortField, SolrQuery.ORDER.asc);
        } else {
            queryArgs.setSortField(sortField, SolrQuery.ORDER.asc);
        }
        try {
            int max = 0;
            boolean hasMore = false;
            QueryResponse searchResponse = SolrAuthority.getSearchService().search(queryArgs);
            SolrDocumentList authDocs = searchResponse.getResults();
            ArrayList<Choice> choices = new ArrayList<Choice>();
            if (authDocs != null) {
                max = (int)searchResponse.getResults().getNumFound();
                int maxDocs = authDocs.size();
                if (limit < maxDocs) {
                    maxDocs = limit;
                }
                ArrayList<AuthorityValue> alreadyPresent = new ArrayList<AuthorityValue>();
                for (int i = 0; i < maxDocs; ++i) {
                    SolrDocument solrDocument = (SolrDocument)authDocs.get(i);
                    if (solrDocument == null) continue;
                    AuthorityValue val = AuthorityValue.fromSolr(solrDocument);
                    Map<String, String> extras = val.choiceSelectMap();
                    extras.put("insolr", val.getId());
                    choices.add(new Choice(val.getId(), val.getValue(), val.getValue(), extras));
                    alreadyPresent.add(val);
                }
                if (this.externalResults && StringUtils.isNotBlank((String)text)) {
                    int sizeFromSolr = alreadyPresent.size();
                    int maxExternalResults = limit <= 10 ? Math.max(limit - sizeFromSolr, 2) : Math.max(limit - 10 - sizeFromSolr, 2) + limit - 10;
                    this.addExternalResults(text, choices, alreadyPresent, maxExternalResults);
                }
                hasMore = true;
            }
            int confidence = choices.size() == 0 ? 300 : (choices.size() == 1 ? 500 : 400);
            result = new Choices(choices.toArray(new Choice[choices.size()]), start, hasMore ? max : choices.size() + start, confidence, hasMore);
        }
        catch (Exception e) {
            log.error((Object)("Error while retrieving authority values {field: " + field + ", prefix:" + text + "}"), (Throwable)e);
            result = new Choices(true);
        }
        return result;
    }

    protected void addExternalResults(String text, ArrayList<Choice> choices, List<AuthorityValue> alreadyPresent, int max) {
        if (this.source != null) {
            try {
                List<AuthorityValue> values = this.source.queryAuthorities(text, max * 2);
                Iterator<AuthorityValue> iterator = values.iterator();
                while (iterator.hasNext()) {
                    AuthorityValue next = iterator.next();
                    if (!alreadyPresent.contains(next)) continue;
                    iterator.remove();
                }
                iterator = values.iterator();
                for (int added = 0; iterator.hasNext() && added < max; ++added) {
                    AuthorityValue val = iterator.next();
                    Map<String, String> extras = val.choiceSelectMap();
                    extras.put("insolr", "false");
                    choices.add(new Choice(val.generateString(), val.getValue(), val.getValue(), extras));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error", (Throwable)e);
            }
            this.externalResults = false;
        } else {
            log.warn((Object)"external source for authority not configured");
        }
    }

    private String toQuery(String searchField, String text) {
        return searchField + ":\"" + text.toLowerCase().replaceAll(":", "\\:") + "*\" or " + searchField + ":\"" + text.toLowerCase().replaceAll(":", "\\:") + "\"";
    }

    @Override
    public Choices getMatches(String field, String text, int collection, int start, int limit, String locale) {
        return this.getMatches(field, text, collection, start, limit, locale, true);
    }

    @Override
    public Choices getBestMatch(String field, String text, int collection, String locale) {
        Choices matches = this.getMatches(field, text, collection, 0, 1, locale, false);
        if (matches.values.length != 0 && !matches.values[0].value.equalsIgnoreCase(text)) {
            matches = new Choices(false);
        }
        return matches;
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        block15: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("requesting label for key " + key + " using locale " + locale));
                }
                SolrQuery queryArgs = new SolrQuery();
                queryArgs.setQuery("id:" + key);
                queryArgs.setRows(Integer.valueOf(1));
                QueryResponse searchResponse = SolrAuthority.getSearchService().search(queryArgs);
                SolrDocumentList docs = searchResponse.getResults();
                if (docs.getNumFound() != 1L) break block15;
                String label = null;
                try {
                    label = (String)((SolrDocument)docs.get(0)).getFieldValue("value_" + locale);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (label != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returning label " + label + " for key " + key + " using locale " + locale + " and fieldvalue " + "value_" + locale));
                    }
                    return label;
                }
                try {
                    label = (String)((SolrDocument)docs.get(0)).getFieldValue("value");
                }
                catch (Exception e) {
                    log.error((Object)("couldn't get field value for key " + key), (Throwable)e);
                }
                if (label != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returning label " + label + " for key " + key + " using locale " + locale + " and fieldvalue " + "value"));
                    }
                    return label;
                }
                try {
                    label = (String)((SolrDocument)docs.get(0)).getFieldValue("value_en");
                }
                catch (Exception e) {
                    log.error((Object)("couldn't get field value for key " + key), (Throwable)e);
                }
                if (label != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returning label " + label + " for key " + key + " using locale " + locale + " and fieldvalue " + "value_en"));
                    }
                    return label;
                }
            }
            catch (Exception e) {
                log.error((Object)("error occurred while trying to get label for key " + key), (Throwable)e);
            }
        }
        return key;
    }

    public static AuthoritySearchService getSearchService() {
        DSpace dspace = new DSpace();
        ServiceManager manager = dspace.getServiceManager();
        return (AuthoritySearchService)manager.getServiceByName(AuthoritySearchService.class.getName(), AuthoritySearchService.class);
    }

    public void addExternalResultsInNextMatches() {
        this.externalResults = true;
    }
}

