/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class IdentifierProvider {
    protected IdentifierService parentService;
    protected ConfigurationService configurationService;

    @Autowired
    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setParentService(IdentifierService parentService) {
        this.parentService = parentService;
    }

    public abstract boolean supports(Class<? extends Identifier> var1);

    public abstract boolean supports(String var1);

    public abstract String register(Context var1, DSpaceObject var2) throws IdentifierException;

    public abstract String mint(Context var1, DSpaceObject var2) throws IdentifierException;

    public abstract DSpaceObject resolve(Context var1, String var2, String ... var3) throws IdentifierNotFoundException, IdentifierNotResolvableException;

    public abstract String lookup(Context var1, DSpaceObject var2) throws IdentifierNotFoundException, IdentifierNotResolvableException;

    public abstract void delete(Context var1, DSpaceObject var2) throws IdentifierException;

    public abstract void delete(Context var1, DSpaceObject var2, String var3) throws IdentifierException;

    public abstract void reserve(Context var1, DSpaceObject var2, String var3) throws IdentifierException;

    public abstract void register(Context var1, DSpaceObject var2, String var3) throws IdentifierException;
}

