/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.util;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EnumUtils {
    private static Logger log = Logger.getLogger(EnumUtils.class);

    private static String getEnumName(String value) {
        return StringUtils.isNotBlank((String)value) ? value.toUpperCase().trim().replaceAll("[^a-zA-Z]", "_") : null;
    }

    public static <E extends Enum<E>> E lookup(Class<E> enumClass, String enumName) {
        try {
            return Enum.valueOf(enumClass, EnumUtils.getEnumName(enumName));
        }
        catch (Exception ex) {
            log.warn((Object)("Did not find an " + enumClass.getSimpleName() + " for value '" + enumName + "'"));
            return null;
        }
    }
}

