/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class ItemCountDAOOracle
implements ItemCountDAO {
    private static Logger log = Logger.getLogger(ItemCountDAOOracle.class);
    private Context context;
    private String collectionSelect = "SELECT * FROM collection_item_count WHERE collection_id = ?";
    private String collectionInsert = "INSERT INTO collection_item_count (collection_id, count) VALUES (?, ?)";
    private String collectionUpdate = "UPDATE collection_item_count SET count = ? WHERE collection_id = ?";
    private String collectionRemove = "DELETE FROM collection_item_count WHERE collection_id = ?";
    private String communitySelect = "SELECT * FROM community_item_count WHERE community_id = ?";
    private String communityInsert = "INSERT INTO community_item_count (community_id, count) VALUES (?, ?)";
    private String communityUpdate = "UPDATE community_item_count SET count = ? WHERE community_id = ?";
    private String communityRemove = "DELETE FROM community_item_count WHERE community_id = ?";

    @Override
    public void collectionCount(Collection collection, int count) throws ItemCountException {
        try (TableRowIterator tri = null;){
            Object[] sparams = new Object[]{collection.getID()};
            tri = DatabaseManager.query(this.context, this.collectionSelect, sparams);
            if (tri.hasNext()) {
                Object[] params = new Object[]{count, collection.getID()};
                DatabaseManager.updateQuery(this.context, this.collectionUpdate, params);
            } else {
                Object[] params = new Object[]{collection.getID(), count};
                DatabaseManager.updateQuery(this.context, this.collectionInsert, params);
            }
        }
    }

    @Override
    public void communityCount(Community community, int count) throws ItemCountException {
        try (TableRowIterator tri = null;){
            Object[] sparams = new Object[]{community.getID()};
            tri = DatabaseManager.query(this.context, this.communitySelect, sparams);
            if (tri.hasNext()) {
                Object[] params = new Object[]{count, community.getID()};
                DatabaseManager.updateQuery(this.context, this.communityUpdate, params);
            } else {
                Object[] params = new Object[]{community.getID(), count};
                DatabaseManager.updateQuery(this.context, this.communityInsert, params);
            }
        }
    }

    @Override
    public void setContext(Context context) throws ItemCountException {
        this.context = context;
    }

    @Override
    public int getCount(DSpaceObject dso) throws ItemCountException {
        if (dso instanceof Collection) {
            return this.getCollectionCount((Collection)dso);
        }
        if (dso instanceof Community) {
            return this.getCommunityCount((Community)dso);
        }
        throw new ItemCountException("We can only count items in Communities or Collections");
    }

    @Override
    public void remove(DSpaceObject dso) throws ItemCountException {
        if (dso instanceof Collection) {
            this.removeCollection((Collection)dso);
        } else if (dso instanceof Community) {
            this.removeCommunity((Community)dso);
        } else {
            throw new ItemCountException("We can only delete count of items from Communities or Collections");
        }
    }

    private void removeCollection(Collection collection) throws ItemCountException {
        try {
            Object[] params = new Object[]{collection.getID()};
            DatabaseManager.updateQuery(this.context, this.collectionRemove, params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }

    private void removeCommunity(Community community) throws ItemCountException {
        try {
            Object[] params = new Object[]{community.getID()};
            DatabaseManager.updateQuery(this.context, this.communityRemove, params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }

    private int getCollectionCount(Collection collection) throws ItemCountException {
        try (TableRowIterator tri = null;){
            Object[] params = new Object[]{collection.getID()};
            tri = DatabaseManager.query(this.context, this.collectionSelect, params);
            if (!tri.hasNext()) {
                int n = 0;
                return n;
            }
            TableRow tr = tri.next();
            if (tri.hasNext()) {
                throw new ItemCountException("More than one count row in the database");
            }
            int n = tr.getIntColumn("count");
            return n;
        }
    }

    private int getCommunityCount(Community community) throws ItemCountException {
        try (TableRowIterator tri = null;){
            Object[] params = new Object[]{community.getID()};
            tri = DatabaseManager.query(this.context, this.communitySelect, params);
            if (!tri.hasNext()) {
                int n = 0;
                return n;
            }
            TableRow tr = tri.next();
            if (tri.hasNext()) {
                throw new ItemCountException("More than one count row in the database");
            }
            int n = tr.getIntColumn("count");
            return n;
        }
    }
}

