/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Distributive;

@Distributive
public abstract class AbstractTranslator
extends AbstractCurationTask {
    int status = -2;
    private static final String PLUGIN_PREFIX = "translator";
    private static String authLangField = "dc.language";
    private static String authLang = "en";
    private static String[] toTranslate;
    private static String[] langs;
    private static String apiKey;
    private static Logger log;
    private List<String> results = new ArrayList<String>();

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        authLang = ConfigurationManager.getProperty("default.locale");
        authLangField = ConfigurationManager.getProperty(PLUGIN_PREFIX, "translate.field.language");
        String toTranslateStr = ConfigurationManager.getProperty(PLUGIN_PREFIX, "translate.field.targets");
        String langsStr = ConfigurationManager.getProperty(PLUGIN_PREFIX, "translate.language.targets");
        toTranslate = toTranslateStr.split(",");
        langs = langsStr.split(",");
        if (toTranslate.length <= 0 || langs.length <= 0) {
            this.status = -1;
            this.results.add("Configuration error");
            this.setResult(this.results.toString());
            this.report(this.results.toString());
            return;
        }
        this.initApi();
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        if (dso instanceof Item) {
            Item item = (Item)dso;
            this.status = 0;
            String handle = item.getHandle();
            log.debug((Object)("Translating metadata for " + handle));
            Metadatum[] authLangs = item.getMetadataByMetadataString(authLangField);
            if (authLangs.length > 0) {
                authLang = authLangs[0].value;
                log.debug((Object)("Authoritative language for " + handle + " is " + authLang));
            }
            for (String lang : langs) {
                lang = lang.trim();
                for (String field : toTranslate) {
                    Metadatum[] checkMetadata;
                    boolean translated = false;
                    field = field.trim();
                    String[] fieldSegments = field.split("\\.");
                    Metadatum[] fieldMetadata = null;
                    if (fieldSegments.length > 2) {
                        checkMetadata = item.getMetadata(fieldSegments[0], fieldSegments[1], fieldSegments[2], lang);
                        if (checkMetadata.length > 0) {
                            log.debug((Object)(handle + "already has " + field + " in " + lang + ", skipping"));
                            this.results.add(handle + ": Skipping " + lang + " translation " + "(" + field + ")");
                            translated = true;
                        }
                        fieldMetadata = item.getMetadata(fieldSegments[0], fieldSegments[1], fieldSegments[2], authLang);
                    } else {
                        checkMetadata = item.getMetadata(fieldSegments[0], fieldSegments[1], null, lang);
                        if (checkMetadata.length > 0) {
                            log.debug((Object)(handle + "already has " + field + " in " + lang + ", skipping"));
                            this.results.add(handle + ": Skipping " + lang + " translation " + "(" + field + ")");
                            translated = true;
                        }
                        fieldMetadata = item.getMetadata(fieldSegments[0], fieldSegments[1], null, authLang);
                    }
                    if (translated || fieldMetadata.length <= 0) continue;
                    for (Metadatum metadataValue : fieldMetadata) {
                        String value = metadataValue.value;
                        String translatedText = this.translateText(authLang, lang, value);
                        if (translatedText != null && !"".equals(translatedText)) {
                            if (fieldSegments.length > 2) {
                                item.addMetadata(fieldSegments[0], fieldSegments[1], fieldSegments[2], lang, translatedText);
                            } else {
                                item.addMetadata(fieldSegments[0], fieldSegments[1], null, lang, translatedText);
                            }
                            try {
                                item.update();
                                this.results.add(handle + ": Translated " + authLang + " -> " + lang + " (" + field + ")");
                            }
                            catch (Exception e) {
                                log.info((Object)e.getLocalizedMessage());
                                this.status = -1;
                            }
                            continue;
                        }
                        this.results.add(handle + ": Failed translation of " + authLang + " -> " + lang + "(" + field + ")");
                    }
                }
            }
        }
        this.processResults();
        return this.status;
    }

    protected void initApi() {
    }

    protected String translateText(String from, String to, String text) throws IOException {
        return null;
    }

    private void processResults() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Translation report: \n----------------\n");
        for (String result : this.results) {
            sb.append(result).append("\n");
        }
        this.setResult(sb.toString());
        this.report(sb.toString());
    }

    static {
        apiKey = "";
        log = Logger.getLogger(AbstractTranslator.class);
    }
}

