/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.AbstractModifier;
import gr.ekt.bte.core.MutableRecord;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dspace.services.ConfigurationService;

public class MapConverterModifier
extends AbstractModifier {
    private String mappingFile;
    private String converterNameFile;
    private ConfigurationService configurationService;
    private Map<String, String> mapping;
    private String defaultValue = "";
    private List<String> fieldKeys;
    private Map<String, String> regexConfig = new HashMap<String, String>();
    public final String REGEX_PREFIX = "regex.";

    public void init() {
        this.mappingFile = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator + this.converterNameFile;
        this.mapping = new HashMap<String, String>();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(this.mappingFile));
            Properties mapConfig = new Properties();
            mapConfig.load(fis);
            fis.close();
            for (Object key : mapConfig.keySet()) {
                String keyS = (String)key;
                if (keyS.startsWith("regex.")) {
                    String regex = keyS.substring("regex.".length());
                    String regReplace = this.mapping.get(keyS);
                    if (regReplace == null) {
                        regReplace = "";
                    } else if (regReplace.equalsIgnoreCase("@ident@")) {
                        regReplace = "$0";
                    }
                    this.regexConfig.put(regex, regReplace);
                }
                if (mapConfig.getProperty(keyS) != null) {
                    this.mapping.put(keyS, mapConfig.getProperty(keyS));
                    continue;
                }
                this.mapping.put(keyS, "");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (String keyS : this.mapping.keySet()) {
            if (!keyS.startsWith("regex.")) continue;
            String regex = keyS.substring("regex.".length());
            String regReplace = this.mapping.get(keyS);
            if (regReplace == null) {
                regReplace = "";
            } else if (regReplace.equalsIgnoreCase("@ident@")) {
                regReplace = "$0";
            }
            this.regexConfig.put(regex, regReplace);
        }
    }

    public MapConverterModifier(String name) {
        super(name);
    }

    public Record modify(MutableRecord record) {
        if (this.mapping != null && this.fieldKeys != null) {
            for (String key : this.fieldKeys) {
                List values = record.getValues(key);
                if (values == null) continue;
                ArrayList<StringValue> newValues = new ArrayList<StringValue>();
                for (Value value : values) {
                    String stringValue = value.getAsString();
                    String tmp = "";
                    if (this.mapping.containsKey(stringValue)) {
                        tmp = this.mapping.get(stringValue);
                    } else {
                        tmp = this.defaultValue;
                        for (String regex : this.regexConfig.keySet()) {
                            if (stringValue == null || !stringValue.matches(regex)) continue;
                            tmp = stringValue.replaceAll(regex, this.regexConfig.get(regex));
                        }
                    }
                    if ("@@ident@@".equals(tmp)) {
                        newValues.add(new StringValue(stringValue));
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)tmp)) {
                        newValues.add(new StringValue(tmp));
                        continue;
                    }
                    newValues.add(new StringValue(stringValue));
                }
                record.updateField(key, newValues);
            }
        }
        return record;
    }

    public void setFieldKeys(List<String> fieldKeys) {
        this.fieldKeys = fieldKeys;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setConverterNameFile(String converterNameFile) {
        this.converterNameFile = converterNameFile;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

