/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;
import org.dspace.submit.lookup.PubmedService;

public class PubmedOnlineDataLoader
extends NetworkSubmissionLookupDataLoader {
    private boolean searchProvider = true;
    private static final Logger log = Logger.getLogger(PubmedOnlineDataLoader.class);
    private PubmedService pubmedService = new PubmedService();

    public void setPubmedService(PubmedService pubmedService) {
        this.pubmedService = pubmedService;
    }

    @Override
    public List<String> getSupportedIdentifiers() {
        return Arrays.asList("pubmed", "doi");
    }

    public void setSearchProvider(boolean searchProvider) {
        this.searchProvider = searchProvider;
    }

    @Override
    public boolean isSearchProvider() {
        return this.searchProvider;
    }

    @Override
    public List<Record> getByIdentifier(Context context, Map<String, Set<String>> keys) throws HttpException, IOException {
        ArrayList<Record> results;
        block8: {
            List<Record> pubmedResults;
            Set<String> dois;
            Set<String> pmids;
            block9: {
                block7: {
                    pmids = keys != null ? keys.get("pubmed") : null;
                    dois = keys != null ? keys.get("doi") : null;
                    results = new ArrayList<Record>();
                    if (pmids == null || pmids.size() <= 0 || dois != null && dois.size() != 0) break block7;
                    for (String pmid : pmids) {
                        Record p = null;
                        try {
                            p = this.pubmedService.getByPubmedID(pmid);
                        }
                        catch (Exception e) {
                            log.error((Object)LogManager.getHeader(context, "getByIdentifier", "pmid=" + pmid), (Throwable)e);
                        }
                        if (p == null) continue;
                        results.add(this.convertFields(p));
                    }
                    break block8;
                }
                if (dois == null || dois.size() <= 0 || pmids != null && pmids.size() != 0) break block9;
                StringBuffer query = new StringBuffer();
                for (String d : dois) {
                    if (query.length() > 0) {
                        query.append(" OR ");
                    }
                    query.append(d).append("[AI]");
                }
                List<Record> pubmedResults2 = this.pubmedService.search(query.toString());
                for (Record p : pubmedResults2) {
                    results.add(this.convertFields(p));
                }
                break block8;
            }
            if (dois == null || dois.size() <= 0 || pmids == null || pmids.size() <= 0 || (pubmedResults = this.pubmedService.search(dois.iterator().next(), pmids.iterator().next())) == null) break block8;
            for (Record p : pubmedResults) {
                results.add(this.convertFields(p));
            }
        }
        return results;
    }

    @Override
    public List<Record> search(Context context, String title, String author, int year) throws HttpException, IOException {
        List<Record> pubmedResults = this.pubmedService.search(title, author, year);
        ArrayList<Record> results = new ArrayList<Record>();
        if (pubmedResults != null) {
            for (Record p : pubmedResults) {
                results.add(this.convertFields(p));
            }
        }
        return results;
    }
}

