/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.handle.HandleManager;
import org.dspace.submit.step.AccessStep;
import org.dspace.submit.step.UploadStep;

public class UploadWithEmbargoStep
extends UploadStep {
    public static final int STATUS_EDIT_POLICIES = 30;
    public static final int STATUS_EDIT_POLICIES_ERROR_SELECT_GROUP = 31;
    public static final int STATUS_EDIT_POLICIES_DUPLICATED_POLICY = 32;
    public static final int STATUS_EDIT_POLICY_ERROR_SELECT_GROUP = 33;
    public static final int STATUS_EDIT_POLICY_DUPLICATED_POLICY = 34;
    private static Logger log = Logger.getLogger(UploadWithEmbargoStep.class);

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        Bundle[] bundles;
        int status;
        int status2;
        int status3;
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Item item = subInfo.getSubmissionItem().getItem();
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1 && (status3 = this.processUploadFile(context, request, response, subInfo)) != 0) {
            return status3;
        }
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.startsWith("submit_prev")) {
            if (this.fileRequired && !item.hasUploadedFiles()) {
                return 5;
            }
            return 0;
        }
        int result = this.editBitstreamPolicies(request, context, subInfo, buttonPressed);
        if (result != -1) {
            return result;
        }
        if (request.getParameter("bitstream_id") != null) {
            if (buttonPressed.equals("submit_edit_cancel")) {
                subInfo.setBitstream(null);
                return 25;
            }
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
        } else if (buttonPressed.startsWith("submit_edit_")) {
            String bitstreamID = buttonPressed.substring("submit_edit_".length());
            Bitstream b = Bitstream.find(context, Integer.parseInt(bitstreamID));
            subInfo.setBitstream(b);
            return 20;
        }
        if (buttonPressed.equalsIgnoreCase("submit_remove_selected")) {
            if (request.getParameter("remove") != null) {
                String[] removeIDs = request.getParameterValues("remove");
                for (int i = 0; i < removeIDs.length; ++i) {
                    int id = Integer.parseInt(removeIDs[i]);
                    status2 = this.processRemoveFile(context, item, id);
                    if (status2 == 0) continue;
                    return status2;
                }
                subInfo.setBitstream(null);
            }
        } else if (buttonPressed.startsWith("submit_remove_")) {
            int id = Integer.parseInt(buttonPressed.substring(14));
            int status4 = this.processRemoveFile(context, item, id);
            if (status4 != 0) {
                return status4;
            }
            subInfo.setBitstream(null);
        }
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (!StringUtils.startsWithIgnoreCase((String)name, (String)"description[")) continue;
            descriptions.put(name.substring("description[".length(), name.length() - 1), request.getParameter(name));
        }
        if (!descriptions.isEmpty()) {
            if (item != null) {
                Bundle[] bundles2;
                for (Bundle bundle : bundles2 = item.getBundles("ORIGINAL")) {
                    Bitstream[] bitstreams;
                    for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                        if (!descriptions.containsKey(bitstream.getName())) continue;
                        bitstream.setDescription((String)descriptions.get(bitstream.getName()));
                        bitstream.update();
                    }
                }
            }
            return 0;
        }
        String fileDescription = request.getParameter("description");
        if (fileDescription != null && fileDescription.length() > 0 && (status2 = this.processSaveFileDescription(context, request, response, subInfo)) != 0) {
            return status2;
        }
        int formatTypeID = Util.getIntParameter(request, "format");
        String formatDesc = request.getParameter("format_description");
        if ((formatTypeID >= 0 || formatDesc != null && formatDesc.length() > 0) && (status = this.processSaveFileFormat(context, request, response, subInfo)) != 0) {
            return status;
        }
        if (buttonPressed.equals("submit_save")) {
            this.processAccessFields(context, request, subInfo, subInfo.getBitstream());
        }
        if (request.getParameter("primary_bitstream_id") != null && (bundles = item.getBundles("ORIGINAL")).length > 0) {
            bundles[0].setPrimaryBitstreamID(Integer.valueOf(request.getParameter("primary_bitstream_id")));
            bundles[0].update();
        }
        if (this.fileRequired && !item.hasUploadedFiles()) {
            return 5;
        }
        return 0;
    }

    @Override
    public int processUploadFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean formatKnown = true;
        boolean fileOK = false;
        BitstreamFormat bf = null;
        Bitstream b = null;
        Enumeration attNames = request.getAttributeNames();
        while (attNames.hasMoreElements()) {
            String attr = (String)attNames.nextElement();
            if (!attr.endsWith("-path")) continue;
            String param = attr.replace("-path", "");
            String filePath = (String)request.getAttribute(param + "-path");
            InputStream fileInputStream = (InputStream)request.getAttribute(param + "-inputstream");
            String fileDescription = (String)request.getAttribute(param + "-description");
            if (fileDescription == null || fileDescription.length() == 0) {
                fileDescription = request.getParameter("description");
            }
            if (filePath == null || fileInputStream == null) {
                return 2;
            }
            if (subInfo == null) {
                return 1;
            }
            Item item = subInfo.getSubmissionItem().getItem();
            Bundle[] bundles = item.getBundles("ORIGINAL");
            b = bundles.length < 1 ? item.createSingleBitstream(fileInputStream, "ORIGINAL") : bundles[0].createBitstream(fileInputStream);
            String noPath = filePath;
            while (noPath.indexOf(47) > -1) {
                noPath = noPath.substring(noPath.indexOf(47) + 1);
            }
            while (noPath.indexOf(92) > -1) {
                noPath = noPath.substring(noPath.indexOf(92) + 1);
            }
            b.setName(noPath);
            b.setSource(filePath);
            b.setDescription(fileDescription);
            bf = FormatIdentifier.guessFormat(context, b);
            b.setFormat(bf);
            b.update();
            item.update();
            this.processAccessFields(context, request, subInfo, b);
            context.commit();
            if (bf != null && bf.isInternal()) {
                log.warn((Object)"Attempt to upload file format marked as internal system use only");
                this.backoutBitstream(subInfo, b, item);
                return 2;
            }
            if (ConfigurationManager.getBooleanProperty("submission-curation", "virus-scan")) {
                Curator curator = new Curator();
                curator.addTask("vscan").curate(item);
                int status = curator.getStatus("vscan");
                if (status == -1) {
                    this.backoutBitstream(subInfo, b, item);
                    return 14;
                }
                if (status == 1) {
                    this.backoutBitstream(subInfo, b, item);
                    return 16;
                }
            }
            context.commit();
            subInfo.setBitstream(b);
            if (bf != null) continue;
            return 10;
        }
        return 0;
    }

    private void processAccessFields(Context context, HttpServletRequest request, SubmissionInfo subInfo, Bitstream b) throws SQLException, AuthorizeException {
        boolean isAdvancedFormEnabled = ConfigurationManager.getBooleanProperty("webui.submission.restrictstep.enableAdvancedForm", false);
        if (!isAdvancedFormEnabled) {
            Date startDate = null;
            try {
                startDate = DateUtils.parseDate((String)request.getParameter("embargo_until_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            String reason = request.getParameter("reason");
            AuthorizeManager.generateAutomaticPolicies(context, startDate, reason, b, (Collection)HandleManager.resolveToObject(context, subInfo.getCollectionHandle()));
        }
    }

    private int editBitstreamPolicies(HttpServletRequest request, Context context, SubmissionInfo subInfo, String buttonPressed) throws SQLException, AuthorizeException {
        if (buttonPressed.equals("bitstream_list_submit_return")) {
            return 0;
        }
        if (buttonPressed.startsWith("submit_editPolicy_")) {
            String bitstreamID = buttonPressed.substring("submit_editPolicy_".length());
            Bitstream b = Bitstream.find(context, Integer.parseInt(bitstreamID));
            subInfo.setBitstream(b);
            return 30;
        }
        if (buttonPressed.startsWith("submit_add_policy")) {
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
            int result = -1;
            result = AccessStep.checkForm(request);
            if (result != 0) {
                return result;
            }
            Date dateStartDate = AccessStep.getEmbargoUntil(request);
            String reason = request.getParameter("reason");
            String name = request.getParameter("name");
            int groupID = 0;
            if (request.getParameter("group_id") != null) {
                try {
                    groupID = Integer.parseInt(request.getParameter("group_id"));
                }
                catch (NumberFormatException nfe) {
                    return 31;
                }
            }
            ResourcePolicy rp = null;
            rp = AuthorizeManager.createOrModifyPolicy(null, context, name, groupID, null, dateStartDate, 0, reason, b);
            if (rp == null) {
                return 32;
            }
            rp.update();
            context.commit();
            return 30;
        }
        if (AccessStep.wasEditPolicyPressed(context, buttonPressed, subInfo)) {
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
            return 10;
        }
        if (AccessStep.comeFromEditPolicy(request)) {
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
            String reason = request.getParameter("reason");
            String name = request.getParameter("name");
            int groupID = 0;
            if (request.getParameter("group_id") != null) {
                try {
                    groupID = Integer.parseInt(request.getParameter("group_id"));
                }
                catch (NumberFormatException nfe) {
                    return 31;
                }
            }
            if (AccessStep.saveOrCancelEditPolicy(context, request, subInfo, buttonPressed, b, name, groupID, reason) == 5) {
                return 34;
            }
            return 30;
        }
        if (AccessStep.wasRemovePolicyPressed(buttonPressed)) {
            Bitstream b = Bitstream.find(context, Integer.parseInt(request.getParameter("bitstream_id")));
            subInfo.setBitstream(b);
            AccessStep.removePolicy(context, buttonPressed);
            context.commit();
            return 30;
        }
        return -1;
    }
}

