/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.util.StopWatch;

public class OptimizeSelectCollection {
    private static final Logger log = Logger.getLogger(OptimizeSelectCollection.class);
    private static Context context;
    private static ArrayList<EPerson> brokenPeople;
    private static Long timeSavedMS;

    public static void main(String[] argv) throws Exception {
        System.out.println("OptimizeSelectCollection tool.");
        System.out.println("We want to verify that the optimized version of select collection logic produces the same values as the legacy select-collection logic.");
        context = new Context();
        brokenPeople = new ArrayList();
        int peopleChecked = 0;
        timeSavedMS = 0L;
        if (argv != null && argv.length > 0) {
            for (String email : argv) {
                EPerson person = EPerson.findByEmail(context, email);
                OptimizeSelectCollection.checkSelectCollectionForUser(person);
                ++peopleChecked;
            }
        } else {
            EPerson[] people;
            for (EPerson person : people = EPerson.findAll(context, 1)) {
                OptimizeSelectCollection.checkSelectCollectionForUser(person);
                ++peopleChecked;
            }
        }
        if (brokenPeople.size() > 0) {
            System.out.println("NOT DONE YET!!! Some people don't have all their collections.");
            for (EPerson person : brokenPeople) {
                System.out.println("-- " + person.getEmail());
            }
        } else {
            System.out.println("All Good: " + peopleChecked + " people have been checked, with same submission powers. TimeSaved(ms): " + timeSavedMS);
        }
    }

    private static void checkSelectCollectionForUser(EPerson person) throws SQLException {
        context.setCurrentUser(person);
        StopWatch stopWatch = new StopWatch("SelectCollectionStep Optimization (" + person.getEmail() + ")");
        System.out.println("User: " + person.getEmail());
        stopWatch.start("findAuthorized");
        Collection[] collections = Collection.findAuthorized(context, null, 3);
        stopWatch.stop();
        Long defaultMS = stopWatch.getLastTaskTimeMillis();
        stopWatch.start("ListingCollections");
        System.out.println("Legacy Find Authorized");
        OptimizeSelectCollection.reportCollections(collections);
        stopWatch.stop();
        stopWatch.start("findAuthorizedOptimized");
        Collection[] collectionsOptimized = Collection.findAuthorizedOptimized(context, 3);
        stopWatch.stop();
        Long optimizedMS = stopWatch.getLastTaskTimeMillis();
        timeSavedMS = timeSavedMS + (defaultMS - optimizedMS);
        stopWatch.start("ListingCollectionsWithOptimizedCollections");
        System.out.println("Find Authorized Optimized");
        OptimizeSelectCollection.reportCollections(collectionsOptimized);
        stopWatch.stop();
        if (collections.length == collectionsOptimized.length) {
            System.out.println("Number of collections matches - Good");
        } else {
            System.out.println("Number of collections doesn't match -- Bad");
            brokenPeople.add(person);
        }
        System.out.println(stopWatch.prettyPrint());
    }

    private static void reportCollections(Collection[] collections) {
        System.out.println("====================================");
        System.out.println("This user is permitted to submit to the following collections.");
        for (Collection collection : collections) {
            System.out.println(" - " + collection.getHandle() + " -- " + collection.getName());
        }
        System.out.println("Total: " + collections.length);
    }

    static {
        timeSavedMS = 0L;
    }
}

