/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.AuthorityValueFinder;
import org.dspace.core.Context;

public class AuthorityValueGenerator {
    public static final String SPLIT = "::";
    public static final String GENERATE = "will be generated::";

    public static AuthorityValue generate(Context context, String authorityKey, String content, String field) {
        AuthorityValue nextValue = null;
        nextValue = AuthorityValueGenerator.generateRaw(authorityKey, content, field);
        if (nextValue != null) {
            if (StringUtils.isBlank((String)authorityKey)) {
                AuthorityValueFinder authorityValueFinder = new AuthorityValueFinder();
                List<AuthorityValue> byValue = authorityValueFinder.findByExactValue(context, field, content);
                authorityKey = byValue != null && !byValue.isEmpty() ? byValue.get(0).getId() : UUID.randomUUID().toString();
            } else if (StringUtils.startsWith((String)authorityKey, (String)GENERATE)) {
                authorityKey = UUID.randomUUID().toString();
            }
            nextValue.setId(authorityKey);
            nextValue.updateLastModifiedDate();
            nextValue.setCreationDate(new Date());
            nextValue.setField(field);
        }
        return nextValue;
    }

    protected static AuthorityValue generateRaw(String authorityKey, String content, String field) {
        AuthorityValue nextValue;
        if (authorityKey != null && authorityKey.startsWith(GENERATE)) {
            String[] split = StringUtils.split((String)authorityKey, (String)SPLIT);
            String type = null;
            String info = null;
            if (split.length > 0) {
                type = split[1];
                if (split.length > 1) {
                    info = split[2];
                }
            }
            AuthorityValue authorityType = AuthorityValue.getAuthorityTypes().getEmptyAuthorityValue(type);
            nextValue = authorityType.newInstance(info);
        } else {
            Map<String, AuthorityValue> fieldDefaults = AuthorityValue.getAuthorityTypes().getFieldDefaults();
            nextValue = fieldDefaults.get(field).newInstance(null);
            if (nextValue == null) {
                nextValue = new AuthorityValue();
            }
            nextValue.setValue(content);
        }
        return nextValue;
    }

    public static AuthorityValue update(AuthorityValue value) {
        AuthorityValue updated = AuthorityValueGenerator.generateRaw(value.generateString(), value.getValue(), value.getField());
        if (updated != null) {
            updated.setId(value.getId());
            updated.setCreationDate(value.getCreationDate());
            updated.setField(value.getField());
            if (updated.hasTheSameInformationAs(value)) {
                updated.setLastModified(value.getLastModified());
            } else {
                updated.updateLastModifiedDate();
            }
        }
        return updated;
    }
}

