/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.Thumbnail;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class BrowseItem
extends DSpaceObject {
    private static Logger log = Logger.getLogger(BrowseItem.class);
    private List<Metadatum> metadata = new ArrayList<Metadatum>();
    private int id = -1;
    private boolean in_archive = true;
    private boolean withdrawn = false;
    private boolean discoverable = true;
    private String handle = null;

    public BrowseItem(Context context, int id, boolean in_archive, boolean withdrawn, boolean discoverable) {
        super(context);
        this.id = id;
        this.in_archive = in_archive;
        this.withdrawn = withdrawn;
        this.discoverable = discoverable;
    }

    @Override
    public Metadatum[] getMetadata(String schema, String element, String qualifier, String lang) {
        try {
            BrowseItemDAO dao = BrowseDAOFactory.getItemInstance(this.ourContext);
            if ("*".equals(qualifier)) {
                try {
                    return dao.queryMetadata(this.id, schema, element, qualifier, lang);
                }
                catch (SQLException e) {
                    log.error((Object)"caught exception: ", (Throwable)e);
                }
            }
            if (!this.metadata.isEmpty()) {
                ArrayList<Metadatum> values = new ArrayList<Metadatum>();
                for (Metadatum dcv : this.metadata) {
                    if (!this.match(schema, element, qualifier, lang, dcv)) continue;
                    values.add(dcv);
                }
                if (values.isEmpty()) {
                    Metadatum[] dcvs = new Metadatum[]{};
                    try {
                        dcvs = dao.queryMetadata(this.id, schema, element, qualifier, lang);
                    }
                    catch (SQLException e) {
                        log.error((Object)"caught exception: ", (Throwable)e);
                    }
                    if (dcvs != null) {
                        Collections.addAll(this.metadata, dcvs);
                    }
                    return dcvs;
                }
                Metadatum[] valueArray = new Metadatum[values.size()];
                valueArray = values.toArray(valueArray);
                return valueArray;
            }
            Metadatum[] dcvs = new Metadatum[]{};
            try {
                dcvs = dao.queryMetadata(this.id, schema, element, qualifier, lang);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
            }
            if (dcvs != null) {
                Collections.addAll(this.metadata, dcvs);
            }
            return dcvs;
        }
        catch (BrowseException be) {
            log.error((Object)"caught exception: ", (Throwable)be);
            return null;
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    public int getType(boolean real) {
        if (!real) {
            return 2;
        }
        return this.getType();
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    private boolean match(String schema, String element, String qualifier, String language, Metadatum dcv) {
        if (!element.equals("*") && !element.equals(dcv.element)) {
            return false;
        }
        if (qualifier == null ? dcv.qualifier != null : !qualifier.equals("*") && !qualifier.equals(dcv.qualifier)) {
            return false;
        }
        return !(language == null ? dcv.language != null : (!language.equals("*") ? !language.equals(dcv.language) : !schema.equals("*") && dcv.schema != null && !dcv.schema.equals(schema)));
    }

    @Override
    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
            }
        }
        return this.handle;
    }

    public Thumbnail getThumbnail() throws SQLException {
        Bundle[] thumbs;
        Item item = Item.find(this.ourContext, this.id);
        if (item == null) {
            return null;
        }
        Bundle[] original = item.getBundles("ORIGINAL");
        if (original.length == 0) {
            return null;
        }
        boolean html = false;
        if (original[0].getBitstreams().length > 1) {
            Bitstream[] bitstreams = original[0].getBitstreams();
            for (int i = 0; i < bitstreams.length && !html; ++i) {
                if (bitstreams[i].getID() != original[0].getPrimaryBitstreamID()) continue;
                html = bitstreams[i].getFormat().getMIMEType().equals("text/html");
            }
        }
        if ((thumbs = item.getBundles("THUMBNAIL")).length > 0 && !html) {
            Bitstream thumbnailBitstream;
            Bitstream originalBitstream;
            if (original[0].getBitstreams().length > 1 && original[0].getPrimaryBitstreamID() > -1) {
                originalBitstream = Bitstream.find(this.ourContext, original[0].getPrimaryBitstreamID());
                thumbnailBitstream = thumbs[0].getBitstreamByName(originalBitstream.getName() + ".jpg");
            } else {
                originalBitstream = original[0].getBitstreams()[0];
                thumbnailBitstream = thumbs[0].getBitstreams()[0];
            }
            if (thumbnailBitstream != null && AuthorizeManager.authorizeActionBoolean(this.ourContext, thumbnailBitstream, 0)) {
                return new Thumbnail(thumbnailBitstream, originalBitstream);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getMetadataFirstValue("dc", "title", null, "*");
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
    }

    @Override
    public void updateLastModified() {
    }

    public boolean isArchived() {
        return this.in_archive;
    }

    public boolean isWithdrawn() {
        return this.withdrawn;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }
}

