/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractPackageIngester;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.jdom.Element;

public abstract class AbstractMETSIngester
extends AbstractPackageIngester {
    private static Logger log = Logger.getLogger(AbstractMETSIngester.class);

    @Override
    public DSpaceObject ingest(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        METSManifest manifest = null;
        DSpaceObject dso = null;
        try {
            log.info((Object)LogManager.getHeader(context, "package_parse", "Parsing package for ingest, file=" + pkgFile.getName()));
            manifest = this.parsePackage(context, pkgFile, params);
            if (manifest == null) {
                throw new PackageValidationException("No METS Manifest found (filename=mets.xml).  Package is unacceptable!");
            }
            this.checkManifest(manifest);
            if (!params.restoreModeEnabled() && !params.containsKey("ignoreHandle")) {
                params.addProperty("ignoreHandle", "true");
            }
            if (parent != null && !params.containsKey("ignoreParent")) {
                params.addProperty("ignoreParent", "true");
            }
            if ((dso = this.ingestObject(context, parent, manifest, pkgFile, params, license)) != null) {
                String action = "package_ingest";
                if (params.restoreModeEnabled()) {
                    action = "package_restore";
                }
                log.info((Object)LogManager.getHeader(context, action, "Created new Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID())));
                if (params.recursiveModeEnabled()) {
                    String[] childFilePaths = manifest.getChildMetsFilePaths();
                    for (int i = 0; i < childFilePaths.length; ++i) {
                        this.addPackageReference(dso, childFilePaths[i]);
                    }
                }
            }
            return dso;
        }
        catch (SQLException se) {
            dso = null;
            throw se;
        }
    }

    protected METSManifest parsePackage(Context context, File pkgFile, PackageParameters params) throws IOException, SQLException, AuthorizeException, MetadataValidationException {
        boolean validate = params.getBooleanProperty("validate", false);
        METSManifest manifest = null;
        if (params.getBooleanProperty("manifestOnly", false)) {
            manifest = METSManifest.create(new FileInputStream(pkgFile), validate, this.getConfigurationName());
        } else {
            try (ZipFile zip = new ZipFile(pkgFile);){
                ZipEntry manifestEntry = zip.getEntry("mets.xml");
                if (manifestEntry != null) {
                    manifest = METSManifest.create(zip.getInputStream(manifestEntry), validate, this.getConfigurationName());
                }
            }
        }
        return manifest;
    }

    protected DSpaceObject ingestObject(Context context, DSpaceObject parent, METSManifest manifest, File pkgFile, PackageParameters params, String license) throws IOException, SQLException, AuthorizeException, CrosswalkException, MetadataValidationException, PackageValidationException {
        DSpaceObject dso;
        int type = this.getObjectType(manifest);
        if (!(type == 5 || parent != null && params.getBooleanProperty("ignoreParent", false))) {
            try {
                parent = this.getParentObject(context, manifest);
            }
            catch (UnsupportedOperationException e) {
                if (params.getBooleanProperty("skipIfParentMissing", false)) {
                    log.warn((Object)LogManager.getHeader(context, "package_ingest", "SKIPPING ingest of object '" + manifest.getObjID() + "' as parent DSpace Object could not be found. If you are running a recursive ingest, it is likely this object will be created as soon as its parent is created."));
                    return null;
                }
                throw e;
            }
        }
        String handle = null;
        if (!params.getBooleanProperty("ignoreHandle", false)) {
            handle = this.getObjectHandle(manifest);
        }
        try {
            dso = PackageUtils.createDSpaceObject(context, parent, type, handle, params);
        }
        catch (SQLException sqle) {
            throw new PackageValidationException("Exception while ingesting " + pkgFile.getPath(), sqle);
        }
        if (dso == null) {
            throw new PackageValidationException("Unable to initialize object specified by package (type='" + type + "', handle='" + handle + "' and parent='" + parent.getHandle() + "').");
        }
        MdrefManager callback = new MdrefManager(pkgFile, params);
        manifest.crosswalkObjectSourceMD(context, params, dso, callback);
        manifest.crosswalkObjectOtherAdminMD(context, params, dso, callback);
        this.crosswalkObjectDmd(context, dso, manifest, callback, manifest.getItemDmds(), params);
        if (type == 2) {
            PackageUtils.checkItemMetadata((Item)dso);
        }
        if (type == 2) {
            Item item = (Item)dso;
            WorkspaceItem wsi = WorkspaceItem.findByItem(context, item);
            Collection collection = item.getOwningCollection();
            if (collection == null && wsi != null) {
                collection = wsi.getCollection();
            }
            if (this.preserveManifest()) {
                this.addManifestBitstream(context, item, manifest);
            }
            this.addBitstreams(context, item, manifest, pkgFile, params, callback);
            this.addLicense(context, item, license, collection, params);
            this.finishObject(context, dso, params);
            if (wsi != null) {
                PackageUtils.finishCreateItem(context, wsi, handle, params);
            }
        } else if (type == 3 || type == 4) {
            this.addContainerLogo(context, dso, manifest, pkgFile, params);
            if (type == 3) {
                this.addTemplateItem(context, dso, manifest, pkgFile, params, callback);
            }
            this.finishObject(context, dso, params);
        } else if (type == 5) {
            this.finishObject(context, dso, params);
        } else {
            throw new PackageValidationException("Unknown DSpace Object type in package, type=" + String.valueOf(type));
        }
        PackageUtils.updateDSpaceObject(dso);
        return dso;
    }

    protected DSpaceObject replaceObject(Context context, DSpaceObject dso, METSManifest manifest, File pkgFile, PackageParameters params, String license) throws IOException, SQLException, AuthorizeException, CrosswalkException, MetadataValidationException, PackageValidationException {
        int manifestType = this.getObjectType(manifest);
        if (manifestType != dso.getType()) {
            throw new PackageValidationException("The object type of the METS manifest (" + Constants.typeText[manifestType] + ") does not match up with the object type (" + Constants.typeText[dso.getType()] + ") of the DSpaceObject to be replaced!");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Object to be replaced (handle=" + dso.getHandle() + ") is " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
        }
        PackageUtils.removeAllBitstreams(dso);
        PackageUtils.clearAllMetadata(dso);
        MdrefManager callback = new MdrefManager(pkgFile, params);
        manifest.crosswalkObjectSourceMD(context, params, dso, callback);
        manifest.crosswalkObjectOtherAdminMD(context, params, dso, callback);
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            if (this.preserveManifest()) {
                this.addManifestBitstream(context, item, manifest);
            }
            this.addBitstreams(context, item, manifest, pkgFile, params, callback);
            Collection owningCollection = (Collection)dso.getParentObject();
            if (owningCollection == null) {
                InProgressSubmission inProgressSubmission = WorkspaceItem.findByItem(context, item);
                if (inProgressSubmission == null) {
                    inProgressSubmission = ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow") ? XmlWorkflowItem.findByItem(context, item) : WorkflowItem.findByItem(context, item);
                }
                owningCollection = inProgressSubmission.getCollection();
            }
            this.addLicense(context, item, license, owningCollection, params);
        } else if (dso.getType() == 3 || dso.getType() == 4) {
            this.addContainerLogo(context, dso, manifest, pkgFile, params);
        } else if (dso.getType() == 5) {
            // empty if block
        }
        this.crosswalkObjectDmd(context, dso, manifest, callback, manifest.getItemDmds(), params);
        if (dso.getType() == 2) {
            PackageUtils.checkItemMetadata((Item)dso);
        }
        this.finishObject(context, dso, params);
        PackageUtils.updateDSpaceObject(dso);
        return dso;
    }

    protected void addBitstreams(Context context, Item item, METSManifest manifest, File pkgFile, PackageParameters params, MdrefManager mdRefCallback) throws SQLException, IOException, AuthorizeException, MetadataValidationException, CrosswalkException, PackageValidationException {
        String primaryID = null;
        Element primaryFile = manifest.getPrimaryOrLogoBitstream();
        if (primaryFile != null) {
            primaryID = primaryFile.getAttributeValue("ID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got primary bitstream file ID=\"" + primaryID + "\""));
            }
        }
        List<Element> manifestContentFiles = manifest.getContentFiles();
        List<Element> manifestBundleFiles = manifest.getBundleFiles();
        boolean setPrimaryBitstream = false;
        BitstreamFormat unknownFormat = BitstreamFormat.findUnknown(context);
        for (Element mfile : manifestContentFiles) {
            String mfileID = mfile.getAttributeValue("ID");
            if (mfileID == null) {
                throw new PackageValidationException("Invalid METS Manifest: file element without ID attribute.");
            }
            String path = METSManifest.getFileName(mfile);
            InputStream fileStream = AbstractMETSIngester.getFileInputStream(pkgFile, params, path);
            String bundleName = METSManifest.getBundleName(mfile);
            Bundle[] bns = item.getBundles(bundleName);
            Bundle bundle = bns != null && bns.length > 0 ? bns[0] : item.createBundle(bundleName);
            Bitstream bitstream = bundle.createBitstream(fileStream);
            bitstream.setName(path);
            String seqID = mfile.getAttributeValue("SEQ");
            if (seqID != null && !seqID.isEmpty()) {
                bitstream.setSequenceID(Integer.parseInt(seqID));
            }
            manifest.crosswalkBitstream(context, params, bitstream, mfileID, mdRefCallback);
            if (primaryID != null && mfileID.equals(primaryID)) {
                bundle.setPrimaryBitstreamID(bitstream.getID());
                bundle.update();
                setPrimaryBitstream = true;
            }
            this.finishBitstream(context, bitstream, mfile, manifest, params);
            if (bitstream.getFormat().equals(unknownFormat)) {
                String mimeType;
                BitstreamFormat bf;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Guessing format of Bitstream left un-set: " + bitstream.toString()));
                }
                BitstreamFormat bitstreamFormat = bf = (mimeType = mfile.getAttributeValue("MIMETYPE")) == null ? null : BitstreamFormat.findByMIMEType(context, mimeType);
                if (bf == null) {
                    bf = FormatIdentifier.guessFormat(context, bitstream);
                }
                bitstream.setFormat(bf);
            }
            bitstream.update();
        }
        for (Element mfile : manifestBundleFiles) {
            String bundleName = METSManifest.getBundleName(mfile, false);
            Bundle[] bns = item.getBundles(bundleName);
            Bundle bundle = bns != null && bns.length > 0 ? bns[0] : item.createBundle(bundleName);
            String mfileGrp = mfile.getAttributeValue("ADMID");
            if (mfileGrp != null) {
                manifest.crosswalkBundle(context, params, bundle, mfileGrp, mdRefCallback);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Ingesting bundle with no ADMID, not crosswalking bundle metadata");
            }
            bundle.update();
        }
        if (primaryID != null && !setPrimaryBitstream) {
            log.warn((Object)("Could not find primary bitstream file ID=\"" + primaryID + "\" in manifest file \"" + pkgFile.getAbsolutePath() + "\""));
        }
    }

    protected void addManifestBitstream(Context context, Item item, METSManifest manifest) throws IOException, SQLException, AuthorizeException, PackageValidationException {
        Bundle mdBundle = item.createBundle("METADATA");
        Bitstream manifestBitstream = mdBundle.createBitstream(manifest.getMetsAsStream());
        manifestBitstream.setName("mets.xml");
        manifestBitstream.setSource("mets.xml");
        manifestBitstream.update();
        String fmtName = this.getManifestBitstreamFormat();
        if (fmtName == null) {
            throw new PackageValidationException("Configuration Error: No Manifest BitstreamFormat configured for METS ingester type=" + this.getConfigurationName());
        }
        BitstreamFormat manifestFormat = PackageUtils.findOrCreateBitstreamFormat(context, fmtName, "application/xml", fmtName + " package manifest");
        manifestBitstream.setFormat(manifestFormat);
        manifestBitstream.update();
    }

    protected void addContainerLogo(Context context, DSpaceObject dso, METSManifest manifest, File pkgFile, PackageParameters params) throws SQLException, IOException, AuthorizeException, MetadataValidationException, PackageValidationException {
        Element logoRef = manifest.getPrimaryOrLogoBitstream();
        if (logoRef != null) {
            String logoID = logoRef.getAttributeValue("ID");
            for (Element mfile : manifest.getContentFiles()) {
                if (!logoID.equals(mfile.getAttributeValue("ID"))) continue;
                String path = METSManifest.getFileName(mfile);
                InputStream fileStream = AbstractMETSIngester.getFileInputStream(pkgFile, params, path);
                if (dso.getType() == 3) {
                    ((Collection)dso).setLogo(fileStream);
                    break;
                }
                ((Community)dso).setLogo(fileStream);
                break;
            }
        }
    }

    protected void addTemplateItem(Context context, DSpaceObject dso, METSManifest manifest, File pkgFile, PackageParameters params, MdrefManager callback) throws SQLException, IOException, AuthorizeException, CrosswalkException, PackageValidationException {
        if (dso.getType() != 3) {
            return;
        }
        Collection collection = (Collection)dso;
        List childObjList = manifest.getChildObjDivs();
        if (childObjList != null && !childObjList.isEmpty()) {
            String templateDmdIds;
            Element templateItemDiv = null;
            for (Element childDiv : childObjList) {
                String childType = childDiv.getAttributeValue("TYPE");
                if (!childType.contains(Constants.typeText[2]) || !childType.endsWith(" Template")) continue;
                templateItemDiv = childDiv;
                break;
            }
            if (templateItemDiv != null && (templateDmdIds = templateItemDiv.getAttributeValue("DMDID")) != null) {
                collection.createTemplateItem();
                Item templateItem = collection.getTemplateItem();
                Element[] templateDmds = manifest.getDmdElements(templateDmdIds);
                this.crosswalkObjectDmd(context, templateItem, manifest, callback, templateDmds, params);
                PackageUtils.updateDSpaceObject(templateItem);
            }
        }
    }

    @Override
    public DSpaceObject replace(Context context, DSpaceObject dsoToReplace, File pkgFile, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        METSManifest manifest = null;
        DSpaceObject dso = null;
        try {
            log.info((Object)LogManager.getHeader(context, "package_parse", "Parsing package for replace, file=" + pkgFile.getName()));
            manifest = this.parsePackage(context, pkgFile, params);
            if (manifest == null) {
                throw new PackageValidationException("No METS Manifest found (filename=mets.xml).  Package is unacceptable!");
            }
            if (dsoToReplace == null) {
                String handleURI = manifest.getObjID();
                String handle = this.decodeHandleURN(handleURI);
                try {
                    dsoToReplace = HandleManager.resolveToObject(context, handle);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (dsoToReplace == null) {
                dso = this.ingestObject(context, null, manifest, pkgFile, params, null);
                if (dso != null) {
                    log.info((Object)LogManager.getHeader(context, "package_replace", "Created new Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID())));
                }
            } else {
                dso = this.replaceObject(context, dsoToReplace, manifest, pkgFile, params, null);
                log.info((Object)LogManager.getHeader(context, "package_replace", "Replaced Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID())));
            }
            if (dso != null && params.recursiveModeEnabled()) {
                String[] childFilePaths = manifest.getChildMetsFilePaths();
                for (int i = 0; i < childFilePaths.length; ++i) {
                    this.addPackageReference(dso, childFilePaths[i]);
                }
            }
            return dso;
        }
        catch (SQLException se) {
            dso = null;
            throw se;
        }
    }

    protected boolean preserveManifest() {
        return ConfigurationManager.getBooleanProperty("mets." + this.getConfigurationName() + ".ingest.preserveManifest", false);
    }

    protected String getManifestBitstreamFormat() {
        return ConfigurationManager.getProperty("mets." + this.getConfigurationName() + ".ingest.manifestBitstreamFormat");
    }

    protected boolean useCollectionTemplate() {
        return ConfigurationManager.getBooleanProperty("mets." + this.getConfigurationName() + ".ingest.useCollectionTemplate", false);
    }

    protected String decodeHandleURN(String value) {
        if (value != null && value.startsWith("hdl:")) {
            return value.substring(4);
        }
        return null;
    }

    protected void removeObject(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
        }
        switch (dso.getType()) {
            case 2: {
                Collection[] collections;
                Item item = (Item)dso;
                for (Collection collection : collections = item.getCollections()) {
                    collection.removeItem(item);
                }
                context.removeCached(item, item.getID());
                item = null;
                break;
            }
            case 3: {
                Community[] communities;
                Collection collection = (Collection)dso;
                for (Community community : communities = collection.getCommunities()) {
                    community.removeCollection(collection);
                }
                context.removeCached(collection, collection.getID());
                collection = null;
                break;
            }
            case 4: {
                Community community = (Community)dso;
                community.delete();
                context.removeCached(community, community.getID());
                community = null;
            }
        }
    }

    public DSpaceObject getParentObject(Context context, METSManifest manifest) throws PackageValidationException, MetadataValidationException, SQLException {
        DSpaceObject parent = null;
        String parentLink = manifest.getParentOwnerLink();
        if (parentLink != null && parentLink.length() > 0) {
            parent = HandleManager.resolveToObject(context, parentLink);
            if (parent == null) {
                throw new UnsupportedOperationException("Could not find a parent DSpaceObject referenced as '" + parentLink + "' in the METS Manifest for object " + manifest.getObjID() + ". A parent DSpaceObject must be specified from either the 'packager' command or noted in the METS Manifest itself.");
            }
        } else {
            throw new UnsupportedOperationException("Could not find a parent DSpaceObject where we can ingest the packaged object " + manifest.getObjID() + ".  A parent DSpaceObject must be specified from either the 'packager' command or noted in the METS Manifest itself.");
        }
        return parent;
    }

    public String getObjectHandle(METSManifest manifest) throws PackageValidationException, MetadataValidationException, SQLException {
        String handleURI = manifest.getObjID();
        String handle = this.decodeHandleURN(handleURI);
        return handle;
    }

    protected static InputStream getFileInputStream(File pkgFile, PackageParameters params, String path) throws MetadataValidationException, IOException {
        if (params.getBooleanProperty("manifestOnly", false)) {
            try {
                URL fileURL = new URL(path);
                URLConnection connection = fileURL.openConnection();
                return connection.getInputStream();
            }
            catch (IOException io) {
                log.error((Object)("Unable to retrieve external file from URL '" + path + "' for manifest-only METS package.  All externally referenced files must be retrievable via URLs."));
                throw io;
            }
        }
        ZipFile zipPackage = new ZipFile(pkgFile);
        ZipEntry manifestEntry = zipPackage.getEntry(path);
        if (manifestEntry != null) {
            return zipPackage.getInputStream(manifestEntry);
        }
        throw new MetadataValidationException("Manifest file references file '" + path + "' not included in the zip.");
    }

    @Override
    public String getParameterHelp() {
        return "* ignoreHandle=[boolean]      If true, the ingester will ignore any Handle specified in the METS manifest itself, and instead create a new Handle during the ingest process (this is the default when running in Submit mode, using the -s flag). If false, the ingester attempts to restore the Handles specified in the METS manifest (this is the default when running in Restore/replace mode, using the -r flag). \n\n* ignoreParent=[boolean]      If true, the ingester will ignore any Parent object specified in the METS manifest itself, and instead ingest under a new Parent object (this is the default when running in Submit mode, using the -s flag). The new Parent object must be specified via the -p flag. If false, the ingester attempts to restore the object directly under its old Parent (this is the default when running in Restore/replace mode, using the -r flag). \n\n* manifestOnly=[boolean]      Specify true if the ingest package consists of just a METS manifest (mets.xml), without any content files (defaults to false).\n\n* validate=[boolean]      If true, enable XML validation of METS file using schemas in document (default is true).";
    }

    abstract void checkManifest(METSManifest var1) throws MetadataValidationException;

    public abstract void crosswalkObjectDmd(Context var1, DSpaceObject var2, METSManifest var3, MdrefManager var4, Element[] var5, PackageParameters var6) throws CrosswalkException, PackageValidationException, AuthorizeException, SQLException, IOException;

    public abstract void addLicense(Context var1, Item var2, String var3, Collection var4, PackageParameters var5) throws PackageValidationException, AuthorizeException, SQLException, IOException;

    public abstract void finishObject(Context var1, DSpaceObject var2, PackageParameters var3) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException;

    public abstract int getObjectType(METSManifest var1) throws PackageValidationException;

    public abstract void finishBitstream(Context var1, Bitstream var2, Element var3, METSManifest var4, PackageParameters var5) throws MetadataValidationException, SQLException, AuthorizeException, IOException;

    public abstract String getConfigurationName();

    protected static final class MdrefManager
    implements METSManifest.Mdref {
        private File packageFile = null;
        private PackageParameters params;

        private MdrefManager(File packageFile, PackageParameters params) {
            this.packageFile = packageFile;
            this.params = params;
        }

        @Override
        public InputStream getInputStream(Element mdref) throws MetadataValidationException, IOException {
            String path = METSManifest.getFileName(mdref);
            if (this.packageFile == null) {
                throw new MetadataValidationException("Failed referencing mdRef element, because there is no package specified.");
            }
            return AbstractMETSIngester.getFileInputStream(this.packageFile, this.params, path);
        }
    }
}

