/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.PCData;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.packager.AbstractMETSDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.license.CreativeCommons;

public class DSpaceMETSDisseminator
extends AbstractMETSDisseminator {
    private static final String PROFILE_LABEL = "DSpace METS SIP Profile 1.0";
    private static final String DSPACE_DEPOSIT_LICENSE_MDTYPE = "DSpaceDepositLicense:DSPACE_DEPLICENSE";
    private static final String CREATIVE_COMMONS_RDF_MDTYPE = "CreativeCommonsRDF:DSPACE_CCRDF";
    private static final String CREATIVE_COMMONS_TEXT_MDTYPE = "CreativeCommonsText:DSPACE_CCTXT";

    @Override
    public String getProfile() {
        return PROFILE_LABEL;
    }

    @Override
    public String bundleToFileGrp(String bname) {
        if (bname.equals("ORIGINAL")) {
            return "CONTENT";
        }
        return bname;
    }

    @Override
    public MetsHdr makeMetsHdr(Context context, DSpaceObject dso, PackageParameters params) {
        MetsHdr metsHdr = new MetsHdr();
        metsHdr.setCREATEDATE(new Date());
        Agent agent = new Agent();
        agent.setROLE(Role.CUSTODIAN);
        agent.setTYPE(Type.ORGANIZATION);
        Name name = new Name();
        name.getContent().add(new PCData(ConfigurationManager.getProperty("dspace.name")));
        agent.getContent().add(name);
        metsHdr.getContent().add(agent);
        return metsHdr;
    }

    @Override
    public String[] getDmdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String[] result = null;
        if (params != null) {
            result = params.getProperties("dmd");
        }
        if (result == null || result.length == 0) {
            result = new String[]{"MODS"};
        }
        return result;
    }

    @Override
    public String[] getTechMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        if (dso.getType() == 0) {
            String[] result = new String[]{"PREMIS"};
            return result;
        }
        return new String[0];
    }

    @Override
    public String[] getSourceMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        return new String[0];
    }

    @Override
    public String[] getDigiprovMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        return new String[0];
    }

    @Override
    public String[] getRightsMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        ArrayList<String> result = new ArrayList<String>();
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            if (PackageUtils.findDepositLicense(context, item) != null) {
                result.add(DSPACE_DEPOSIT_LICENSE_MDTYPE);
            }
            if (CreativeCommons.getLicenseRdfBitstream(item) != null) {
                result.add(CREATIVE_COMMONS_RDF_MDTYPE);
            } else if (CreativeCommons.getLicenseTextBitstream(item) != null) {
                result.add(CREATIVE_COMMONS_TEXT_MDTYPE);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void addStructMap(Context context, DSpaceObject dso, PackageParameters params, Mets mets) throws SQLException, IOException, AuthorizeException, MetsException {
    }

    @Override
    public boolean includeBundle(Bundle bundle) {
        return !PackageUtils.isMetaInfoBundle(bundle);
    }

    @Override
    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n* dmd=[dmdSecType]      (Repeatable) Type(s) of the METS <dmdSec> which should be created in the dissemination package (defaults to MODS)";
    }
}

