/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.utils.DSpace;

public class IndexClient {
    private static final Logger log = Logger.getLogger(IndexClient.class);

    public static void main(String[] args) throws SQLException, IOException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        String usage = "org.dspace.discovery.IndexClient [-cbhf[r <item handle>]] or nothing to update/clean an existing index.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        OptionBuilder.withArgName((String)"item handle");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"remove an Item, Collection or Community from index based on its handle");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"clean existing index removing any documents that no longer exist in the db");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"(re)build index, wiping out current one if it exists");
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Rebuild the spellchecker, can be combined with -b and -f.");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"if updating existing index, force each handle to be reindexed even if uptodate");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"print this help message");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"optimize search core");
        options.addOption(OptionBuilder.create((String)"o"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (Exception e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        if (line.hasOption("h")) {
            formatter.printHelp(usage, options);
            System.exit(1);
        }
        DSpace dspace = new DSpace();
        IndexingService indexer = (IndexingService)dspace.getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
        if (line.hasOption("r")) {
            log.info((Object)("Removing " + line.getOptionValue("r") + " from Index"));
            indexer.unIndexContent(context, line.getOptionValue("r"));
        } else if (line.hasOption("c")) {
            log.info((Object)"Cleaning Index");
            indexer.cleanIndex(line.hasOption("f"));
        } else if (line.hasOption("b")) {
            log.info((Object)"(Re)building index from scratch.");
            indexer.createIndex(context);
            IndexClient.checkRebuildSpellCheck(line, indexer);
        } else if (line.hasOption("o")) {
            log.info((Object)"Optimizing search core.");
            indexer.optimize();
        } else if (line.hasOption('s')) {
            IndexClient.checkRebuildSpellCheck(line, indexer);
        } else {
            log.info((Object)"Updating and Cleaning Index");
            indexer.cleanIndex(line.hasOption("f"));
            indexer.updateIndex(context, line.hasOption("f"));
            IndexClient.checkRebuildSpellCheck(line, indexer);
        }
        log.info((Object)"Done with indexing");
    }

    protected static void checkRebuildSpellCheck(CommandLine line, IndexingService indexer) throws SearchServiceException {
        if (line.hasOption("s")) {
            log.info((Object)"Rebuilding spell checker.");
            indexer.buildSpellCheck();
        }
    }
}

