/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.embargo.DefaultEmbargoSetter;
import org.dspace.embargo.EmbargoManager;

public class DayTableEmbargoSetter
extends DefaultEmbargoSetter {
    private Properties termProps = new Properties();

    public DayTableEmbargoSetter() {
        String terms = ConfigurationManager.getProperty("embargo.terms.days");
        if (terms != null && terms.length() > 0) {
            for (String term : terms.split(",")) {
                String[] parts = term.trim().split(":");
                this.termProps.setProperty(parts[0].trim(), parts[1].trim());
            }
        }
    }

    @Override
    public DCDate parseTerms(Context context, Item item, String terms) throws SQLException, AuthorizeException, IOException {
        if (terms != null) {
            if (this.termsOpen.equals(terms)) {
                return EmbargoManager.FOREVER;
            }
            String days = this.termProps.getProperty(terms);
            if (days != null && days.length() > 0) {
                long lift = System.currentTimeMillis() + Long.parseLong(days) * 24L * 60L * 60L * 1000L;
                return new DCDate(new Date(lift));
            }
        }
        return null;
    }
}

