/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Groomer {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3);

    public static void main(String[] argv) throws SQLException {
        String USAGE = "Groomer -verb [option...]";
        OptionGroup verbs = new OptionGroup();
        verbs.setRequired(true);
        verbs.addOption(new Option("h", "help", false, "explain this tool"));
        verbs.addOption(new Option("a", "aging", false, "discover accounts not used recently"));
        verbs.addOption(new Option("u", "unsalted", false, "list accounts with unsalted password hashes"));
        Options options = new Options();
        options.addOptionGroup(verbs);
        options.addOption("b", "last-used-before", true, "date of last login was before this (for example:  " + dateFormat.format(Calendar.getInstance().getTime()) + ')');
        options.addOption("d", "delete", false, "delete matching epersons");
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            if (!(ex instanceof MissingOptionException)) {
                new HelpFormatter().printHelp("Groomer -verb [option...]", options);
            }
            System.exit(1);
        }
        if (null == command || command.hasOption('h') || command.hasOption('?')) {
            new HelpFormatter().printHelp("Groomer -verb [option...]", options);
            System.exit(0);
        } else if (command.hasOption('a')) {
            Groomer.aging(command);
        } else if (command.hasOption('u')) {
            Groomer.findUnsalted();
        } else {
            System.err.println("Unimplemented verb:  " + verbs.getSelected());
        }
    }

    private static void aging(CommandLine command) throws SQLException {
        TableRow row;
        if (!command.hasOption('b')) {
            System.err.println("A last login date is required.");
            System.exit(1);
        }
        java.util.Date before = null;
        try {
            before = dateFormat.parse(command.getOptionValue('b'));
        }
        catch (java.text.ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        boolean delete = command.hasOption('d');
        Context myContext = new Context();
        TableRowIterator tri = DatabaseManager.queryTable(myContext, "EPerson", "SELECT eperson_id, email, netid FROM EPerson WHERE last_active < ?", new Date(before.getTime()));
        myContext.turnOffAuthorisationSystem();
        while (tri.hasNext() && null != (row = tri.next())) {
            int id = row.getIntColumn("eperson_id");
            EPerson account = EPerson.find(myContext, id);
            System.out.print(id);
            System.out.print('\t');
            System.out.print(account.getLastActive());
            System.out.print('\t');
            System.out.print(account.getEmail());
            System.out.print('\t');
            System.out.print(account.getNetid());
            System.out.print('\t');
            System.out.print(account.getFullName());
            System.out.println();
            if (!delete) continue;
            List<String> whyNot = account.getDeleteConstraints();
            if (!whyNot.isEmpty()) {
                System.out.print("\tCannot be deleted; referenced in");
                for (String table : whyNot) {
                    System.out.print(' ');
                    System.out.print(table);
                }
                System.out.println();
                continue;
            }
            try {
                account.delete();
            }
            catch (AuthorizeException | EPersonDeletionException ex) {
                System.err.println(ex.getMessage());
            }
        }
        myContext.restoreAuthSystemState();
        myContext.complete();
    }

    private static void findUnsalted() throws SQLException {
        Context myContext = new Context();
        TableRowIterator tri = DatabaseManager.query(myContext, "SELECT email FROM EPerson WHERE password IS NOT NULL AND digest_algorithm IS NULL", new Object[0]);
        TableRow row = tri.next();
        while (tri.hasNext()) {
            System.out.println(row.getStringColumn("email"));
            row = tri.next();
        }
        myContext.abort();
    }
}

