/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.util.StreamTable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MultiRemoteDSpaceRepositoryHandlePlugin
implements HandleStorage {
    private static String CONFIG_FILE_NAME = "handle-dspace-plugin.cfg";
    private static String PROPERTY_KEY = "dspace.handle.endpoint";
    private static Logger log = Logger.getLogger(MultiRemoteDSpaceRepositoryHandlePlugin.class);
    private Map<String, String> prefixes;

    public void init(StreamTable st) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called init");
        }
        this.prefixes = new HashMap<String, String>();
        Properties properties = this.loadProperties(CONFIG_FILE_NAME);
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith(PROPERTY_KEY)) continue;
            this.loadPrefixes(properties.getProperty(propertyName));
        }
        if (this.prefixes.isEmpty()) {
            throw new HandleException(1, "Unable to find configuration or to reach any DSpace instance.");
        }
        if (log.isInfoEnabled()) {
            for (String prefix : this.prefixes.keySet()) {
                log.info((Object)("Loaded Prefix " + prefix + " from " + this.prefixes.get(prefix)));
            }
        }
    }

    public void setHaveNA(byte[] theHandle, boolean haveit) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called setHaveNA (not implemented)");
        }
    }

    public void createHandle(byte[] theHandle, HandleValue[] values) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called createHandle (not implemented)");
        }
    }

    public boolean deleteHandle(byte[] theHandle) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called deleteHandle (not implemented)");
        }
        return false;
    }

    public void updateValue(byte[] theHandle, HandleValue[] values) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called updateValue (not implemented)");
        }
    }

    public void deleteAllRecords() throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called deleteAllRecords (not implemented)");
        }
    }

    public void checkpointDatabase() throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called checkpointDatabase (not implemented)");
        }
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called shutdown (not implemented)");
        }
    }

    public void scanHandles(ScanCallback callback) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called scanHandles (not implemented)");
        }
    }

    public void scanNAs(ScanCallback callback) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called scanNAs (not implemented)");
        }
    }

    public byte[][] getRawHandleValues(byte[] theHandle, int[] indexList, byte[][] typeList) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called getRawHandleValues");
        }
        if (theHandle == null) {
            throw new HandleException(1);
        }
        String handle = Util.decodeString((byte[])theHandle);
        String url = this.getRemoteDSpaceURL(handle);
        HandleValue value = new HandleValue();
        value.setIndex(100);
        value.setType(Util.encodeString((String)"URL"));
        value.setData(Util.encodeString((String)url));
        value.setTTLType((byte)0);
        value.setTTL(100);
        value.setTimestamp(100);
        value.setReferences(null);
        value.setAdminCanRead(true);
        value.setAdminCanWrite(false);
        value.setAnyoneCanRead(true);
        value.setAnyoneCanWrite(false);
        LinkedList<HandleValue> values = new LinkedList<HandleValue>();
        values.add(value);
        byte[][] rawValues = new byte[values.size()][];
        for (int i = 0; i < values.size(); ++i) {
            HandleValue hvalue = (HandleValue)values.get(i);
            rawValues[i] = new byte[Encoder.calcStorageSize((HandleValue)hvalue)];
            Encoder.encodeHandleValue((byte[])rawValues[i], (int)0, (HandleValue)hvalue);
        }
        return rawValues;
    }

    private String getRemoteDSpaceURL(String handle) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Called getRemoteDSpaceURL(" + handle + ")."));
        }
        InputStreamReader jsonStreamReader = null;
        String url = null;
        try {
            String prefix = handle.split("/")[0];
            String endpoint = this.prefixes.get(prefix);
            if (endpoint == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot find endpoint for prefix " + prefix + ", throw HANDLE_DOES_NOT_EXIST."));
                }
                throw new HandleException(9);
            }
            JsonParser parser = new JsonParser();
            String jsonurl = endpoint + "/resolve/" + handle;
            jsonStreamReader = new InputStreamReader(new URL(jsonurl).openStream(), "UTF-8");
            JsonElement jsonElement = parser.parse((Reader)jsonStreamReader);
            if (jsonElement == null || jsonElement.isJsonNull() || jsonElement.getAsJsonArray().size() == 0 || jsonElement.getAsJsonArray().get(0).isJsonNull()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Throw HandleException: HANDLE_DOES_NOT_EXIST.");
                }
                throw new HandleException(9);
            }
            url = jsonElement.getAsJsonArray().get(0).getAsString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in getRawHandleValues", (Throwable)e);
            }
            throw new HandleException(1);
        }
        finally {
            if (jsonStreamReader != null) {
                try {
                    jsonStreamReader.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRemoteDspaceURL returns " + url));
        }
        return url;
    }

    public boolean haveNA(byte[] theHandle) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called haveNA");
        }
        String received = Util.decodeString((byte[])theHandle).substring("0.NA/".length());
        return this.prefixes.containsKey(received);
    }

    public Enumeration getHandlesForNA(byte[] theNAHandle) throws HandleException {
        String naHandle = Util.decodeString((byte[])theNAHandle);
        if (log.isInfoEnabled()) {
            log.info((Object)("Called getHandlesForNA for NA " + naHandle));
        }
        List<String> handles = this.getRemoteDSpaceHandles(naHandle);
        LinkedList<byte[]> results = new LinkedList<byte[]>();
        for (String handle : handles) {
            results.add(Util.encodeString((String)handle));
        }
        return Collections.enumeration(results);
    }

    private List<String> getRemoteDSpaceHandles(String naHandle) throws HandleException {
        ArrayList<String> handles = new ArrayList<String>();
        String endpoint = this.prefixes.get(naHandle);
        if (null == endpoint) {
            return handles;
        }
        InputStreamReader jsonStreamReader = null;
        try {
            String jsonurl = endpoint + "/listhandles/" + naHandle;
            jsonStreamReader = new InputStreamReader(new URL(jsonurl).openStream(), "UTF-8");
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)jsonStreamReader);
            if (jsonElement != null && jsonElement.getAsJsonArray().size() != 0) {
                for (int i = 0; i < jsonElement.getAsJsonArray().size(); ++i) {
                    handles.add(jsonElement.getAsJsonArray().get(i).getAsString());
                }
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in getHandlesForNA", (Throwable)e);
            }
            throw new HandleException(1);
        }
        finally {
            if (jsonStreamReader != null) {
                try {
                    jsonStreamReader.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return handles;
    }

    private Properties loadProperties(String filename) throws IOException {
        InputStream is = this.findConfigFile(filename);
        Properties props = new Properties();
        InputStreamReader ir = null;
        try {
            ir = new InputStreamReader(is, "UTF-8");
            props.load(ir);
        }
        catch (UnsupportedEncodingException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Caught an UnsupportedEncodingException while loading configuration: " + ex.getMessage()));
            }
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Caught an IOException while loading configuration: " + ex.getMessage()));
            }
            throw ex;
        }
        finally {
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    private InputStream findConfigFile(String filename) {
        FileInputStream is;
        block16: {
            block15: {
                is = null;
                try {
                    String configProperty = System.getProperty("dspace.handle.plugin.configuration");
                    if (null != configProperty) {
                        is = new FileInputStream(configProperty);
                    }
                }
                catch (SecurityException se) {
                    log.warn((Object)"Unable to access system properties, ignoring.", (Throwable)se);
                }
                catch (FileNotFoundException fne) {
                    log.warn((Object)("Unable to find config file as defined by system property: " + fne.getMessage()));
                }
                if (null == is) {
                    URL url = MultiRemoteDSpaceRepositoryHandlePlugin.class.getResource("/" + filename);
                    if (null == url) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Cannot find configuration by using getResource().");
                        }
                    } else {
                        try {
                            is = new FileInputStream(url.getPath());
                            log.warn((Object)("Falling back to default locations, found configuration at: " + url.getPath()));
                        }
                        catch (FileNotFoundException e) {
                            if (!log.isInfoEnabled()) break block15;
                            log.info((Object)("Unable to open fallback configuration: " + e.getMessage()));
                        }
                    }
                }
            }
            if (null == is) {
                try {
                    is = new FileInputStream("./" + filename);
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Loaded configuration from your current working directory where you started the handle server.");
                    }
                }
                catch (FileNotFoundException ex) {
                    if (!log.isInfoEnabled()) break block16;
                    log.info((Object)("Can't load config file: " + ex.getMessage()));
                }
            }
        }
        if (is == null) {
            throw new IllegalStateException("Cannot find configuration.");
        }
        return is;
    }

    private void loadPrefixes(String endpoint) {
        URL url = null;
        try {
            url = new URL(endpoint + "/listprefixes");
        }
        catch (MalformedURLException ex) {
            log.error((Object)(endpoint + "is not a correct URL, will ignore this DSpace instance."), (Throwable)ex);
        }
        try {
            InputStreamReader jsonStreamReader = new InputStreamReader(url.openStream(), "UTF-8");
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)jsonStreamReader);
            if (jsonElement != null && jsonElement.getAsJsonArray().size() != 0) {
                for (int i = 0; i < jsonElement.getAsJsonArray().size(); ++i) {
                    String prefix = jsonElement.getAsJsonArray().get(i).getAsString();
                    this.prefixes.put(prefix, endpoint);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Mapping " + prefix + " to instance at " + endpoint));
                }
            } else {
                log.warn((Object)("DSpace instance running at " + url + " returns empty prefix list."));
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error while loading prefixes from " + endpoint + ", ignoring."), (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        MultiRemoteDSpaceRepositoryHandlePlugin multi = new MultiRemoteDSpaceRepositoryHandlePlugin();
        try {
            System.out.println(StringUtils.join(multi.getRemoteDSpaceHandles("123456789"), (String)","));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(StringUtils.join(multi.getRemoteDSpaceHandles("123456780"), (String)","));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(multi.getRemoteDSpaceURL("123456789/1"));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(multi.getRemoteDSpaceURL("123456789/1111111"));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(multi.getRemoteDSpaceURL("123456780/1"));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(multi.getRemoteDSpaceURL("123456780/1111111"));
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
    }
}

