/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.MetadataExposure;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.rdf.RDFUtil;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.rdf.conversion.DMRM;
import org.dspace.rdf.conversion.MetadataRDFMapping;
import org.dspace.services.ConfigurationService;

public class MetadataConverterPlugin
implements ConverterPlugin {
    public static final String METADATA_MAPPING_PATH_KEY = "rdf.metadata.mappings";
    public static final String METADATA_SCHEMA_URL_KEY = "rdf.metadata.schema";
    public static final String METADATA_PREFIXES_KEY = "rdf.metadata.prefixes";
    private static final Logger log = Logger.getLogger(MetadataConverterPlugin.class);
    protected ConfigurationService configurationService;

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException, AuthorizeException {
        Metadatum[] metadata_values;
        Model config;
        String uri = RDFUtil.generateIdentifier(context, dso);
        if (uri == null) {
            log.error((Object)("Cannot create URI for " + dso.getTypeText() + " " + dso.getID() + " stopping conversion."));
            return null;
        }
        Model convertedData = ModelFactory.createDefaultModel();
        String prefixesPath = this.configurationService.getProperty(METADATA_PREFIXES_KEY);
        if (!StringUtils.isEmpty((String)prefixesPath)) {
            InputStream is = FileManager.get().open(prefixesPath);
            if (is == null) {
                log.warn((Object)("Cannot find file '" + prefixesPath + "', ignoring..."));
            } else {
                convertedData.read(is, null, FileUtils.guessLang((String)prefixesPath));
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((config = this.loadConfiguration()) == null) {
            log.error((Object)"Cannot load MetadataConverterPlugin configuration, skipping this plugin.");
            return null;
        }
        ResIterator mappingIter = config.listSubjectsWithProperty(RDF.type, (RDFNode)DMRM.DSpaceMetadataRDFMapping);
        if (!mappingIter.hasNext()) {
            log.warn((Object)"No metadata mappings found, returning null.");
            return null;
        }
        ArrayList<MetadataRDFMapping> mappings = new ArrayList<MetadataRDFMapping>();
        while (mappingIter.hasNext()) {
            MetadataRDFMapping mapping = MetadataRDFMapping.getMetadataRDFMapping(mappingIter.nextResource(), uri);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        if (!(dso instanceof Item)) {
            log.error((Object)("This DspaceObject (" + dso.getTypeText() + " " + dso.getID() + ") should not have bin submitted to this plugin, as it supports Items only!"));
            return null;
        }
        Item item = (Item)dso;
        for (Metadatum value : metadata_values = item.getDC("*", "*", "*")) {
            String fieldname = value.schema + "." + value.element;
            if (value.qualifier != null) {
                fieldname = fieldname + "." + value.qualifier;
            }
            if (MetadataExposure.isHidden(context, value.schema, value.element, value.qualifier)) {
                log.debug((Object)(fieldname + " is a hidden metadata field, won't convert it."));
                continue;
            }
            boolean converted = false;
            if (value.qualifier != null) {
                for (MetadataRDFMapping mapping : mappings) {
                    if (!mapping.matchesName(fieldname) || !mapping.fulfills(value.value)) continue;
                    mapping.convert(value.value, value.language, uri, convertedData);
                    converted = true;
                }
            }
            if (!converted) {
                String name = value.schema + "." + value.element;
                Iterator iter = mappings.iterator();
                while (iter.hasNext() && !converted) {
                    MetadataRDFMapping mapping = (MetadataRDFMapping)iter.next();
                    if (!mapping.matchesName(name) || !mapping.fulfills(value.value)) continue;
                    mapping.convert(value.value, value.language, uri, convertedData);
                    converted = true;
                }
            }
            if (converted) continue;
            log.debug((Object)("Did not convert " + fieldname + ". Found no corresponding mapping."));
        }
        config.close();
        if (convertedData.isEmpty()) {
            convertedData.close();
            return null;
        }
        return convertedData;
    }

    @Override
    public boolean supports(int type) {
        return type == 2;
    }

    protected Model loadConfiguration() {
        String mappingPathes = this.configurationService.getProperty(METADATA_MAPPING_PATH_KEY);
        if (StringUtils.isEmpty((String)mappingPathes)) {
            return null;
        }
        String[] mappings = mappingPathes.split(",\\s*");
        if (mappings == null || mappings.length == 0) {
            log.error((Object)"Cannot find metadata mappings (looking for property rdf.metadata.mappings)!");
            return null;
        }
        InputStream is = null;
        Model config = ModelFactory.createDefaultModel();
        for (String mappingPath : mappings) {
            is = FileManager.get().open(mappingPath);
            if (is == null) {
                log.warn((Object)("Cannot find file '" + mappingPath + "', ignoring..."));
            }
            config.read(is, "file://" + mappingPath, FileUtils.guessLang((String)mappingPath));
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (config.isEmpty()) {
            config.close();
            log.warn((Object)"Metadata RDF Mapping did not contain any triples!");
            return null;
        }
        String schemaURL = this.configurationService.getProperty(METADATA_SCHEMA_URL_KEY);
        if (schemaURL == null) {
            log.error((Object)"Cannot find metadata rdf mapping schema (looking for property rdf.metadata.schema)!");
        }
        if (!StringUtils.isEmpty((String)schemaURL)) {
            log.debug((Object)"Going to inference over the rdf metadata mapping.");
            Model schema = ModelFactory.createDefaultModel();
            schema.read(schemaURL);
            Reasoner reasoner = ReasonerRegistry.getRDFSSimpleReasoner().bindSchema(schema);
            InfModel inf = ModelFactory.createInfModel((Reasoner)reasoner, (Model)config);
            ValidityReport reports = inf.validate();
            if (!reports.isValid()) {
                StringBuilder sb = new StringBuilder();
                sb.append("The configuration of the MetadataConverterPlugin is ");
                sb.append("not valid regarding the schema (");
                sb.append(DMRM.getURI());
                sb.append(").\nThe following problems were encountered:\n");
                Iterator iter = reports.getReports();
                while (iter.hasNext()) {
                    ValidityReport.Report report = (ValidityReport.Report)iter.next();
                    if (!report.isError) continue;
                    sb.append(" - " + iter.next() + "\n");
                }
                log.error((Object)sb.toString());
                return null;
            }
            return inf;
        }
        return config;
    }
}

